/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.transaction.xa.XAResource;
import org.infinispan.Cache;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.SuppliedValueService;

public class XAResourceRecoveryBuilder
implements Builder<XAResourceRecovery> {
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<XAResourceRecoveryRegistry> registry = new InjectedValue();
    private final PathAddress cacheAddress;

    public XAResourceRecoveryBuilder(PathAddress cacheAddress) {
        this.cacheAddress = cacheAddress;
    }

    public ServiceName getServiceName() {
        return CacheResourceDefinition.Capability.CACHE.getServiceName(this.cacheAddress).append(new String[]{"recovery"});
    }

    public ServiceBuilder<XAResourceRecovery> build(ServiceTarget target) {
        Supplier<XAResourceRecovery> supplier = () -> {
            InfinispanXAResourceRecovery recovery;
            Cache cache = (Cache)this.cache.getValue();
            InfinispanXAResourceRecovery infinispanXAResourceRecovery = recovery = cache.getCacheConfiguration().transaction().recovery().enabled() ? new InfinispanXAResourceRecovery(cache) : null;
            if (recovery != null) {
                ((XAResourceRecoveryRegistry)this.registry.getValue()).addXAResourceRecovery((XAResourceRecovery)recovery);
            }
            return recovery;
        };
        Consumer<XAResourceRecovery> destroyer = recovery -> {
            if (recovery != null) {
                ((XAResourceRecoveryRegistry)this.registry.getValue()).removeXAResourceRecovery(recovery);
            }
        };
        SuppliedValueService service = new SuppliedValueService(Function.identity(), supplier, destroyer);
        return target.addService(this.getServiceName(), (Service)service).addDependency(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, XAResourceRecoveryRegistry.class, this.registry).addDependency(CacheResourceDefinition.Capability.CACHE.getServiceName(this.cacheAddress), Cache.class, this.cache).setInitialMode(ServiceController.Mode.PASSIVE);
    }

    private static class InfinispanXAResourceRecovery
    implements XAResourceRecovery {
        private final Cache<?, ?> cache;

        InfinispanXAResourceRecovery(Cache<?, ?> cache) {
            this.cache = cache;
        }

        public XAResource[] getXAResources() {
            return new XAResource[]{this.cache.getAdvancedCache().getXAResource()};
        }

        public int hashCode() {
            return this.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName().hashCode() ^ this.cache.getName().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof InfinispanXAResourceRecovery)) {
                return false;
            }
            InfinispanXAResourceRecovery recovery = (InfinispanXAResourceRecovery)object;
            return this.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName().equals(recovery.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName()) && this.cache.getName().equals(recovery.cache.getName());
        }

        public String toString() {
            return this.cache.getCacheManager().getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName() + "." + this.cache.getName();
        }
    }
}

