/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.Set;
import org.jboss.modules.ClassLoaderLocalLoader;
import org.jboss.modules.Dependency;
import org.jboss.modules.LocalDependencySpecBuilder;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.ClassFilter;
import org.jboss.modules.filter.ClassFilters;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public abstract class DependencySpec {
    final PathFilter importFilter;
    final PathFilter exportFilter;
    final PathFilter resourceImportFilter;
    final PathFilter resourceExportFilter;
    final ClassFilter classImportFilter;
    final ClassFilter classExportFilter;
    public static final DependencySpec OWN_DEPENDENCY = new LocalDependencySpecBuilder().setExportFilter(PathFilters.acceptAll()).build();

    public PathFilter getImportFilter() {
        return this.importFilter;
    }

    public PathFilter getExportFilter() {
        return this.exportFilter;
    }

    public PathFilter getResourceImportFilter() {
        return this.resourceImportFilter;
    }

    public PathFilter getResourceExportFilter() {
        return this.resourceExportFilter;
    }

    public ClassFilter getClassImportFilter() {
        return this.classImportFilter;
    }

    public ClassFilter getClassExportFilter() {
        return this.classExportFilter;
    }

    DependencySpec(PathFilter importFilter, PathFilter exportFilter, PathFilter resourceImportFilter, PathFilter resourceExportFilter, ClassFilter classImportFilter, ClassFilter classExportFilter) {
        this.importFilter = importFilter;
        this.exportFilter = exportFilter;
        this.resourceImportFilter = resourceImportFilter;
        this.resourceExportFilter = resourceExportFilter;
        this.classImportFilter = classImportFilter;
        this.classExportFilter = classExportFilter;
    }

    abstract Dependency getDependency(Module var1);

    public static DependencySpec createLocalDependencySpec() {
        return OWN_DEPENDENCY;
    }

    @Deprecated
    public static DependencySpec createLocalDependencySpec(PathFilter importFilter, PathFilter exportFilter) {
        return new LocalDependencySpecBuilder().setImportFilter(importFilter).setExportFilter(exportFilter).build();
    }

    @Deprecated
    public static DependencySpec createLocalDependencySpec(PathFilter importFilter, PathFilter exportFilter, PathFilter resourceImportFilter, PathFilter resourceExportFilter, ClassFilter classImportFilter, ClassFilter classExportFilter) {
        return new LocalDependencySpecBuilder().setImportFilter(importFilter).setExportFilter(exportFilter).setResourceImportFilter(resourceImportFilter).setResourceExportFilter(resourceExportFilter).setClassImportFilter(classImportFilter).setClassExportFilter(classExportFilter).build();
    }

    public static DependencySpec createSystemDependencySpec(Set<String> loaderPaths) {
        return new LocalDependencySpecBuilder().setImportFilter(PathFilters.acceptAll()).setLocalLoader(ClassLoaderLocalLoader.SYSTEM).setLoaderPaths(loaderPaths).build();
    }

    public static DependencySpec createSystemDependencySpec(Set<String> loaderPaths, boolean export) {
        return new LocalDependencySpecBuilder().setLocalLoader(ClassLoaderLocalLoader.SYSTEM).setImportFilter(PathFilters.acceptAll()).setLoaderPaths(loaderPaths).setExport(export).build();
    }

    public static DependencySpec createSystemDependencySpec(PathFilter importFilter, PathFilter exportFilter, Set<String> loaderPaths) {
        return new LocalDependencySpecBuilder().setImportFilter(importFilter).setExportFilter(exportFilter).setLocalLoader(ClassLoaderLocalLoader.SYSTEM).setLoaderPaths(loaderPaths).build();
    }

    @Deprecated
    public static DependencySpec createClassLoaderDependencySpec(ClassLoader classLoader, Set<String> loaderPaths) {
        return DependencySpec.createLocalDependencySpec(new ClassLoaderLocalLoader(classLoader), loaderPaths);
    }

    @Deprecated
    public static DependencySpec createClassLoaderDependencySpec(ClassLoader classLoader, Set<String> loaderPaths, boolean export) {
        return DependencySpec.createLocalDependencySpec(new ClassLoaderLocalLoader(classLoader), loaderPaths, export);
    }

    @Deprecated
    public static DependencySpec createClassLoaderDependencySpec(PathFilter importFilter, PathFilter exportFilter, ClassLoader classLoader, Set<String> loaderPaths) {
        return DependencySpec.createLocalDependencySpec(importFilter, exportFilter, new ClassLoaderLocalLoader(classLoader), loaderPaths);
    }

    @Deprecated
    public static DependencySpec createLocalDependencySpec(LocalLoader localLoader, Set<String> loaderPaths) {
        return new LocalDependencySpecBuilder().setLocalLoader(localLoader).setLoaderPaths(loaderPaths).build();
    }

    @Deprecated
    public static DependencySpec createLocalDependencySpec(LocalLoader localLoader, Set<String> loaderPaths, boolean export) {
        return new LocalDependencySpecBuilder().setLocalLoader(localLoader).setLoaderPaths(loaderPaths).setExport(export).build();
    }

    @Deprecated
    public static DependencySpec createLocalDependencySpec(PathFilter importFilter, PathFilter exportFilter, LocalLoader localLoader, Set<String> loaderPaths) {
        return new LocalDependencySpecBuilder().setImportFilter(importFilter).setExportFilter(exportFilter).setLocalLoader(localLoader).setLoaderPaths(loaderPaths).build();
    }

    @Deprecated
    public static DependencySpec createLocalDependencySpec(PathFilter importFilter, PathFilter exportFilter, PathFilter resourceImportFilter, PathFilter resourceExportFilter, ClassFilter classImportFilter, ClassFilter classExportFilter, LocalLoader localLoader, Set<String> loaderPaths) {
        return new LocalDependencySpecBuilder().setImportFilter(importFilter).setExportFilter(exportFilter).setResourceImportFilter(resourceImportFilter).setResourceExportFilter(resourceExportFilter).setClassImportFilter(classImportFilter).setClassExportFilter(classExportFilter).setLocalLoader(localLoader).setLoaderPaths(loaderPaths).build();
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(ModuleIdentifier identifier) {
        return DependencySpec.createModuleDependencySpec(identifier.toString());
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(String name) {
        return new ModuleDependencySpecBuilder().setName(name).build();
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(ModuleIdentifier identifier, boolean export) {
        return DependencySpec.createModuleDependencySpec(identifier.toString(), export);
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(String name, boolean export) {
        return new ModuleDependencySpecBuilder().setName(name).setExport(export).build();
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(ModuleIdentifier identifier, boolean export, boolean optional) {
        return DependencySpec.createModuleDependencySpec(identifier.toString(), export, optional);
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(String name, boolean export, boolean optional) {
        return new ModuleDependencySpecBuilder().setName(name).setExport(export).setOptional(optional).build();
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean export) {
        return DependencySpec.createModuleDependencySpec(moduleLoader, identifier.toString(), export);
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(ModuleLoader moduleLoader, String name, boolean export) {
        return new ModuleDependencySpecBuilder().setModuleLoader(moduleLoader).setName(name).setExport(export).build();
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean export, boolean optional) {
        return DependencySpec.createModuleDependencySpec(moduleLoader, identifier.toString(), export, optional);
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(ModuleLoader moduleLoader, String name, boolean export, boolean optional) {
        return new ModuleDependencySpecBuilder().setModuleLoader(moduleLoader).setName(name).setExport(export).setOptional(optional).build();
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(PathFilter exportFilter, ModuleIdentifier identifier, boolean optional) {
        return DependencySpec.createModuleDependencySpec(exportFilter, identifier.toString(), optional);
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(PathFilter exportFilter, String name, boolean optional) {
        return new ModuleDependencySpecBuilder().setExportFilter(exportFilter).setName(name).setOptional(optional).build();
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(PathFilter exportFilter, ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean optional) {
        return DependencySpec.createModuleDependencySpec(exportFilter, moduleLoader, identifier.toString(), optional);
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(PathFilter exportFilter, ModuleLoader moduleLoader, String name, boolean optional) {
        return new ModuleDependencySpecBuilder().setExportFilter(exportFilter).setModuleLoader(moduleLoader).setName(name).setOptional(optional).build();
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(PathFilter importFilter, PathFilter exportFilter, ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean optional) {
        return DependencySpec.createModuleDependencySpec(importFilter, exportFilter, PathFilters.acceptAll(), PathFilters.acceptAll(), ClassFilters.acceptAll(), ClassFilters.acceptAll(), moduleLoader, identifier, optional);
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(PathFilter importFilter, PathFilter exportFilter, ModuleLoader moduleLoader, String name, boolean optional) {
        return new ModuleDependencySpecBuilder().setImportFilter(importFilter).setExportFilter(exportFilter).setModuleLoader(moduleLoader).setName(name).setOptional(optional).build();
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(PathFilter importFilter, PathFilter exportFilter, PathFilter resourceImportFilter, PathFilter resourceExportFilter, ClassFilter classImportFilter, ClassFilter classExportFilter, ModuleLoader moduleLoader, ModuleIdentifier identifier, boolean optional) {
        return DependencySpec.createModuleDependencySpec(importFilter, exportFilter, resourceImportFilter, resourceExportFilter, classImportFilter, classExportFilter, moduleLoader, identifier.toString(), optional);
    }

    @Deprecated
    public static DependencySpec createModuleDependencySpec(PathFilter importFilter, PathFilter exportFilter, PathFilter resourceImportFilter, PathFilter resourceExportFilter, ClassFilter classImportFilter, ClassFilter classExportFilter, ModuleLoader moduleLoader, String name, boolean optional) {
        return new ModuleDependencySpecBuilder().setImportFilter(importFilter).setExportFilter(exportFilter).setResourceImportFilter(resourceImportFilter).setResourceExportFilter(resourceExportFilter).setClassImportFilter(classImportFilter).setClassExportFilter(classExportFilter).setModuleLoader(moduleLoader).setName(name).setOptional(optional).build();
    }
}

