/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import org.jboss.as.jpa.container.ThreadLocalStack;
import org.jboss.as.jpa.messages.JpaLogger;

public class NonTxEmCloser {
    public static final ThreadLocalStack<Map<String, EntityManager>> nonTxStack = new ThreadLocalStack();

    public static void pushCall() {
        nonTxStack.push(null);
    }

    public static void popCall() {
        Map<String, EntityManager> emStack = nonTxStack.pop();
        if (emStack != null) {
            for (EntityManager entityManager : emStack.values()) {
                try {
                    if (!entityManager.isOpen()) continue;
                    entityManager.close();
                }
                catch (RuntimeException safeToIgnore) {
                    if (!JpaLogger.ROOT_LOGGER.isTraceEnabled()) continue;
                    JpaLogger.ROOT_LOGGER.trace("Could not close (non-transactional) container managed entity manager.  This shouldn't impact application functionality (only read operations occur in non-transactional mode)", safeToIgnore);
                }
            }
        }
    }

    public static EntityManager get(String puScopedName) {
        Map<String, EntityManager> map = nonTxStack.peek();
        if (map != null) {
            return map.get(puScopedName);
        }
        return null;
    }

    public static void add(String puScopedName, EntityManager entityManager) {
        Map<String, EntityManager> map = nonTxStack.peek();
        if (map == null && !nonTxStack.isEmpty()) {
            map = new HashMap<String, EntityManager>();
            nonTxStack.pop();
            nonTxStack.push(map);
        }
        if (map != null) {
            map.put(puScopedName, entityManager);
        }
    }
}

