/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.jmx.logging.JmxLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.dmr.ValueExpression;

class TypeConverters {
    static final Pattern VAULT_PATTERN = Pattern.compile("\\$\\{VAULT::.*::.*::.*\\}");
    private static final SimpleTypeConverter BIG_DECIMAL_NO_EXPR = new SimpleTypeConverter(BigDecimalValueAccessor.INSTANCE, false);
    private static final SimpleTypeConverter BIG_DECIMAL_EXPR = new SimpleTypeConverter(BigDecimalValueAccessor.INSTANCE, true);
    private static final SimpleTypeConverter BIG_INTEGER_NO_EXPR = new SimpleTypeConverter(BigIntegerValueAccessor.INSTANCE, false);
    private static final SimpleTypeConverter BIG_INTEGER_EXPR = new SimpleTypeConverter(BigIntegerValueAccessor.INSTANCE, true);
    private static final SimpleTypeConverter BOOLEAN_NO_EXPR = new SimpleTypeConverter(BooleanValueAccessor.INSTANCE, false);
    private static final SimpleTypeConverter BOOLEAN_EXPR = new SimpleTypeConverter(BooleanValueAccessor.INSTANCE, true);
    private static final SimpleTypeConverter BYTES_NO_EXPR = new SimpleTypeConverter(BytesValueAccessor.INSTANCE, false);
    private static final SimpleTypeConverter DOUBLE_NO_EXPR = new SimpleTypeConverter(DoubleValueAccessor.INSTANCE, false);
    private static final SimpleTypeConverter DOUBLE_EXPR = new SimpleTypeConverter(DoubleValueAccessor.INSTANCE, true);
    private static final SimpleTypeConverter STRING_NO_EXPR = new SimpleTypeConverter(StringValueAccessor.INSTANCE, false);
    private static final SimpleTypeConverter STRING_EXPR = new SimpleTypeConverter(StringValueAccessor.INSTANCE, true);
    private static final SimpleTypeConverter PROPERTY_NO_EXPR = new SimpleTypeConverter(StringValueAccessor.INSTANCE, false);
    private static final SimpleTypeConverter INT_NO_EXPR = new SimpleTypeConverter(IntegerValueAccessor.INSTANCE, false);
    private static final SimpleTypeConverter INT_EXPR = new SimpleTypeConverter(IntegerValueAccessor.INSTANCE, true);
    private static final SimpleTypeConverter LONG_NO_EXPR = new SimpleTypeConverter(LongValueAccessor.INSTANCE, false);
    private static final SimpleTypeConverter LONG_EXPR = new SimpleTypeConverter(LongValueAccessor.INSTANCE, true);
    private static final SimpleTypeConverter TYPE_NO_EXPR = new SimpleTypeConverter(ModelTypeValueAccessor.INSTANCE, false);
    private static final SimpleTypeConverter TYPE_EXPR = new SimpleTypeConverter(ModelTypeValueAccessor.INSTANCE, true);
    private static final SimpleTypeConverter UNDEFINED_NO_EXPR = new SimpleTypeConverter(UndefinedValueAccessor.INSTANCE, false);
    private static final SimpleTypeConverter UNDEFINED_EXPR = new SimpleTypeConverter(UndefinedValueAccessor.INSTANCE, true);
    private final boolean expressions;
    private final boolean legacyWithProperPropertyFormat;

    private TypeConverters(boolean expressions, boolean legacyWithProperPropertyFormat) {
        this.expressions = expressions;
        this.legacyWithProperPropertyFormat = legacyWithProperPropertyFormat;
    }

    public static TypeConverters createLegacyTypeConverters(boolean properPropertyFormat) {
        return new TypeConverters(false, properPropertyFormat);
    }

    public static TypeConverters createExpressionTypeConverters() {
        return new TypeConverters(true, true);
    }

    OpenType<?> convertToMBeanType(ModelNode description) {
        return this.getConverter(description).getOpenType();
    }

    ModelNode toModelNode(ModelNode description, Object value) {
        ModelNode node = new ModelNode();
        if (value == null) {
            return node;
        }
        return this.getConverter(description).toModelNode(value);
    }

    Object fromModelNode(ModelNode description, ModelNode value) {
        if (value == null || !value.isDefined()) {
            return null;
        }
        return this.getConverter(description).fromModelNode(value);
    }

    public ModelType getType(ModelNode typeNode) {
        if (typeNode == null) {
            return ModelType.UNDEFINED;
        }
        try {
            return ModelType.valueOf((String)typeNode.toString());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public TypeConverter getConverter(ModelNode description) {
        return this.getConverter(description.hasDefined("type") ? description.get("type") : null, description.hasDefined("value-type") ? description.get("value-type") : null);
    }

    TypeConverter getConverter(ModelType modelType, ModelNode valueTypeNode) {
        switch (modelType) {
            case BIG_DECIMAL: {
                return this.expressions ? BIG_DECIMAL_EXPR : BIG_DECIMAL_NO_EXPR;
            }
            case BIG_INTEGER: {
                return this.expressions ? BIG_INTEGER_EXPR : BIG_INTEGER_NO_EXPR;
            }
            case BOOLEAN: {
                return this.expressions ? BOOLEAN_EXPR : BOOLEAN_NO_EXPR;
            }
            case BYTES: {
                return BYTES_NO_EXPR;
            }
            case DOUBLE: {
                return this.expressions ? DOUBLE_EXPR : DOUBLE_NO_EXPR;
            }
            case STRING: {
                return this.expressions ? STRING_EXPR : STRING_NO_EXPR;
            }
            case PROPERTY: {
                return this.expressions || this.legacyWithProperPropertyFormat ? new PropertyTypeConverter(valueTypeNode) : PROPERTY_NO_EXPR;
            }
            case INT: {
                return this.expressions ? INT_EXPR : INT_NO_EXPR;
            }
            case LONG: {
                return this.expressions ? LONG_EXPR : LONG_NO_EXPR;
            }
            case TYPE: {
                return this.expressions ? TYPE_EXPR : TYPE_NO_EXPR;
            }
            case UNDEFINED: {
                return this.expressions ? UNDEFINED_EXPR : UNDEFINED_NO_EXPR;
            }
            case OBJECT: {
                return new ObjectTypeConverter(valueTypeNode);
            }
            case LIST: {
                return new ListTypeConverter(valueTypeNode);
            }
        }
        throw JmxLogger.ROOT_LOGGER.unknownType(modelType);
    }

    TypeConverter getConverter(ModelNode typeNode, ModelNode valueTypeNode) {
        ModelType modelType = this.getType(typeNode);
        if (modelType == null) {
            return new ComplexTypeConverter(typeNode);
        }
        return this.getConverter(modelType, valueTypeNode);
    }

    private static ModelNode nullNodeAsUndefined(ModelNode node) {
        if (node == null) {
            return new ModelNode();
        }
        return node;
    }

    private static class ModelTypeValueAccessor
    extends SimpleValueAccessor {
        static final ModelTypeValueAccessor INSTANCE = new ModelTypeValueAccessor();

        private ModelTypeValueAccessor() {
        }

        @Override
        OpenType<?> getOpenType() {
            return SimpleType.STRING;
        }

        @Override
        Object fromModelNode(ModelNode node) {
            return node.asString();
        }

        @Override
        ModelNode toModelNode(Object o) {
            return this.toModelNodeFromString((String)o);
        }

        @Override
        Object[] toArray(List<Object> list) {
            return list.toArray(new String[list.size()]);
        }

        @Override
        ModelNode toModelNodeFromString(String s) {
            return new ModelNode().set(ModelType.valueOf((String)s));
        }
    }

    private static class LongValueAccessor
    extends SimpleValueAccessor {
        static final LongValueAccessor INSTANCE = new LongValueAccessor();

        private LongValueAccessor() {
        }

        @Override
        OpenType<?> getOpenType() {
            return SimpleType.LONG;
        }

        @Override
        Object fromModelNode(ModelNode node) {
            return node.asLong();
        }

        @Override
        ModelNode toModelNode(Object o) {
            return new ModelNode().set(((Long)o).longValue());
        }

        @Override
        Object[] toArray(List<Object> list) {
            return list.toArray(new Long[list.size()]);
        }

        @Override
        ModelNode toModelNodeFromString(String s) {
            return new ModelNode(Long.valueOf(s).longValue());
        }
    }

    private static class UndefinedValueAccessor
    extends SimpleValueAccessor {
        static final UndefinedValueAccessor INSTANCE = new UndefinedValueAccessor();

        private UndefinedValueAccessor() {
        }

        @Override
        OpenType<?> getOpenType() {
            return SimpleType.STRING;
        }

        @Override
        Object fromModelNode(ModelNode node) {
            return node.toJSONString(false);
        }

        @Override
        ModelNode toModelNode(Object o) {
            return this.toModelNodeFromString((String)o);
        }

        @Override
        Object[] toArray(List<Object> list) {
            return list.toArray(new String[list.size()]);
        }

        @Override
        ModelNode toModelNodeFromString(String s) {
            return ModelNode.fromJSONString((String)s);
        }
    }

    private static class StringValueAccessor
    extends SimpleValueAccessor {
        static final StringValueAccessor INSTANCE = new StringValueAccessor();

        private StringValueAccessor() {
        }

        @Override
        OpenType<?> getOpenType() {
            return SimpleType.STRING;
        }

        @Override
        Object fromModelNode(ModelNode node) {
            return node.asString();
        }

        @Override
        ModelNode toModelNode(Object o) {
            if (o == null) {
                return new ModelNode();
            }
            return new ModelNode().set((String)o);
        }

        @Override
        Object[] toArray(List<Object> list) {
            return list.toArray(new String[list.size()]);
        }

        @Override
        ModelNode toModelNodeFromString(String s) {
            return new ModelNode(s);
        }
    }

    private static class IntegerValueAccessor
    extends SimpleValueAccessor {
        static final IntegerValueAccessor INSTANCE = new IntegerValueAccessor();

        private IntegerValueAccessor() {
        }

        @Override
        OpenType<?> getOpenType() {
            return SimpleType.INTEGER;
        }

        @Override
        Object fromModelNode(ModelNode node) {
            return node.asInt();
        }

        @Override
        ModelNode toModelNode(Object o) {
            return new ModelNode().set(((Integer)o).intValue());
        }

        @Override
        Object[] toArray(List<Object> list) {
            return list.toArray(new Integer[list.size()]);
        }

        @Override
        ModelNode toModelNodeFromString(String s) {
            return new ModelNode(Integer.valueOf(s).intValue());
        }
    }

    private static class DoubleValueAccessor
    extends SimpleValueAccessor {
        static final DoubleValueAccessor INSTANCE = new DoubleValueAccessor();

        private DoubleValueAccessor() {
        }

        @Override
        OpenType<?> getOpenType() {
            return SimpleType.DOUBLE;
        }

        @Override
        Object fromModelNode(ModelNode node) {
            return node.asDouble();
        }

        @Override
        ModelNode toModelNode(Object o) {
            return new ModelNode().set(((Double)o).doubleValue());
        }

        @Override
        Object[] toArray(List<Object> list) {
            return list.toArray(new Double[list.size()]);
        }

        @Override
        ModelNode toModelNodeFromString(String s) {
            return new ModelNode(Double.valueOf(s).doubleValue());
        }
    }

    private static class BytesValueAccessor
    extends SimpleValueAccessor {
        static final BytesValueAccessor INSTANCE = new BytesValueAccessor();
        static final ArrayType<byte[]> ARRAY_TYPE = ArrayType.getPrimitiveArrayType(byte[].class);

        private BytesValueAccessor() {
        }

        @Override
        OpenType<?> getOpenType() {
            return ARRAY_TYPE;
        }

        @Override
        Object fromModelNode(ModelNode node) {
            return node.asBytes();
        }

        @Override
        ModelNode toModelNode(Object o) {
            return new ModelNode().set((byte[])o);
        }

        @Override
        Object[] toArray(List<Object> list) {
            return list.toArray((T[])new byte[list.size()][]);
        }

        @Override
        ModelNode toModelNodeFromString(String s) {
            return new ModelNode(s);
        }
    }

    private static class BooleanValueAccessor
    extends SimpleValueAccessor {
        static final BooleanValueAccessor INSTANCE = new BooleanValueAccessor();

        private BooleanValueAccessor() {
        }

        @Override
        OpenType<?> getOpenType() {
            return SimpleType.BOOLEAN;
        }

        @Override
        Object fromModelNode(ModelNode node) {
            return node.asBoolean();
        }

        @Override
        ModelNode toModelNode(Object o) {
            return new ModelNode().set(((Boolean)o).booleanValue());
        }

        @Override
        Object[] toArray(List<Object> list) {
            return list.toArray(new Boolean[list.size()]);
        }

        @Override
        ModelNode toModelNodeFromString(String s) {
            return new ModelNode(Boolean.valueOf(s).booleanValue());
        }
    }

    private static class BigIntegerValueAccessor
    extends SimpleValueAccessor {
        static final BigIntegerValueAccessor INSTANCE = new BigIntegerValueAccessor();

        private BigIntegerValueAccessor() {
        }

        @Override
        OpenType<?> getOpenType() {
            return SimpleType.BIGINTEGER;
        }

        @Override
        Object fromModelNode(ModelNode node) {
            return node.asBigInteger();
        }

        @Override
        ModelNode toModelNode(Object o) {
            return new ModelNode().set((BigInteger)o);
        }

        @Override
        Object[] toArray(List<Object> list) {
            return list.toArray(new BigInteger[list.size()]);
        }

        @Override
        ModelNode toModelNodeFromString(String s) {
            return new ModelNode(new BigInteger(s));
        }
    }

    private static class BigDecimalValueAccessor
    extends SimpleValueAccessor {
        static final BigDecimalValueAccessor INSTANCE = new BigDecimalValueAccessor();

        private BigDecimalValueAccessor() {
        }

        @Override
        OpenType<?> getOpenType() {
            return SimpleType.BIGDECIMAL;
        }

        @Override
        Object fromModelNode(ModelNode node) {
            return node.asBigDecimal();
        }

        @Override
        ModelNode toModelNode(Object o) {
            return new ModelNode().set((BigDecimal)o);
        }

        @Override
        Object[] toArray(List<Object> list) {
            return list.toArray(new BigDecimal[list.size()]);
        }

        @Override
        ModelNode toModelNodeFromString(String s) {
            return new ModelNode(new BigDecimal(s));
        }
    }

    private static abstract class SimpleValueAccessor {
        private SimpleValueAccessor() {
        }

        abstract OpenType<?> getOpenType();

        abstract Object fromModelNode(ModelNode var1);

        abstract ModelNode toModelNode(Object var1);

        abstract ModelNode toModelNodeFromString(String var1);

        abstract Object[] toArray(List<Object> var1);
    }

    private class PropertyTypeConverter
    implements TypeConverter {
        final ModelNode typeNode;

        public PropertyTypeConverter(ModelNode typeNode) {
            this.typeNode = typeNode;
        }

        public CompositeType getOpenType() {
            try {
                return new CompositeType("property", JmxLogger.ROOT_LOGGER.propertyCompositeType(), new String[]{"name", "value"}, new String[]{JmxLogger.ROOT_LOGGER.propertyName(), JmxLogger.ROOT_LOGGER.propertyValue()}, new OpenType[]{SimpleType.STRING, this.getConverter().getOpenType()});
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object fromModelNode(ModelNode node) {
            Property prop = node.asProperty();
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("name", prop.getName());
            items.put("value", this.getConverter().fromModelNode(prop.getValue()));
            try {
                return new CompositeDataSupport(this.getOpenType(), items);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public ModelNode toModelNode(Object o) {
            CompositeData data = (CompositeData)o;
            String name = (String)data.get("name");
            ModelNode value = this.getConverter().toModelNode(data.get("value"));
            ModelNode node = new ModelNode();
            node.set(name, value);
            return node;
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray(new Object[list.size()]);
        }

        private TypeConverter getConverter() {
            if (this.typeNode == null) {
                return TypeConverters.this.expressions ? STRING_EXPR : STRING_NO_EXPR;
            }
            return TypeConverters.this.getConverter(this.typeNode, null);
        }
    }

    private class ComplexTypeConverter
    implements TypeConverter {
        final ModelNode typeNode;

        ComplexTypeConverter(ModelNode typeNode) {
            this.typeNode = TypeConverters.nullNodeAsUndefined(typeNode);
        }

        @Override
        public OpenType<?> getOpenType() {
            ArrayList<String> itemNames = new ArrayList<String>();
            ArrayList<String> itemDescriptions = new ArrayList<String>();
            ArrayList itemTypes = new ArrayList();
            if (!this.typeNode.isDefined() || this.typeNode.getType() == ModelType.STRING) {
                return SimpleType.STRING;
            }
            for (String name : this.typeNode.keys()) {
                ModelNode current = this.typeNode.get(name);
                itemNames.add(name);
                String description = null;
                if (!current.hasDefined("description")) {
                    description = "-";
                } else {
                    description = current.get("description").asString().trim();
                    if (description.length() == 0) {
                        description = "-";
                    }
                }
                itemDescriptions.add(this.getDescription(current));
                itemTypes.add(TypeConverters.this.getConverter(current).getOpenType());
            }
            try {
                return new CompositeType(JmxLogger.ROOT_LOGGER.complexCompositeEntryTypeName(), JmxLogger.ROOT_LOGGER.complexCompositeEntryTypeDescription(), itemNames.toArray(new String[itemNames.size()]), itemDescriptions.toArray(new String[itemDescriptions.size()]), itemTypes.toArray(new OpenType[itemTypes.size()]));
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        }

        String getDescription(ModelNode node) {
            if (!node.hasDefined("description")) {
                return "-";
            }
            String description = node.get("description").asString();
            if (description.trim().length() == 0) {
                return "-";
            }
            return description;
        }

        @Override
        public Object fromModelNode(ModelNode node) {
            if (node == null || !node.isDefined()) {
                return null;
            }
            OpenType<?> openType = this.getOpenType();
            if (openType instanceof CompositeType) {
                CompositeType compositeType = (CompositeType)openType;
                HashMap<String, Object> items = new HashMap<String, Object>();
                for (String attrName : compositeType.keySet()) {
                    TypeConverter converter = TypeConverters.this.getConverter(this.typeNode.get(new String[]{attrName, "type"}), this.typeNode.get(new String[]{attrName, "value-type"}));
                    items.put(attrName, converter.fromModelNode(node.get(attrName)));
                }
                try {
                    return new CompositeDataSupport(compositeType, items);
                }
                catch (OpenDataException e) {
                    throw new RuntimeException(e);
                }
            }
            return node.toJSONString(false);
        }

        @Override
        public ModelNode toModelNode(Object o) {
            if (o == null) {
                return new ModelNode();
            }
            if (o instanceof CompositeData) {
                ModelNode node = new ModelNode();
                CompositeData composite = (CompositeData)o;
                for (String key : composite.getCompositeType().keySet()) {
                    if (!this.typeNode.hasDefined(key)) {
                        throw JmxLogger.ROOT_LOGGER.unknownValue(key);
                    }
                    TypeConverter converter = TypeConverters.this.getConverter(this.typeNode.get(new String[]{key, "type"}), this.typeNode.get(new String[]{key, "value-type"}));
                    node.get(key).set(converter.toModelNode(composite.get(key)));
                }
                return node;
            }
            return ModelNode.fromJSONString((String)((String)o));
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return list.toArray(new CompositeData[list.size()]);
        }
    }

    private class ListTypeConverter
    implements TypeConverter {
        final ModelNode valueTypeNode;

        ListTypeConverter(ModelNode valueTypeNode) {
            this.valueTypeNode = TypeConverters.nullNodeAsUndefined(valueTypeNode);
        }

        @Override
        public OpenType<?> getOpenType() {
            try {
                return ArrayType.getArrayType(TypeConverters.this.getConverter(this.valueTypeNode, null).getOpenType());
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object fromModelNode(ModelNode node) {
            if (node == null || !node.isDefined()) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            TypeConverter converter = TypeConverters.this.getConverter(this.valueTypeNode, null);
            for (ModelNode element : node.asList()) {
                list.add(converter.fromModelNode(element));
            }
            return converter.toArray(list);
        }

        @Override
        public ModelNode toModelNode(Object o) {
            if (o == null) {
                return new ModelNode();
            }
            ModelNode node = new ModelNode();
            TypeConverter converter = TypeConverters.this.getConverter(this.valueTypeNode, null);
            for (Object value : (Object[])o) {
                node.add(converter.toModelNode(value));
            }
            return node;
        }

        @Override
        public Object[] toArray(List<Object> list) {
            return null;
        }
    }

    private class ObjectTypeConverter
    implements TypeConverter {
        final ModelNode valueTypeNode;
        final ModelType valueType;
        OpenType<?> openType;

        ObjectTypeConverter(ModelNode valueTypeNode) {
            this.valueTypeNode = TypeConverters.nullNodeAsUndefined(valueTypeNode);
            ModelType valueType = TypeConverters.this.getType(valueTypeNode);
            this.valueType = valueType == ModelType.UNDEFINED ? null : valueType;
        }

        @Override
        public OpenType<?> getOpenType() {
            if (this.openType != null) {
                return this.openType;
            }
            this.openType = TypeConverters.this.getConverter(this.valueTypeNode, null).getOpenType();
            if (this.valueType == null && (this.openType instanceof CompositeType || !this.valueTypeNode.isDefined())) {
                return this.openType;
            }
            try {
                CompositeType rowType = new CompositeType(JmxLogger.ROOT_LOGGER.compositeEntryTypeName(), JmxLogger.ROOT_LOGGER.compositeEntryTypeDescription(), new String[]{"key", "value"}, new String[]{JmxLogger.ROOT_LOGGER.compositeEntryKeyDescription(), JmxLogger.ROOT_LOGGER.compositeEntryValueDescription()}, new OpenType[]{SimpleType.STRING, this.openType});
                this.openType = new TabularType(JmxLogger.ROOT_LOGGER.compositeMapName(), JmxLogger.ROOT_LOGGER.compositeMapDescription(), rowType, new String[]{"key"});
                return this.openType;
            }
            catch (OpenDataException e1) {
                throw new RuntimeException(e1);
            }
        }

        @Override
        public Object fromModelNode(ModelNode node) {
            if (node == null || !node.isDefined()) {
                return null;
            }
            if (this.valueType != null) {
                return this.fromSimpleModelNode(node);
            }
            TypeConverter converter = TypeConverters.this.getConverter(this.valueTypeNode, null);
            return converter.fromModelNode(node);
        }

        Object fromSimpleModelNode(ModelNode node) {
            List properties;
            TabularType tabularType = (TabularType)this.getOpenType();
            TabularDataSupport tabularData = new TabularDataSupport(tabularType);
            HashMap<String, ModelNode> values = new HashMap<String, ModelNode>();
            List list = properties = node.isDefined() ? node.asPropertyList() : null;
            if (properties != null) {
                for (Property prop : properties) {
                    values.put(prop.getName(), prop.getValue());
                }
            }
            TypeConverter converter = TypeConverters.this.getConverter(this.valueTypeNode, null);
            for (Map.Entry prop : values.entrySet()) {
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                rowData.put("key", prop.getKey());
                rowData.put("value", converter.fromModelNode((ModelNode)prop.getValue()));
                try {
                    tabularData.put(new CompositeDataSupport(tabularType.getRowType(), rowData));
                }
                catch (OpenDataException e) {
                    throw new RuntimeException(e);
                }
            }
            return tabularData;
        }

        @Override
        public ModelNode toModelNode(Object o) {
            if (o == null) {
                return new ModelNode();
            }
            if (this.valueType == null) {
                return TypeConverters.this.getConverter(this.valueTypeNode, null).toModelNode(o);
            }
            ModelNode node = new ModelNode();
            TypeConverter converter = TypeConverters.this.getConverter(this.valueTypeNode, null);
            for (Map.Entry entry : ((Map)o).entrySet()) {
                Map.Entry<String, Object> entry2 = this.convertTabularTypeEntryToMapEntry(entry);
                node.get(entry2.getKey()).set(converter.toModelNode(entry2.getValue()));
            }
            return node;
        }

        @Override
        public Object[] toArray(List<Object> list) {
            if (this.getOpenType() == SimpleType.STRING) {
                return list.toArray(new String[list.size()]);
            }
            return list.toArray(new Object[list.size()]);
        }

        private Map.Entry<String, Object> convertTabularTypeEntryToMapEntry(final Map.Entry<?, Object> entry) {
            if (entry.getKey() instanceof List) {
                return new Map.Entry<String, Object>(){

                    @Override
                    public String getKey() {
                        List keyList = (List)entry.getKey();
                        if (keyList.size() != 1) {
                            throw JmxLogger.ROOT_LOGGER.invalidKey(keyList, entry);
                        }
                        return (String)keyList.get(0);
                    }

                    @Override
                    public Object getValue() {
                        return ((CompositeDataSupport)entry.getValue()).get("value");
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return (String)entry.getKey();
                }

                @Override
                public Object getValue() {
                    return entry.getValue();
                }

                @Override
                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class SimpleTypeConverter
    implements TypeConverter {
        private final SimpleValueAccessor valueAccessor;
        private final boolean expressions;

        public SimpleTypeConverter(SimpleValueAccessor valueAccessor, boolean expressions) {
            this.valueAccessor = valueAccessor;
            this.expressions = expressions;
        }

        @Override
        public OpenType<?> getOpenType() {
            if (!this.expressions) {
                return this.valueAccessor.getOpenType();
            }
            return SimpleType.STRING;
        }

        @Override
        public Object fromModelNode(ModelNode node) {
            if (node == null || !node.isDefined() || node.asString().isEmpty()) {
                return null;
            }
            if (!this.expressions || this.valueAccessor == UndefinedValueAccessor.INSTANCE) {
                if (!this.expressions && node.getType() == ModelType.EXPRESSION && !VAULT_PATTERN.matcher(node.asString()).matches()) {
                    ModelNode resolved;
                    try {
                        resolved = ExpressionResolver.SIMPLE.resolveExpressions(node);
                    }
                    catch (OperationFailedException e) {
                        throw new IllegalArgumentException(e);
                    }
                    return this.valueAccessor.fromModelNode(resolved);
                }
                return this.valueAccessor.fromModelNode(node);
            }
            return node.asString();
        }

        @Override
        public ModelNode toModelNode(Object o) {
            if (o == null) {
                return new ModelNode();
            }
            boolean possibleExpression = false;
            if (o instanceof String) {
                possibleExpression = this.isPossibleExpression((String)o);
            }
            if (this.expressions) {
                if (possibleExpression) {
                    return new ModelNode().set(new ValueExpression((String)o));
                }
                if (o instanceof String) {
                    return this.valueAccessor.toModelNodeFromString((String)o);
                }
                return this.valueAccessor.toModelNode(o);
            }
            if (possibleExpression) {
                if (this.valueAccessor != StringValueAccessor.INSTANCE) {
                    throw JmxLogger.ROOT_LOGGER.expressionCannotBeConvertedIntoTargeteType(this.valueAccessor.getOpenType());
                }
                return new ModelNode().set(new ValueExpression((String)o));
            }
            return this.valueAccessor.toModelNode(o);
        }

        private boolean isPossibleExpression(String s) {
            int start = s.indexOf("${");
            return start != -1 && s.indexOf(125, start) != -1;
        }

        @Override
        public Object[] toArray(List<Object> list) {
            if (this.expressions) {
                return list.toArray(new String[list.size()]);
            }
            return this.valueAccessor.toArray(list);
        }
    }

    static interface TypeConverter {
        public OpenType<?> getOpenType();

        public Object fromModelNode(ModelNode var1);

        public ModelNode toModelNode(Object var1);

        public Object[] toArray(List<Object> var1);
    }
}

