/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2014, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.test.integration.security.vault;

import org.jboss.as.arquillian.api.ServerSetupTask;

import org.apache.log4j.Logger;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.test.module.util.TestModule;

/**
 * @author <a href="mailto:pskopek@redhat.com">Peter Skopek</a>.
 */
public class ExternalPasswordModuleSetupTask implements ServerSetupTask {
    private static Logger LOGGER = Logger.getLogger(ExternalPasswordModuleSetupTask.class);

    public static final String MODULE_NAME_BASE = "org.jboss.test.vault";
    public static final String MODULE_NAME = "vaultext";
    private static final String MODULE_JAR = "external.jar";

    private TestModule testModule;

    /**
     * Creates work-directory where JAR containing {@link org.jboss.as.test.integration.security.vault.ExternalPassword} is stored. The JAR is then deployed as an AS module.
     */
    @Override
    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        LOGGER.trace("Creating: " + getModuleName());
        testModule = new TestModule(getModuleName());
        testModule.addResource(MODULE_JAR).addClass(ExternalPassword.class);
        testModule.create();
    }

    /**
     * Removes work-directory and removes the AS module.
     */
    @Override
    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        LOGGER.trace("Removing module: " + getModuleName());
        if (testModule != null) {
            testModule.remove();
        }
    }

    public static String getModuleName() {
        return MODULE_NAME_BASE + "." + MODULE_NAME;
    }

}
