/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.servlet.api.AuthorizationManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.LifecycleInterceptor;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.SingleConstraintMatch;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.core.DefaultAuthorizationManager;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.util.SavedRequest;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.servlet.Filter;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.SimpleCapabilityServiceConfigurator;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.elytron.web.undertow.server.ElytronContextAssociationHandler;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.elytron.web.undertow.server.ElytronRunAsHandler;
import org.wildfly.elytron.web.undertow.server.ScopeSessionListener;
import org.wildfly.extension.undertow.ApplicationSecurityDomainSingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnManagerServiceNameProvider;
import org.wildfly.extension.undertow.SingleSignOnSessionFactoryServiceConfigurator;
import org.wildfly.extension.undertow.SingleSignOnSessionFactoryServiceNameProvider;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.jacc.JACCAuthorizationManager;
import org.wildfly.extension.undertow.security.sso.DistributableSecurityDomainSingleSignOnManagerServiceConfiguratorProvider;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.MechanismRealmConfiguration;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.AuthorizationFailureException;
import org.wildfly.security.authz.RoleMapper;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpScopeNotification;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.impl.ServerMechanismFactoryImpl;
import org.wildfly.security.http.util.FilterServerMechanismFactory;
import org.wildfly.security.http.util.PropertiesServerMechanismFactory;
import org.wildfly.security.http.util.sso.DefaultSingleSignOnManager;
import org.wildfly.security.http.util.sso.SingleSignOnServerMechanismFactory;
import org.wildfly.security.http.util.sso.SingleSignOnSessionFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ApplicationSecurityDomainDefinition
extends PersistentResourceDefinition {
    private static final String ANONYMOUS_PRINCIPAL = "anonymous";
    private static final String SERVLET = "servlet";
    private static final String EJB = "ejb";
    private static Predicate<String> SERVLET_MECHANISM;
    static final RuntimeCapability<Void> APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY;
    static final RuntimeCapability<Void> APPLICATION_SECURITY_DOMAIN_KNOWN_DEPLOYMENTS_CAPABILITY;
    static final SimpleAttributeDefinition HTTP_AUTHENTICATION_FACTORY;
    static final SimpleAttributeDefinition OVERRIDE_DEPLOYMENT_CONFIG;
    static final SimpleAttributeDefinition SECURITY_DOMAIN;
    private static final StringListAttributeDefinition REFERENCING_DEPLOYMENTS;
    static final SimpleAttributeDefinition ENABLE_JACC;
    private static final AttributeDefinition[] ATTRIBUTES;
    static final ApplicationSecurityDomainDefinition INSTANCE;
    private static final Set<String> knownApplicationSecurityDomains;
    private static final OperationContext.AttachmentKey<KnownDeploymentsApi> KNOWN_DEPLOYMENTS_KEY;

    private ApplicationSecurityDomainDefinition() {
        this((PersistentResourceDefinition.Parameters)new PersistentResourceDefinition.Parameters(UndertowExtension.PATH_APPLICATION_SECURITY_DOMAIN, (ResourceDescriptionResolver)UndertowExtension.getResolver("application-security-domain")).setCapabilities(new RuntimeCapability[]{APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY}).addAccessConstraints(new AccessConstraintDefinition[]{new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("undertow", "application-security-domain", false, false, false)), new ApplicationTypeAccessConstraintDefinition(new ApplicationTypeConfig("undertow", "application-security-domain"))}), new AddHandler());
    }

    private ApplicationSecurityDomainDefinition(PersistentResourceDefinition.Parameters parameters, AbstractAddStepHandler add) {
        super(parameters.setAddHandler((OperationStepHandler)add).setRemoveHandler((OperationStepHandler)new RemoveHandler(add)));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        knownApplicationSecurityDomains.clear();
        super.registerAttributes(resourceRegistration);
        if (resourceRegistration.getProcessType().isServer()) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)REFERENCING_DEPLOYMENTS, (OperationStepHandler)new ReferencingDeploymentsHandler());
        }
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Collections.singletonList(new ApplicationSecurityDomainSingleSignOnDefinition());
    }

    private static Function<String, HttpAuthenticationFactory> toHttpAuthenticationFactoryFunction(Supplier<SecurityDomain> securityDomainSupplier) {
        FilterServerMechanismFactory mechanismFactory = new FilterServerMechanismFactory((HttpServerAuthenticationMechanismFactory)new ServerMechanismFactoryImpl(), SERVLET_MECHANISM);
        return arg_0 -> ApplicationSecurityDomainDefinition.lambda$toHttpAuthenticationFactoryFunction$0((HttpServerAuthenticationMechanismFactory)mechanismFactory, securityDomainSupplier, arg_0);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    Predicate<String> getKnownSecurityDomainPredicate() {
        return knownApplicationSecurityDomains::contains;
    }

    private static /* synthetic */ HttpAuthenticationFactory lambda$toHttpAuthenticationFactoryFunction$0(HttpServerAuthenticationMechanismFactory mechanismFactory, Supplier securityDomainSupplier, String realmName) {
        return HttpAuthenticationFactory.builder().setFactory(mechanismFactory).setSecurityDomain((SecurityDomain)securityDomainSupplier.get()).setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)(realmName == null ? MechanismConfiguration.EMPTY : MechanismConfiguration.builder().addMechanismRealm(MechanismRealmConfiguration.builder().setRealmName(realmName).build()).build()))).build();
    }

    static {
        HashSet<String> defaultMechanisms = new HashSet<String>(4);
        defaultMechanisms.add("BASIC");
        defaultMechanisms.add("CLIENT_CERT");
        defaultMechanisms.add("DIGEST");
        defaultMechanisms.add("FORM");
        SERVLET_MECHANISM = defaultMechanisms::contains;
        APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.application-security-domain", (boolean)true, BiFunction.class).build();
        APPLICATION_SECURITY_DOMAIN_KNOWN_DEPLOYMENTS_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.application-security-domain.known-deployments", (boolean)true).build();
        HTTP_AUTHENTICATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-authentication-factory", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.http-authentication-factory")).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.AUTHENTICATION_FACTORY_REF})).setAlternatives(new String[]{"security-domain"})).build();
        OVERRIDE_DEPLOYMENT_CONFIG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("override-deployment-config", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setRestartAllServices()).setRequires(new String[]{"http-authentication-factory"})).build();
        SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.security-domain")).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.ELYTRON_SECURITY_DOMAIN_REF})).setAlternatives(new String[]{"http-authentication-factory"})).build();
        REFERENCING_DEPLOYMENTS = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("referencing-deployments").setStorageRuntime()).build();
        ENABLE_JACC = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-jacc", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setMinSize(1)).setRestartAllServices()).build();
        ATTRIBUTES = new AttributeDefinition[]{SECURITY_DOMAIN, HTTP_AUTHENTICATION_FACTORY, OVERRIDE_DEPLOYMENT_CONFIG, ENABLE_JACC};
        INSTANCE = new ApplicationSecurityDomainDefinition();
        knownApplicationSecurityDomains = Collections.synchronizedSet(new HashSet());
        KNOWN_DEPLOYMENTS_KEY = OperationContext.AttachmentKey.create(KnownDeploymentsApi.class);
    }

    private static class KnownDeploymentsApi {
        private volatile ApplicationSecurityDomainService service;

        private KnownDeploymentsApi() {
        }

        List<String> getKnownDeployments() {
            return this.service != null ? this.service.getDeployments() : Collections.emptyList();
        }

        void setApplicationSecurityDomainService(ApplicationSecurityDomainService service) {
            this.service = service;
        }
    }

    private static class FormResponseWrapper
    extends HttpServletResponseWrapper {
        private int status = 200;

        private FormResponseWrapper(HttpServletResponse wrapped) {
            super(wrapped);
        }

        public void setStatus(int sc, String sm) {
            this.status = sc;
        }

        public void setStatus(int sc) {
            this.status = sc;
        }

        public int getStatus() {
            return this.status;
        }
    }

    public static interface Registration {
        public void cancel();
    }

    private static class ApplicationSecurityDomainService
    implements Service,
    BiFunction<DeploymentInfo, Function<String, RunAsIdentityMetaData>, Registration> {
        private final Function<String, HttpAuthenticationFactory> factoryFunction;
        private final Supplier<UnaryOperator<HttpServerAuthenticationMechanismFactory>> singleSignOnTransformerSupplier;
        private final Consumer<BiFunction<DeploymentInfo, Function<String, RunAsIdentityMetaData>, Registration>> valueConsumer;
        private final boolean overrideDeploymentConfig;
        private final Set<RegistrationImpl> registrations = new HashSet<RegistrationImpl>();
        private final boolean enableJacc;

        private ApplicationSecurityDomainService(boolean overrideDeploymentConfig, boolean enableJacc, Function<String, HttpAuthenticationFactory> factoryFunction, Supplier<UnaryOperator<HttpServerAuthenticationMechanismFactory>> singleSignOnTransformerSupplier, Consumer<BiFunction<DeploymentInfo, Function<String, RunAsIdentityMetaData>, Registration>> valueConsumer) {
            this.overrideDeploymentConfig = overrideDeploymentConfig;
            this.enableJacc = enableJacc;
            this.factoryFunction = factoryFunction;
            this.singleSignOnTransformerSupplier = singleSignOnTransformerSupplier;
            this.valueConsumer = valueConsumer;
        }

        public void start(StartContext context) throws StartException {
            this.valueConsumer.accept(this);
        }

        public void stop(StopContext context) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Registration apply(DeploymentInfo deploymentInfo, Function<String, RunAsIdentityMetaData> runAsMapper) {
            HttpAuthenticationFactory httpAuthenticationFactory = this.factoryFunction.apply(this.getRealmName(deploymentInfo));
            SecurityDomain securityDomain = httpAuthenticationFactory.getSecurityDomain();
            ScopeSessionListener scopeSessionListener = ScopeSessionListener.builder().addScopeResolver(Scope.APPLICATION, ApplicationSecurityDomainService::applicationScope).build();
            if (WildFlySecurityManager.isChecking()) {
                AccessController.doPrivileged(() -> {
                    securityDomain.registerWithClassLoader(deploymentInfo.getClassLoader());
                    return null;
                });
            } else {
                securityDomain.registerWithClassLoader(deploymentInfo.getClassLoader());
            }
            deploymentInfo.addSessionListener((SessionListener)scopeSessionListener);
            deploymentInfo.addInnerHandlerChainWrapper(h -> this.finalSecurityHandlers(securityDomain, h, runAsMapper));
            deploymentInfo.setInitialSecurityWrapper(h -> this.initialSecurityHandler(deploymentInfo, h, scopeSessionListener, httpAuthenticationFactory));
            deploymentInfo.addLifecycleInterceptor((LifecycleInterceptor)new RunAsLifecycleInterceptor(securityDomain, runAsMapper));
            if (this.enableJacc) {
                deploymentInfo.setAuthorizationManager((AuthorizationManager)new JACCAuthorizationManager());
            } else {
                deploymentInfo.setAuthorizationManager(this.createElytronAuthorizationManager(securityDomain));
            }
            RegistrationImpl registration = new RegistrationImpl(deploymentInfo);
            Set<RegistrationImpl> set = this.registrations;
            synchronized (set) {
                this.registrations.add(registration);
            }
            return registration;
        }

        private List<HttpServerAuthenticationMechanism> getAuthenticationMechanisms(HttpAuthenticationFactory httpAuthenticationFactory, Map<String, Map<String, String>> selectedMechanisms) {
            ArrayList<HttpServerAuthenticationMechanism> mechanisms = new ArrayList<HttpServerAuthenticationMechanism>(selectedMechanisms.size());
            UnaryOperator<HttpServerAuthenticationMechanismFactory> singleSignOnTransformer = this.singleSignOnTransformerSupplier.get();
            for (Map.Entry<String, Map<String, String>> entry : selectedMechanisms.entrySet()) {
                try {
                    UnaryOperator factoryTransformation = f -> {
                        PropertiesServerMechanismFactory factory = new PropertiesServerMechanismFactory(f, (Map)entry.getValue());
                        return singleSignOnTransformer != null ? (HttpServerAuthenticationMechanismFactory)singleSignOnTransformer.apply((HttpServerAuthenticationMechanismFactory)factory) : factory;
                    };
                    HttpServerAuthenticationMechanism mechanism = (HttpServerAuthenticationMechanism)httpAuthenticationFactory.createMechanism(entry.getKey(), factoryTransformation);
                    if (mechanism == null) continue;
                    mechanisms.add(mechanism);
                }
                catch (HttpAuthenticationException e) {
                    throw new IllegalStateException(e);
                }
            }
            return mechanisms;
        }

        private String getRealmName(DeploymentInfo deploymentInfo) {
            LoginConfig loginConfig = deploymentInfo.getLoginConfig();
            return loginConfig != null ? loginConfig.getRealmName() : null;
        }

        private HttpHandler initialSecurityHandler(DeploymentInfo deploymentInfo, HttpHandler toWrap, ScopeSessionListener scopeSessionListener, HttpAuthenticationFactory httpAuthenticationFactory) {
            Collection availableMechanisms = httpAuthenticationFactory.getMechanismNames();
            if (availableMechanisms.isEmpty()) {
                throw UndertowLogger.ROOT_LOGGER.noMechanismsAvailable();
            }
            HashMap<String, String> tempBaseConfiguration = new HashMap<String, String>();
            tempBaseConfiguration.put(HttpConstants.CONFIG_CONTEXT_PATH, deploymentInfo.getContextPath());
            LoginConfig loginConfig = deploymentInfo.getLoginConfig();
            if (loginConfig != null) {
                String errorPage;
                String loginPage;
                String realm = loginConfig.getRealmName();
                if (realm != null) {
                    tempBaseConfiguration.put(HttpConstants.CONFIG_REALM, realm);
                }
                if ((loginPage = loginConfig.getLoginPage()) != null) {
                    tempBaseConfiguration.put(HttpConstants.CONFIG_LOGIN_PAGE, loginPage);
                }
                if ((errorPage = loginConfig.getErrorPage()) != null) {
                    tempBaseConfiguration.put(HttpConstants.CONFIG_ERROR_PAGE, errorPage);
                }
            }
            Map baseConfiguration = Collections.unmodifiableMap(tempBaseConfiguration);
            LinkedHashMap selectedMechanisms = new LinkedHashMap();
            if (this.overrideDeploymentConfig || loginConfig == null) {
                Map mechanismConfiguration = baseConfiguration;
                for (String n : availableMechanisms) {
                    selectedMechanisms.put(n, mechanismConfiguration);
                }
            } else {
                List authMethods = loginConfig.getAuthMethods();
                if (authMethods.isEmpty()) {
                    throw UndertowLogger.ROOT_LOGGER.noMechanismsSelected();
                }
                for (AuthMethodConfig c : authMethods) {
                    Map mechanismConfiguration;
                    String name = c.getName();
                    if (!availableMechanisms.contains(name)) {
                        throw UndertowLogger.ROOT_LOGGER.requiredMechanismNotAvailable(name, availableMechanisms);
                    }
                    Map additionalProperties = c.getProperties();
                    if (additionalProperties != null) {
                        mechanismConfiguration = new HashMap(baseConfiguration);
                        mechanismConfiguration.putAll(additionalProperties);
                        mechanismConfiguration = Collections.unmodifiableMap(mechanismConfiguration);
                    } else {
                        mechanismConfiguration = baseConfiguration;
                    }
                    selectedMechanisms.put(name, mechanismConfiguration);
                }
            }
            HashMap<Scope, Function<HttpServerExchange, HttpScope>> scopeResolvers = new HashMap<Scope, Function<HttpServerExchange, HttpScope>>();
            scopeResolvers.put(Scope.APPLICATION, ApplicationSecurityDomainService::applicationScope);
            scopeResolvers.put(Scope.EXCHANGE, ApplicationSecurityDomainService::requestScope);
            scopeResolvers.put(Scope.SESSION, exchange -> ApplicationSecurityDomainService.sessionScope(exchange, scopeSessionListener));
            return ElytronContextAssociationHandler.builder().setNext(toWrap).setSecurityDomain(httpAuthenticationFactory.getSecurityDomain()).setMechanismSupplier(() -> this.getAuthenticationMechanisms(httpAuthenticationFactory, selectedMechanisms)).setHttpExchangeSupplier(httpServerExchange -> new ElytronHttpExchange((HttpServerExchange)httpServerExchange, scopeResolvers, scopeSessionListener, (HttpServerExchange)httpServerExchange){
                final /* synthetic */ HttpServerExchange val$httpServerExchange;
                {
                    this.val$httpServerExchange = httpServerExchange;
                    super(x0, x1, x2);
                }

                protected SessionManager getSessionManager() {
                    ServletRequestContext servletRequestContext = (ServletRequestContext)this.val$httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                    return servletRequestContext.getDeployment().getSessionManager();
                }

                protected SessionConfig getSessionConfig() {
                    ServletRequestContext servletRequestContext = (ServletRequestContext)this.val$httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                    return servletRequestContext.getCurrentServletContext().getSessionConfig();
                }

                public int forward(String path) {
                    ServletRequestContext servletRequestContext = (ServletRequestContext)this.val$httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                    ServletRequest req = servletRequestContext.getServletRequest();
                    ServletResponse resp = servletRequestContext.getServletResponse();
                    RequestDispatcher disp = req.getRequestDispatcher(path);
                    FormResponseWrapper respWrapper = this.val$httpServerExchange.getStatusCode() != 200 && resp instanceof HttpServletResponse ? new FormResponseWrapper((HttpServletResponse)resp) : null;
                    try {
                        disp.forward(req, (ServletResponse)(respWrapper != null ? respWrapper : resp));
                    }
                    catch (ServletException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return respWrapper != null ? respWrapper.getStatus() : this.val$httpServerExchange.getStatusCode();
                }

                public boolean suspendRequest() {
                    SavedRequest.trySaveRequest((HttpServerExchange)this.val$httpServerExchange);
                    return true;
                }

                public boolean resumeRequest() {
                    ServletRequestContext servletRequestContext = (ServletRequestContext)this.val$httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
                    HttpSessionImpl session = servletRequestContext.getCurrentServletContext().getSession(this.val$httpServerExchange, false);
                    if (session != null) {
                        SavedRequest.tryRestoreRequest((HttpServerExchange)this.val$httpServerExchange, (HttpSession)session);
                    }
                    return true;
                }
            }).build();
        }

        private static HttpScope applicationScope(HttpServerExchange exchange) {
            ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            if (servletRequestContext != null) {
                final Deployment deployment = servletRequestContext.getDeployment();
                ServletContextImpl servletContext = deployment.getServletContext();
                return new HttpScope((ServletContext)servletContext){
                    final /* synthetic */ ServletContext val$servletContext;
                    {
                        this.val$servletContext = servletContext;
                    }

                    public String getID() {
                        return deployment.getDeploymentInfo().getDeploymentName();
                    }

                    public boolean supportsAttachments() {
                        return true;
                    }

                    public void setAttachment(String key, Object value) {
                        this.val$servletContext.setAttribute(key, value);
                    }

                    public Object getAttachment(String key) {
                        return this.val$servletContext.getAttribute(key);
                    }

                    public boolean supportsResources() {
                        return true;
                    }

                    public InputStream getResource(String path) {
                        return this.val$servletContext.getResourceAsStream(path);
                    }
                };
            }
            return null;
        }

        private static HttpScope requestScope(HttpServerExchange exchange) {
            ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            if (servletRequestContext != null) {
                final ServletRequest servletRequest = servletRequestContext.getServletRequest();
                return new HttpScope(){

                    public boolean supportsAttachments() {
                        return true;
                    }

                    public void setAttachment(String key, Object value) {
                        servletRequest.setAttribute(key, value);
                    }

                    public Object getAttachment(String key) {
                        return servletRequest.getAttribute(key);
                    }
                };
            }
            return null;
        }

        private static HttpScope sessionScope(HttpServerExchange exchange, final ScopeSessionListener listener) {
            final ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            return new HttpScope(){
                private HttpSession session;
                {
                    this.session = context.getOriginalRequest().getSession(false);
                }

                public String getID() {
                    return this.exists() ? this.session.getId() : null;
                }

                public boolean exists() {
                    return this.session != null;
                }

                public synchronized boolean create() {
                    if (this.exists()) {
                        return false;
                    }
                    this.session = context.getOriginalRequest().getSession(true);
                    return this.session != null;
                }

                public boolean supportsAttachments() {
                    return true;
                }

                public void setAttachment(String key, Object value) {
                    if (this.exists()) {
                        this.session.setAttribute(key, value);
                    }
                }

                public Object getAttachment(String key) {
                    return this.exists() ? this.session.getAttribute(key) : null;
                }

                public boolean supportsInvalidation() {
                    return true;
                }

                public boolean invalidate() {
                    if (this.exists()) {
                        try {
                            this.session.invalidate();
                            return true;
                        }
                        catch (IllegalStateException cause) {
                            UndertowLogger.ROOT_LOGGER.debugf("Failed to invalidate session", cause);
                        }
                    }
                    return false;
                }

                public boolean supportsNotifications() {
                    return true;
                }

                public void registerForNotification(Consumer<HttpScopeNotification> consumer) {
                    if (this.exists()) {
                        listener.registerListener(this.session.getId(), consumer);
                    }
                }
            };
        }

        private HttpHandler finalSecurityHandlers(SecurityDomain securityDomain, HttpHandler toWrap, Function<String, RunAsIdentityMetaData> runAsMapper) {
            return new ElytronRunAsHandler(toWrap, (s, e) -> this.mapIdentity(securityDomain, (SecurityIdentity)s, (HttpServerExchange)e, runAsMapper));
        }

        private SecurityIdentity mapIdentity(SecurityDomain securityDomain, SecurityIdentity securityIdentity, HttpServerExchange exchange, Function<String, RunAsIdentityMetaData> runAsMapper) {
            ServletChain servlet = ((ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getCurrentServlet();
            RunAsIdentityMetaData runAsMetaData = runAsMapper.apply(servlet.getManagedServlet().getServletInfo().getName());
            return this.performMapping(securityDomain, securityIdentity, runAsMetaData);
        }

        private SecurityIdentity performMapping(SecurityDomain securityDomain, SecurityIdentity securityIdentity, RunAsIdentityMetaData runAsMetaData) {
            if (runAsMetaData != null) {
                SecurityIdentity newIdentity = securityIdentity != null ? securityIdentity : securityDomain.getAnonymousSecurityIdentity();
                String runAsPrincipal = runAsMetaData.getPrincipalName();
                if (runAsPrincipal.equals(ApplicationSecurityDomainDefinition.ANONYMOUS_PRINCIPAL)) {
                    try {
                        newIdentity = newIdentity.createRunAsAnonymous();
                    }
                    catch (AuthorizationFailureException ex) {
                        newIdentity = newIdentity.createRunAsAnonymous(false);
                    }
                } else if (!this.runAsPrincipalExists(securityDomain, runAsPrincipal)) {
                    newIdentity = securityDomain.createAdHocIdentity(runAsPrincipal);
                } else {
                    try {
                        newIdentity = newIdentity.createRunAsIdentity(runAsPrincipal);
                    }
                    catch (AuthorizationFailureException ex) {
                        newIdentity = newIdentity.createRunAsIdentity(runAsPrincipal, false);
                    }
                }
                HashSet<String> runAsRoleNames = new HashSet<String>(runAsMetaData.getRunAsRoles().size());
                runAsRoleNames.add(runAsMetaData.getRoleName());
                runAsRoleNames.addAll(runAsMetaData.getRunAsRoles());
                RoleMapper runAsRoleMaper = RoleMapper.constant((Roles)Roles.fromSet(runAsRoleNames));
                Roles servletRoles = newIdentity.getRoles(ApplicationSecurityDomainDefinition.SERVLET);
                newIdentity = newIdentity.withRoleMapper(ApplicationSecurityDomainDefinition.SERVLET, runAsRoleMaper.or(roles -> servletRoles));
                Roles ejbRoles = newIdentity.getRoles(ApplicationSecurityDomainDefinition.EJB);
                newIdentity = newIdentity.withRoleMapper(ApplicationSecurityDomainDefinition.EJB, runAsRoleMaper.or(roles -> ejbRoles));
                return newIdentity;
            }
            return securityIdentity;
        }

        private boolean runAsPrincipalExists(SecurityDomain securityDomain, String runAsPrincipal) {
            RealmIdentity realmIdentity = null;
            try {
                realmIdentity = securityDomain.getIdentity(runAsPrincipal);
                boolean bl = realmIdentity.exists();
                return bl;
            }
            catch (RealmUnavailableException e) {
                throw UndertowLogger.ROOT_LOGGER.unableToObtainIdentity(runAsPrincipal, e);
            }
            finally {
                if (realmIdentity != null) {
                    realmIdentity.dispose();
                }
            }
        }

        private AuthorizationManager createElytronAuthorizationManager(final SecurityDomain securityDomain) {
            return new AuthorizationManager(){

                public boolean isUserInRole(String roleName, Account account, ServletInfo servletInfo, HttpServletRequest request, Deployment deployment) {
                    return DefaultAuthorizationManager.INSTANCE.isUserInRole(roleName, account, servletInfo, request, deployment);
                }

                public boolean canAccessResource(List<SingleConstraintMatch> mappedConstraints, Account account, ServletInfo servletInfo, HttpServletRequest request, Deployment deployment) {
                    if (DefaultAuthorizationManager.INSTANCE.canAccessResource(mappedConstraints, account, servletInfo, request, deployment)) {
                        return true;
                    }
                    SecurityIdentity securityIdentity = securityDomain.getCurrentSecurityIdentity();
                    if (securityIdentity == null) {
                        return false;
                    }
                    ArrayList<Object> permissions = new ArrayList<Object>();
                    permissions.add(new WebResourcePermission(this.getCanonicalURI(request), request.getMethod()));
                    for (String string : securityIdentity.getRoles("web", true)) {
                        permissions.add(new WebRoleRefPermission(this.getCanonicalURI(request), string));
                    }
                    for (Permission permission : permissions) {
                        if (!securityIdentity.implies(permission)) continue;
                        return true;
                    }
                    return false;
                }

                public TransportGuaranteeType transportGuarantee(TransportGuaranteeType currentConnectionGuarantee, TransportGuaranteeType configuredRequiredGuarantee, HttpServletRequest request) {
                    return DefaultAuthorizationManager.INSTANCE.transportGuarantee(currentConnectionGuarantee, configuredRequiredGuarantee, request);
                }

                private String getCanonicalURI(HttpServletRequest request) {
                    String canonicalURI = request.getRequestURI().substring(request.getContextPath().length());
                    if (canonicalURI == null || canonicalURI.equals("/")) {
                        canonicalURI = "";
                    }
                    return canonicalURI;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> getDeployments() {
            Set<RegistrationImpl> set = this.registrations;
            synchronized (set) {
                ArrayList<String> deployments = new ArrayList<String>(this.registrations.size());
                for (RegistrationImpl registration : this.registrations) {
                    deployments.add(registration.deploymentInfo.getDeploymentName());
                }
                return deployments;
            }
        }

        private class RegistrationImpl
        implements Registration {
            final DeploymentInfo deploymentInfo;

            private RegistrationImpl(DeploymentInfo deploymentInfo) {
                this.deploymentInfo = deploymentInfo;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                if (WildFlySecurityManager.isChecking()) {
                    AccessController.doPrivileged(() -> {
                        SecurityDomain.unregisterClassLoader((ClassLoader)this.deploymentInfo.getClassLoader());
                        return null;
                    });
                } else {
                    SecurityDomain.unregisterClassLoader((ClassLoader)this.deploymentInfo.getClassLoader());
                }
                Set set = ApplicationSecurityDomainService.this.registrations;
                synchronized (set) {
                    ApplicationSecurityDomainService.this.registrations.remove(this);
                }
            }
        }

        private class RunAsLifecycleInterceptor
        implements LifecycleInterceptor {
            private final SecurityDomain securityDomain;
            private final Function<String, RunAsIdentityMetaData> runAsMapper;

            RunAsLifecycleInterceptor(SecurityDomain securityDomain, Function<String, RunAsIdentityMetaData> runAsMapper) {
                this.securityDomain = securityDomain;
                this.runAsMapper = runAsMapper;
            }

            private void doIt(ServletInfo servletInfo, LifecycleInterceptor.LifecycleContext context) throws ServletException {
                RunAsIdentityMetaData runAsMetaData = this.runAsMapper.apply(servletInfo.getName());
                if (runAsMetaData != null) {
                    SecurityIdentity securityIdentity = ApplicationSecurityDomainService.this.performMapping(this.securityDomain, this.securityDomain.getAnonymousSecurityIdentity(), runAsMetaData);
                    try {
                        securityIdentity.runAs(() -> {
                            context.proceed();
                            return null;
                        });
                    }
                    catch (PrivilegedActionException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof ServletException) {
                            throw (ServletException)cause;
                        }
                        throw new ServletException(cause);
                    }
                } else {
                    context.proceed();
                }
            }

            public void init(ServletInfo servletInfo, Servlet servlet, LifecycleInterceptor.LifecycleContext context) throws ServletException {
                this.doIt(servletInfo, context);
            }

            public void init(FilterInfo filterInfo, Filter filter, LifecycleInterceptor.LifecycleContext context) throws ServletException {
                context.proceed();
            }

            public void destroy(ServletInfo servletInfo, Servlet servlet, LifecycleInterceptor.LifecycleContext context) throws ServletException {
                this.doIt(servletInfo, context);
            }

            public void destroy(FilterInfo filterInfo, Filter filter, LifecycleInterceptor.LifecycleContext context) throws ServletException {
                context.proceed();
            }
        }
    }

    private static class RemoveHandler
    extends ServiceRemoveStepHandler {
        protected RemoveHandler(AbstractAddStepHandler addOperation) {
            super(addOperation, new RuntimeCapability[]{APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY, APPLICATION_SECURITY_DOMAIN_KNOWN_DEPLOYMENTS_CAPABILITY});
        }

        protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRemove(context, operation, model);
            knownApplicationSecurityDomains.remove(context.getCurrentAddressValue());
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
            super.performRuntime(context, operation, model);
            if (context.isResourceServiceRestartAllowed()) {
                String securityDomainName = context.getCurrentAddressValue();
                context.removeService(new SingleSignOnManagerServiceNameProvider(securityDomainName).getServiceName());
                context.removeService(new SingleSignOnSessionFactoryServiceNameProvider(securityDomainName).getServiceName());
            }
        }

        protected ServiceName serviceName(String name) {
            RuntimeCapability dynamicCapability = APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY.fromBaseCapability(name);
            return dynamicCapability.getCapabilityServiceName(BiFunction.class);
        }
    }

    private static class AddHandler
    extends AbstractAddStepHandler {
        private AddHandler() {
            super(ATTRIBUTES);
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            knownApplicationSecurityDomains.add(context.getCurrentAddressValue());
        }

        protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.recordCapabilitiesAndRequirements(context, operation, resource);
            KnownDeploymentsApi knownDeployments = new KnownDeploymentsApi();
            context.registerCapability(RuntimeCapability.Builder.of((String)"org.wildfly.undertow.application-security-domain.known-deployments", (boolean)true, (Object)knownDeployments).build().fromBaseCapability(context.getCurrentAddressValue()));
            context.attach(KNOWN_DEPLOYMENTS_KEY, (Object)knownDeployments);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            Supplier<UnaryOperator> transformerSupplier;
            Function factoryFunction;
            ModelNode model = resource.getModel();
            CapabilityServiceTarget target = context.getCapabilityServiceTarget();
            String securityDomain = SECURITY_DOMAIN.resolveModelAttribute(context, model).asStringOrNull();
            String httpServerMechanismFactory = HTTP_AUTHENTICATION_FACTORY.resolveModelAttribute(context, model).asStringOrNull();
            boolean overrideDeploymentConfig = OVERRIDE_DEPLOYMENT_CONFIG.resolveModelAttribute(context, model).asBoolean();
            boolean enableJacc = ENABLE_JACC.resolveModelAttribute(context, model).asBoolean();
            String securityDomainName = context.getCurrentAddressValue();
            ServiceName applicationSecurityDomainName = APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY.getCapabilityServiceName(context.getCurrentAddress());
            ServiceBuilder serviceBuilder = target.addService(applicationSecurityDomainName).setInitialMode(ServiceController.Mode.LAZY);
            if (httpServerMechanismFactory != null) {
                Supplier httpAuthenticationFactorySupplier = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.http-authentication-factory", HttpAuthenticationFactory.class, new String[]{httpServerMechanismFactory}));
                factoryFunction = arg_0 -> AddHandler.lambda$performRuntime$0((Supplier)httpAuthenticationFactorySupplier, arg_0);
            } else {
                Supplier securityDomainSupplier = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.security-domain", SecurityDomain.class, new String[]{securityDomain}));
                factoryFunction = ApplicationSecurityDomainDefinition.toHttpAuthenticationFactoryFunction(securityDomainSupplier);
            }
            if (enableJacc) {
                serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.security.jacc-policy", Policy.class));
            }
            if (resource.hasChild(UndertowExtension.PATH_SSO)) {
                ModelNode ssoModel = resource.getChild(UndertowExtension.PATH_SSO).getModel();
                String cookieName = SingleSignOnDefinition.Attribute.COOKIE_NAME.resolveModelAttribute((ExpressionResolver)context, ssoModel).asString();
                String domain = SingleSignOnDefinition.Attribute.DOMAIN.resolveModelAttribute((ExpressionResolver)context, ssoModel).asString();
                String path = SingleSignOnDefinition.Attribute.PATH.resolveModelAttribute((ExpressionResolver)context, ssoModel).asString();
                boolean httpOnly = SingleSignOnDefinition.Attribute.HTTP_ONLY.resolveModelAttribute((ExpressionResolver)context, ssoModel).asBoolean();
                boolean secure = SingleSignOnDefinition.Attribute.SECURE.resolveModelAttribute((ExpressionResolver)context, ssoModel).asBoolean();
                SingleSignOnServerMechanismFactory.SingleSignOnConfiguration singleSignOnConfiguration = new SingleSignOnServerMechanismFactory.SingleSignOnConfiguration(cookieName, domain, path, httpOnly, secure);
                ServiceName managerServiceName = new SingleSignOnManagerServiceNameProvider(securityDomainName).getServiceName();
                SecureRandomSessionIdGenerator generator = new SecureRandomSessionIdGenerator();
                DistributableSecurityDomainSingleSignOnManagerServiceConfiguratorProvider.INSTANCE.map(arg_0 -> AddHandler.lambda$performRuntime$1(managerServiceName, securityDomainName, (SessionIdGenerator)generator, arg_0)).orElse((CapabilityServiceConfigurator)new SimpleCapabilityServiceConfigurator(managerServiceName, (Object)new DefaultSingleSignOnManager(new ConcurrentHashMap(), () -> ((SessionIdGenerator)generator).createSessionId()))).configure(context).build((ServiceTarget)target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                ServiceConfigurator factoryConfigurator = new SingleSignOnSessionFactoryServiceConfigurator(securityDomainName).configure(context, ssoModel);
                factoryConfigurator.build((ServiceTarget)target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                Supplier singleSignOnSessionFactorySupplier = serviceBuilder.requires(factoryConfigurator.getServiceName());
                UnaryOperator transformer = arg_0 -> AddHandler.lambda$performRuntime$2((Supplier)singleSignOnSessionFactorySupplier, singleSignOnConfiguration, arg_0);
                transformerSupplier = () -> transformer;
            } else {
                transformerSupplier = () -> null;
            }
            Consumer valueConsumer = serviceBuilder.provides(new ServiceName[]{applicationSecurityDomainName});
            ApplicationSecurityDomainService service = new ApplicationSecurityDomainService(overrideDeploymentConfig, enableJacc, factoryFunction, transformerSupplier, valueConsumer);
            serviceBuilder.setInstance((Service)service);
            serviceBuilder.install();
            KnownDeploymentsApi knownDeploymentsApi = (KnownDeploymentsApi)context.getAttachment(KNOWN_DEPLOYMENTS_KEY);
            knownDeploymentsApi.setApplicationSecurityDomainService(service);
        }

        private static /* synthetic */ HttpServerAuthenticationMechanismFactory lambda$performRuntime$2(Supplier singleSignOnSessionFactorySupplier, SingleSignOnServerMechanismFactory.SingleSignOnConfiguration singleSignOnConfiguration, HttpServerAuthenticationMechanismFactory factory) {
            return new SingleSignOnServerMechanismFactory(factory, (SingleSignOnSessionFactory)singleSignOnSessionFactorySupplier.get(), singleSignOnConfiguration);
        }

        private static /* synthetic */ CapabilityServiceConfigurator lambda$performRuntime$1(ServiceName managerServiceName, String securityDomainName, SessionIdGenerator generator, DistributableSecurityDomainSingleSignOnManagerServiceConfiguratorProvider provider) {
            return provider.getServiceConfigurator(managerServiceName, securityDomainName, generator);
        }

        private static /* synthetic */ HttpAuthenticationFactory lambda$performRuntime$0(Supplier httpAuthenticationFactorySupplier, String s) {
            return (HttpAuthenticationFactory)httpAuthenticationFactorySupplier.get();
        }
    }

    private static class ReferencingDeploymentsHandler
    implements OperationStepHandler {
        private ReferencingDeploymentsHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.isDefaultRequiresRuntime()) {
                context.addStep((ctx, op) -> {
                    KnownDeploymentsApi knownDeploymentsApi = (KnownDeploymentsApi)context.getCapabilityRuntimeAPI("org.wildfly.undertow.application-security-domain.known-deployments", ctx.getCurrentAddressValue(), KnownDeploymentsApi.class);
                    ModelNode deploymentList = new ModelNode();
                    for (String current : knownDeploymentsApi.getKnownDeployments()) {
                        deploymentList.add(current);
                    }
                    context.getResult().set(deploymentList);
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
}

