/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Queue;
import org.jboss.threads.Messages;
import org.wildfly.common.Assert;

public final class ArrayQueue<E>
extends AbstractQueue<E>
implements Queue<E> {
    private final E[] elements;
    private int head;
    private int tail;
    private int modCnt;

    public ArrayQueue(int capacity) {
        this.elements = new Object[capacity];
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int pos = 0;
            private int size = ArrayQueue.this.size();
            private final int modIdx = ArrayQueue.access$000(ArrayQueue.this);

            @Override
            public boolean hasNext() {
                if (ArrayQueue.this.modCnt != this.modIdx) {
                    throw Messages.msg.concurrentModification();
                }
                return this.pos < this.size;
            }

            @Override
            public E next() {
                if (ArrayQueue.this.modCnt != this.modIdx) {
                    throw Messages.msg.concurrentModification();
                }
                int pos = this.pos;
                if (pos >= this.size) {
                    throw Messages.msg.noSuchElement();
                }
                Object[] elements = ArrayQueue.this.elements;
                Object value = elements[(ArrayQueue.this.tail + pos) % elements.length];
                this.pos = pos + 1;
                return value;
            }

            @Override
            public void remove() {
                throw Assert.unsupported();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.elements[this.tail] == null;
    }

    @Override
    public int size() {
        int head = this.head;
        E[] elements = this.elements;
        int tail = this.tail;
        if (elements[tail] == null) {
            return 0;
        }
        if (head > tail) {
            return head - tail;
        }
        return head + elements.length - tail;
    }

    @Override
    public boolean offer(E e) {
        Assert.checkNotNullParam("e", e);
        int head = this.head;
        E[] elements = this.elements;
        int len = elements.length;
        if (elements[head] != null) {
            return false;
        }
        elements[head] = e;
        this.head = (head + 1) % len;
        ++this.modCnt;
        return true;
    }

    @Override
    public E poll() {
        E[] elements = this.elements;
        int tail = this.tail;
        E value = elements[tail];
        if (value != null) {
            ++this.modCnt;
            elements[tail] = null;
            this.tail = (tail + 1) % elements.length;
        }
        return value;
    }

    @Override
    public E peek() {
        int tail = this.tail;
        return tail == -1 ? null : (E)this.elements[tail];
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, null);
        ++this.modCnt;
        this.head = 0;
        this.tail = 0;
    }
}

