/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.modcluster.config.ModClusterConfiguration;
import org.jboss.modcluster.config.ProxyConfiguration;
import org.jboss.modcluster.config.SSLConfiguration;
import org.jboss.modcluster.config.SessionDrainingStrategy;
import org.jboss.modcluster.config.builder.ModClusterConfigurationBuilder;
import org.jboss.modcluster.config.impl.ModClusterConfig;
import org.jboss.modcluster.config.impl.SessionDrainingStrategyEnum;
import org.jboss.modcluster.mcmp.impl.JSSESocketFactory;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.extension.mod_cluster.ContainerEventHandlerServiceConfigurator;
import org.wildfly.extension.mod_cluster.ModClusterConfigResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ModClusterSSLResourceDefinition;

public class ModClusterConfigurationServiceConfigurator
implements ResourceServiceConfigurator,
Supplier<ModClusterConfiguration> {
    private final ModClusterConfigurationBuilder builder = new ModClusterConfigurationBuilder();
    private final List<SupplierDependency<OutboundSocketBinding>> outboundSocketBindings = new LinkedList<SupplierDependency<OutboundSocketBinding>>();
    private volatile SupplierDependency<SocketBinding> advertiseSocketDependency = null;
    private volatile SupplierDependency<SSLContext> sslContextDependency = null;

    public ServiceName getServiceName() {
        return ContainerEventHandlerServiceConfigurator.CONFIG_SERVICE_NAME;
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNodes.optionalString((ModelNode)ModClusterConfigResourceDefinition.ADVERTISE_SOCKET.resolveModelAttribute(context, model)).ifPresent(advertiseSocketRef -> {
            this.advertiseSocketDependency = new ServiceSupplierDependency(context.getCapabilityServiceName(CommonUnaryRequirement.SOCKET_BINDING.getName(), advertiseSocketRef, SocketBinding.class));
        });
        ModelNodes.optionalString((ModelNode)ModClusterConfigResourceDefinition.ADVERTISE_SECURITY_KEY.resolveModelAttribute(context, model)).ifPresent(securityKey -> this.builder.advertise().setAdvertiseSecurityKey(securityKey));
        this.builder.mcmp().setAdvertise(Boolean.valueOf(ModClusterConfigResourceDefinition.ADVERTISE.resolveModelAttribute(context, model).asBoolean())).setProxyURL(ModClusterConfigResourceDefinition.PROXY_URL.resolveModelAttribute(context, model).asString()).setAutoEnableContexts(ModClusterConfigResourceDefinition.AUTO_ENABLE_CONTEXTS.resolveModelAttribute(context, model).asBoolean()).setStopContextTimeout((long)ModClusterConfigResourceDefinition.STOP_CONTEXT_TIMEOUT.resolveModelAttribute(context, model).asInt()).setStopContextTimeoutUnit(TimeUnit.valueOf(ModClusterConfigResourceDefinition.STOP_CONTEXT_TIMEOUT.getMeasurementUnit().getName())).setSocketTimeout(ModClusterConfigResourceDefinition.SOCKET_TIMEOUT.resolveModelAttribute(context, model).asInt() * 1000).setSessionDrainingStrategy((SessionDrainingStrategy)Enum.valueOf(SessionDrainingStrategyEnum.class, ModClusterConfigResourceDefinition.SESSION_DRAINING_STRATEGY.resolveModelAttribute(context, model).asString()));
        if (model.hasDefined("excluded-contexts")) {
            Object excludedContextsPerHost;
            String contexts = ModClusterConfigResourceDefinition.EXCLUDED_CONTEXTS.resolveModelAttribute(context, model).asString();
            if (contexts == null) {
                excludedContextsPerHost = Collections.emptyMap();
            } else {
                String trimmedContexts = contexts.trim();
                if (trimmedContexts.isEmpty()) {
                    excludedContextsPerHost = Collections.emptyMap();
                } else {
                    excludedContextsPerHost = new HashMap();
                    for (String c : trimmedContexts.split(",")) {
                        String path;
                        String[] parts = c.trim().split(":");
                        if (parts.length > 2) {
                            throw ModClusterLogger.ROOT_LOGGER.excludedContextsWrongFormat(trimmedContexts);
                        }
                        String host = null;
                        String trimmedContext = parts[0].trim();
                        if (parts.length == 2) {
                            host = trimmedContext;
                            trimmedContext = parts[1].trim();
                        }
                        switch (trimmedContext) {
                            case "ROOT": {
                                ModClusterLogger.ROOT_LOGGER.excludedContextsUseSlashInsteadROOT();
                            }
                            case "/": {
                                path = "";
                                break;
                            }
                            default: {
                                trimmedContext = trimmedContext.startsWith("/") ? trimmedContext : "/" + trimmedContext;
                                path = trimmedContext.endsWith("/") ? trimmedContext.substring(0, trimmedContext.length() - 1) : trimmedContext;
                            }
                        }
                        Set paths = excludedContextsPerHost.computeIfAbsent(host, k -> new HashSet());
                        paths.add(path);
                    }
                }
            }
            this.builder.mcmp().setExcludedContextsPerHost(excludedContextsPerHost);
        }
        this.builder.balancer().setStickySession(ModClusterConfigResourceDefinition.STICKY_SESSION.resolveModelAttribute(context, model).asBoolean()).setStickySessionRemove(ModClusterConfigResourceDefinition.STICKY_SESSION_REMOVE.resolveModelAttribute(context, model).asBoolean()).setStickySessionForce(ModClusterConfigResourceDefinition.STICKY_SESSION_FORCE.resolveModelAttribute(context, model).asBoolean()).setWorkerTimeout(ModClusterConfigResourceDefinition.WORKER_TIMEOUT.resolveModelAttribute(context, model).asInt()).setMaxAttempts(ModClusterConfigResourceDefinition.MAX_ATTEMPTS.resolveModelAttribute(context, model).asInt());
        this.builder.node().setFlushPackets(ModClusterConfigResourceDefinition.FLUSH_PACKETS.resolveModelAttribute(context, model).asBoolean()).setFlushWait(ModClusterConfigResourceDefinition.FLUSH_WAIT.resolveModelAttribute(context, model).asInt()).setPing(ModClusterConfigResourceDefinition.PING.resolveModelAttribute(context, model).asInt()).setSmax(ModClusterConfigResourceDefinition.SMAX.resolveModelAttribute(context, model).asInt()).setTtl(ModClusterConfigResourceDefinition.TTL.resolveModelAttribute(context, model).asInt()).setNodeTimeout(ModClusterConfigResourceDefinition.NODE_TIMEOUT.resolveModelAttribute(context, model).asInt());
        ModelNode node = ModClusterConfigResourceDefinition.BALANCER.resolveModelAttribute(context, model);
        if (node.isDefined()) {
            this.builder.node().setBalancer(node.asString());
        }
        if ((node = ModClusterConfigResourceDefinition.LOAD_BALANCING_GROUP.resolveModelAttribute(context, model)).isDefined()) {
            this.builder.node().setLoadBalancingGroup(node.asString());
        }
        if ((node = ModClusterConfigResourceDefinition.PROXIES.resolveModelAttribute(context, model)).isDefined()) {
            for (ModelNode ref : node.asList()) {
                String asString = ref.asString();
                this.outboundSocketBindings.add((SupplierDependency<OutboundSocketBinding>)new ServiceSupplierDependency(CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING.getServiceName(context, asString)));
            }
        }
        if (model.hasDefined("proxy-list")) {
            throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.proxyListNotAllowedInCurrentModel());
        }
        node = ModClusterConfigResourceDefinition.SSL_CONTEXT.resolveModelAttribute(context, model);
        if (node.isDefined()) {
            this.sslContextDependency = new ServiceSupplierDependency(CommonUnaryRequirement.SSL_CONTEXT.getServiceName(context, node.asString()));
        }
        if (model.get(ModClusterSSLResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
            if (node.isDefined()) {
                throw ModClusterLogger.ROOT_LOGGER.bothElytronAndLegacySslContextDefined();
            }
            ModelNode sslModel = model.get(ModClusterSSLResourceDefinition.PATH.getKeyValuePair());
            ModClusterConfig sslConfiguration = new ModClusterConfig();
            node = ModClusterSSLResourceDefinition.KEY_ALIAS.resolveModelAttribute(context, sslModel);
            if (node.isDefined()) {
                sslConfiguration.setSslKeyAlias(node.asString());
            }
            if ((node = ModClusterSSLResourceDefinition.PASSWORD.resolveModelAttribute(context, sslModel)).isDefined()) {
                String str = node.toString();
                sslConfiguration.setSslTrustStorePassword(str);
                sslConfiguration.setSslKeyStorePassword(str);
            }
            if ((node = ModClusterSSLResourceDefinition.CERTIFICATE_KEY_FILE.resolveModelAttribute(context, sslModel)).isDefined()) {
                sslConfiguration.setSslKeyStore(node.asString());
            }
            if ((node = ModClusterSSLResourceDefinition.CIPHER_SUITE.resolveModelAttribute(context, sslModel)).isDefined()) {
                sslConfiguration.setSslCiphers(node.asString());
            }
            if ((node = ModClusterSSLResourceDefinition.PROTOCOL.resolveModelAttribute(context, sslModel)).isDefined()) {
                sslConfiguration.setSslProtocol(node.asString());
            }
            if ((node = ModClusterSSLResourceDefinition.CA_CERTIFICATE_FILE.resolveModelAttribute(context, sslModel)).isDefined()) {
                sslConfiguration.setSslTrustStore(node.asString());
            }
            if ((node = ModClusterSSLResourceDefinition.CA_REVOCATION_URL.resolveModelAttribute(context, sslModel)).isDefined()) {
                sslConfiguration.setSslCrlFile(node.asString());
            }
            this.builder.mcmp().setSocketFactory((SocketFactory)new JSSESocketFactory((SSLConfiguration)sslConfiguration));
        }
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer config = new CompositeDependency(new Dependency[]{this.advertiseSocketDependency, this.sslContextDependency}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        for (Dependency dependency : this.outboundSocketBindings) {
            dependency.register(builder);
        }
        FunctionalService service = new FunctionalService(config, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.PASSIVE);
    }

    @Override
    public ModClusterConfiguration get() {
        if (this.advertiseSocketDependency != null) {
            SocketBinding binding = (SocketBinding)this.advertiseSocketDependency.get();
            this.builder.advertise().setAdvertiseSocketAddress(binding.getMulticastSocketAddress()).setAdvertiseInterface(binding.getNetworkInterfaceBinding().getAddress());
            if (!ModClusterConfigurationServiceConfigurator.isMulticastEnabled(binding.getSocketBindings().getDefaultInterfaceBinding().getNetworkInterfaces())) {
                ModClusterLogger.ROOT_LOGGER.multicastInterfaceNotAvailable();
            }
        }
        LinkedList<1> proxies = new LinkedList<1>();
        for (Supplier supplier : this.outboundSocketBindings) {
            final OutboundSocketBinding binding = (OutboundSocketBinding)supplier.get();
            proxies.add(new ProxyConfiguration(){

                public InetSocketAddress getRemoteAddress() {
                    return new InetSocketAddress(binding.getUnresolvedDestinationAddress(), binding.getDestinationPort());
                }

                public InetSocketAddress getLocalAddress() {
                    if (binding.getOptionalSourceAddress() != null) {
                        return new InetSocketAddress(binding.getOptionalSourceAddress(), binding.getAbsoluteSourcePort() == null ? 0 : binding.getAbsoluteSourcePort());
                    }
                    if (binding.getAbsoluteSourcePort() != null) {
                        return new InetSocketAddress(binding.getAbsoluteSourcePort());
                    }
                    return null;
                }
            });
        }
        this.builder.mcmp().setProxyConfigurations(proxies);
        if (this.sslContextDependency != null) {
            this.builder.mcmp().setSocketFactory((SocketFactory)((SSLContext)this.sslContextDependency.get()).getSocketFactory());
        }
        return this.builder.build();
    }

    private static boolean isMulticastEnabled(Collection<NetworkInterface> interfaces) {
        for (NetworkInterface iface : interfaces) {
            try {
                if (!iface.isUp() || !iface.supportsMulticast() && !iface.isLoopback()) continue;
                return true;
            }
            catch (SocketException socketException) {
            }
        }
        return false;
    }
}

