/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.modcluster.ModClusterServiceMBean;
import org.wildfly.clustering.service.ActiveServiceSupplier;
import org.wildfly.extension.mod_cluster.ContainerEventHandlerServiceConfigurator;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ModClusterSubsystemResourceDefinition;

public class ModClusterStop
implements OperationStepHandler {
    static final ModClusterStop INSTANCE = new ModClusterStop();

    static OperationDefinition getDefinition(ResourceDescriptionResolver descriptionResolver) {
        return new SimpleOperationDefinitionBuilder("stop", descriptionResolver).addParameter((AttributeDefinition)ModClusterSubsystemResourceDefinition.WAIT_TIME).setRuntimeOnly().build();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer() && context.getServiceRegistry(false).getService(ContainerEventHandlerServiceConfigurator.SERVICE_NAME) != null) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final ModClusterServiceMBean service = (ModClusterServiceMBean)new ActiveServiceSupplier(context.getServiceRegistry(true), ContainerEventHandlerServiceConfigurator.SERVICE_NAME).get();
                    ModClusterLogger.ROOT_LOGGER.debugf("stop: %s", operation);
                    int waitTime = ModClusterSubsystemResourceDefinition.WAIT_TIME.resolveModelAttribute(context, operation).asInt();
                    boolean success = service.stop((long)waitTime, TimeUnit.SECONDS);
                    context.getResult().get("session-draining-complete").set(success);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            service.enable();
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

