/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

@Immutable
public class StatsOperation
extends RetryOnFailureOperation<Map<String, String>> {
    private Map<String, String> result;
    private int numStats = -1;

    public StatsOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg) {
        super((short)21, (short)22, codec, channelFactory, cacheName, topologyId, flags, cfg);
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.sendHeaderAndRead(channel);
    }

    @Override
    protected void reset() {
        this.result = null;
        this.numStats = -1;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (this.numStats < 0) {
            this.numStats = ByteBufUtil.readVInt(buf);
            this.result = new HashMap<String, String>();
            decoder.checkpoint();
        }
        while (this.result.size() < this.numStats) {
            String statName = ByteBufUtil.readString(buf);
            String statValue = ByteBufUtil.readString(buf);
            this.result.put(statName, statValue);
            decoder.checkpoint();
        }
        this.complete(this.result);
    }
}

