/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.metadata.Metadata;

public class CompatibilityInterceptor
extends DDAsyncInterceptor {
    @Inject
    protected VersionGenerator versionGenerator;

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        this.addVersionIfNeeded(command);
        return super.visitReplaceCommand(ctx, command);
    }

    protected void addVersionIfNeeded(MetadataAwareCommand cmd) {
        Metadata metadata = cmd.getMetadata();
        if (metadata.version() == null) {
            Metadata newMetadata = metadata.builder().version(this.versionGenerator.generateNew()).build();
            cmd.setMetadata(newMetadata);
        }
    }
}

