/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.io.ByteBufferFactory;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.eviction.EvictionType;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.filter.KeyFilter;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.TransactionalStoreInterceptor;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.async.AdvancedAsyncCacheLoader;
import org.infinispan.persistence.async.AdvancedAsyncCacheWriter;
import org.infinispan.persistence.async.AsyncCacheLoader;
import org.infinispan.persistence.async.AsyncCacheWriter;
import org.infinispan.persistence.async.State;
import org.infinispan.persistence.factory.CacheStoreFactoryRegistry;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheExpirationWriter;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.FlagAffectedStore;
import org.infinispan.persistence.spi.LocalOnlyCacheLoader;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.spi.TransactionalCacheWriter;
import org.infinispan.persistence.support.AdvancedSingletonCacheWriter;
import org.infinispan.persistence.support.BatchModification;
import org.infinispan.persistence.support.DelegatingCacheLoader;
import org.infinispan.persistence.support.DelegatingCacheWriter;
import org.infinispan.persistence.support.SingletonCacheWriter;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PersistenceManagerImpl
implements PersistenceManager {
    private static final Log log = LogFactory.getLog(PersistenceManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    private Configuration configuration;
    @Inject
    private AdvancedCache<Object, Object> cache;
    @Inject
    private StreamingMarshaller m;
    @Inject
    private TransactionManager transactionManager;
    @Inject
    private TimeService timeService;
    @Inject
    @ComponentName(value="org.infinispan.executors.persistence")
    private Executor persistenceExecutor;
    @Inject
    private ByteBufferFactory byteBufferFactory;
    @Inject
    private MarshalledEntryFactory marshalledEntryFactory;
    @Inject
    private CacheStoreFactoryRegistry cacheStoreFactoryRegistry;
    @Inject
    private ExpirationManager<Object, Object> expirationManager;
    @GuardedBy(value="storesMutex")
    private final List<CacheLoader> loaders = new ArrayList<CacheLoader>();
    @GuardedBy(value="storesMutex")
    private final List<CacheWriter> nonTxWriters = new ArrayList<CacheWriter>();
    @GuardedBy(value="storesMutex")
    private final List<TransactionalCacheWriter> txWriters = new ArrayList<TransactionalCacheWriter>();
    private final ReadWriteLock storesMutex = new ReentrantReadWriteLock();
    private final Map<Object, StoreConfiguration> configMap = new HashMap<Object, StoreConfiguration>();
    private AdvancedPurgeListener<Object, Object> advancedListener;
    private volatile boolean enabled;
    private volatile boolean clearOnStop;
    private boolean preloaded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Start
    public void start() {
        this.advancedListener = new AdvancedPurgeListener(this.expirationManager);
        this.preloaded = false;
        this.enabled = this.configuration.persistence().usingStores();
        if (!this.enabled) {
            return;
        }
        try {
            this.createLoadersAndWriters();
            Transaction xaTx = null;
            if (this.transactionManager != null) {
                xaTx = this.transactionManager.suspend();
            }
            this.storesMutex.readLock().lock();
            try {
                HashSet undelegated = new HashSet();
                Consumer<CacheWriter> startWriter = writer -> {
                    writer.start();
                    if (writer instanceof DelegatingCacheWriter) {
                        CacheWriter actual = this.undelegate((CacheWriter)writer);
                        actual.start();
                        undelegated.add(actual);
                    } else {
                        undelegated.add(writer);
                    }
                    if (this.configMap.get(writer).purgeOnStartup()) {
                        if (!(writer instanceof AdvancedCacheWriter)) {
                            throw new PersistenceException("'purgeOnStartup' can only be set on stores implementing " + AdvancedCacheWriter.class.getName());
                        }
                        ((AdvancedCacheWriter)writer).clear();
                    }
                };
                this.nonTxWriters.forEach(startWriter);
                this.txWriters.forEach(startWriter);
                for (CacheLoader l : this.loaders) {
                    CacheLoader actual;
                    if (!undelegated.contains(l)) {
                        l.start();
                    }
                    if (!(l instanceof DelegatingCacheLoader) || undelegated.contains(actual = this.undelegate(l))) continue;
                    actual.start();
                }
            }
            finally {
                if (xaTx != null) {
                    this.transactionManager.resume(xaTx);
                }
                this.storesMutex.readLock().unlock();
            }
        }
        catch (Exception e) {
            throw new CacheException("Unable to start cache loaders", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Stop
    public void stop() {
        this.storesMutex.writeLock().lock();
        try {
            if (this.clearOnStop) {
                this.clearAllStores(PersistenceManager.AccessMode.BOTH);
            }
            HashSet undelegated = new HashSet();
            Consumer<CacheWriter> stopWriters = writer -> {
                writer.stop();
                if (writer instanceof DelegatingCacheWriter) {
                    CacheWriter actual = this.undelegate((CacheWriter)writer);
                    actual.stop();
                    undelegated.add(actual);
                } else {
                    undelegated.add(writer);
                }
            };
            this.nonTxWriters.forEach(stopWriters);
            this.nonTxWriters.clear();
            this.txWriters.forEach(stopWriters);
            this.txWriters.clear();
            for (CacheLoader l : this.loaders) {
                CacheLoader actual;
                if (!undelegated.contains(l)) {
                    l.stop();
                }
                if (!(l instanceof DelegatingCacheLoader) || undelegated.contains(actual = this.undelegate(l))) continue;
                actual.stop();
            }
            this.loaders.clear();
            this.preloaded = false;
        }
        finally {
            this.storesMutex.writeLock().unlock();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isPreloaded() {
        return this.preloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Start(priority=56)
    public void preload() {
        if (!this.enabled) {
            return;
        }
        AdvancedCacheLoader preloadCl = null;
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders) {
                if (!this.configMap.get(l).preload()) continue;
                if (!(l instanceof AdvancedCacheLoader)) {
                    throw new PersistenceException("Cannot preload from cache loader '" + l.getClass().getName() + "' as it doesn't implement '" + AdvancedCacheLoader.class.getName() + "'");
                }
                preloadCl = (AdvancedCacheLoader)l;
                if (preloadCl instanceof AdvancedAsyncCacheLoader) {
                    preloadCl = (AdvancedCacheLoader)((AdvancedAsyncCacheLoader)preloadCl).undelegate();
                }
                break;
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
        if (preloadCl == null) {
            return;
        }
        long start = this.timeService.time();
        long maxEntries = this.getMaxEntries();
        AtomicInteger loadedEntries = new AtomicInteger(0);
        AdvancedCache<Object, Object> flaggedCache = this.getCacheForStateInsertion();
        ByRef.Boolean preloaded = new ByRef.Boolean(true);
        preloadCl.process(null, (me, taskContext) -> {
            if ((long)loadedEntries.getAndIncrement() >= maxEntries) {
                taskContext.stop();
                preloaded.set(false);
                return;
            }
            Metadata metadata = me.getMetadata() != null ? ((InternalMetadataImpl)me.getMetadata()).actual() : null;
            this.preloadKey(flaggedCache, me.getKey(), me.getValue(), metadata);
        }, new WithinThreadExecutor(), true, true);
        this.preloaded = preloaded.get();
        log.debugf("Preloaded %d keys in %s", loadedEntries.get(), Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
    }

    @Override
    public void disableStore(String storeType) {
        if (this.enabled) {
            boolean noMoreStores;
            this.storesMutex.writeLock().lock();
            try {
                this.removeCacheLoader(storeType, this.loaders);
                this.removeCacheWriter(storeType, this.nonTxWriters);
                this.removeCacheWriter(storeType, this.txWriters);
                noMoreStores = this.loaders.isEmpty() && this.nonTxWriters.isEmpty() && this.txWriters.isEmpty();
            }
            finally {
                this.storesMutex.writeLock().unlock();
            }
            if (noMoreStores) {
                AsyncInterceptorChain chain = this.cache.getAdvancedCache().getAsyncInterceptorChain();
                CacheLoaderInterceptor loaderInterceptor = chain.findInterceptorExtending(CacheLoaderInterceptor.class);
                if (loaderInterceptor == null) {
                    log.persistenceWithoutCacheLoaderInterceptor();
                } else {
                    chain.removeInterceptor(loaderInterceptor.getClass());
                }
                DDAsyncInterceptor writerInterceptor = chain.findInterceptorExtending(CacheWriterInterceptor.class);
                if (writerInterceptor == null) {
                    writerInterceptor = chain.findInterceptorWithClass(TransactionalStoreInterceptor.class);
                    if (writerInterceptor == null) {
                        log.persistenceWithoutCacheWriteInterceptor();
                    } else {
                        chain.removeInterceptor(writerInterceptor.getClass());
                    }
                } else {
                    chain.removeInterceptor(writerInterceptor.getClass());
                }
                this.enabled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Set<T> getStores(Class<T> storeClass) {
        this.storesMutex.readLock().lock();
        try {
            HashSet result = new HashSet();
            for (CacheLoader l : this.loaders) {
                CacheLoader real = this.undelegate(l);
                if (!storeClass.isInstance(real)) continue;
                result.add(storeClass.cast(real));
            }
            Consumer<CacheWriter> getWriters = writer -> {
                CacheWriter real = this.undelegate((CacheWriter)writer);
                if (storeClass.isInstance(real)) {
                    result.add(storeClass.cast(real));
                }
            };
            this.nonTxWriters.forEach(getWriters);
            this.txWriters.forEach(getWriters);
            HashSet hashSet = result;
            return hashSet;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getStoresAsString() {
        this.storesMutex.readLock().lock();
        try {
            HashSet<String> loaderTypes = new HashSet<String>(this.loaders.size());
            for (CacheLoader cacheLoader : this.loaders) {
                loaderTypes.add(this.undelegate(cacheLoader).getClass().getName());
            }
            for (CacheWriter cacheWriter : this.nonTxWriters) {
                loaderTypes.add(this.undelegate(cacheWriter).getClass().getName());
            }
            for (CacheWriter cacheWriter : this.txWriters) {
                loaderTypes.add(this.undelegate(cacheWriter).getClass().getName());
            }
            HashSet<String> hashSet = loaderTypes;
            return hashSet;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeExpired() {
        if (!this.enabled) {
            return;
        }
        long start = -1L;
        try {
            if (trace) {
                log.trace("Purging cache store of expired entries");
                start = this.timeService.time();
            }
            this.storesMutex.readLock().lock();
            try {
                Consumer<CacheWriter> purgeWriter = writer -> {
                    if (this.configMap.get(writer).shared() && !this.cache.getCacheManager().isCoordinator()) {
                        return;
                    }
                    if (writer instanceof AdvancedCacheExpirationWriter) {
                        ((AdvancedCacheExpirationWriter)writer).purge(this.persistenceExecutor, this.advancedListener);
                    } else if (writer instanceof AdvancedCacheWriter) {
                        ((AdvancedCacheWriter)writer).purge(this.persistenceExecutor, key -> this.expirationManager.handleInStoreExpiration(key));
                    }
                };
                this.nonTxWriters.forEach(purgeWriter);
                this.txWriters.forEach(purgeWriter);
            }
            finally {
                this.storesMutex.readLock().unlock();
            }
            if (trace) {
                log.tracef("Purging cache store completed in %s", Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
            }
        }
        catch (Exception e) {
            log.exceptionPurgingDataContainer(e);
        }
    }

    @Override
    public void clearAllStores(PersistenceManager.AccessMode mode) {
        this.storesMutex.readLock().lock();
        try {
            Consumer<CacheWriter> clearWriter = writer -> {
                if (writer instanceof AdvancedCacheWriter && mode.canPerform(this.configMap.get(writer))) {
                    ((AdvancedCacheWriter)writer).clear();
                }
            };
            this.nonTxWriters.forEach(clearWriter);
            this.txWriters.forEach(clearWriter);
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFromAllStores(Object key, PersistenceManager.AccessMode mode) {
        this.storesMutex.readLock().lock();
        try {
            boolean removed = false;
            for (CacheWriter w : this.nonTxWriters) {
                if (!mode.canPerform(this.configMap.get(w))) continue;
                removed |= w.delete(key);
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    @Override
    public void processOnAllStores(KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask task, boolean fetchValue, boolean fetchMetadata) {
        this.processOnAllStores(this.persistenceExecutor, keyFilter, task, fetchValue, fetchMetadata);
    }

    @Override
    public void processOnAllStores(Executor executor, KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask task, boolean fetchValue, boolean fetchMetadata) {
        this.processOnAllStores(executor, keyFilter, task, fetchValue, fetchMetadata, PersistenceManager.AccessMode.BOTH);
    }

    @Override
    public void processOnAllStores(KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask task, boolean fetchValue, boolean fetchMetadata, PersistenceManager.AccessMode mode) {
        this.processOnAllStores(this.persistenceExecutor, keyFilter, task, fetchValue, fetchMetadata, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processOnAllStores(Executor executor, KeyFilter keyFilter, AdvancedCacheLoader.CacheLoaderTask task, boolean fetchValue, boolean fetchMetadata, PersistenceManager.AccessMode mode) {
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader loader : this.loaders) {
                if (!mode.canPerform(this.configMap.get(loader)) || !(loader instanceof AdvancedCacheLoader)) continue;
                ((AdvancedCacheLoader)loader).process(keyFilter, task, executor, fetchValue, fetchMetadata);
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MarshalledEntry loadFromAllStores(Object key, boolean localInvocation) {
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders) {
                if (!localInvocation && this.isLocalOnlyLoader(l)) continue;
                MarshalledEntry load = l.load(key);
                if (load == null) continue;
                MarshalledEntry marshalledEntry = load;
                return marshalledEntry;
            }
            Iterator<CacheLoader> iterator = null;
            return iterator;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    private boolean isLocalOnlyLoader(CacheLoader loader) {
        if (loader instanceof LocalOnlyCacheLoader) {
            return true;
        }
        if (loader instanceof DelegatingCacheLoader) {
            CacheLoader unwrappedLoader = ((DelegatingCacheLoader)loader).undelegate();
            return unwrappedLoader instanceof LocalOnlyCacheLoader;
        }
        return false;
    }

    @Override
    public void writeToAllNonTxStores(MarshalledEntry marshalledEntry, PersistenceManager.AccessMode accessMode) {
        this.writeToAllNonTxStores(marshalledEntry, accessMode, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToAllNonTxStores(MarshalledEntry marshalledEntry, PersistenceManager.AccessMode accessMode, long flags) {
        this.storesMutex.readLock().lock();
        try {
            this.nonTxWriters.stream().filter(writer -> !(writer instanceof FlagAffectedStore) || ((FlagAffectedStore)FlagAffectedStore.class.cast(writer)).shouldWrite(flags)).filter(writer -> accessMode.canPerform(this.configMap.get(writer))).forEach(writer -> writer.write(marshalledEntry));
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBatchToAllNonTxStores(Iterable<MarshalledEntry> entries, PersistenceManager.AccessMode accessMode, long flags) {
        this.storesMutex.readLock().lock();
        try {
            this.nonTxWriters.stream().filter(writer -> !(writer instanceof FlagAffectedStore) || ((FlagAffectedStore)FlagAffectedStore.class.cast(writer)).shouldWrite(flags)).filter(writer -> accessMode.canPerform(this.configMap.get(writer))).forEach(writer -> writer.writeBatch(entries));
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBatchFromAllNonTxStores(Iterable<Object> keys, PersistenceManager.AccessMode accessMode, long flags) {
        this.storesMutex.readLock().lock();
        try {
            this.nonTxWriters.stream().filter(writer -> accessMode.canPerform(this.configMap.get(writer))).forEach(writer -> writer.deleteBatch(keys));
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareAllTxStores(Transaction transaction, BatchModification batchModification, PersistenceManager.AccessMode accessMode) throws PersistenceException {
        this.storesMutex.readLock().lock();
        try {
            for (CacheWriter cacheWriter : this.txWriters) {
                if (!accessMode.canPerform(this.configMap.get(cacheWriter)) && !this.configuration.clustering().cacheMode().equals((Object)CacheMode.LOCAL)) continue;
                TransactionalCacheWriter txWriter = (TransactionalCacheWriter)this.undelegate(cacheWriter);
                txWriter.prepareWithModifications(transaction, batchModification);
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    @Override
    public void commitAllTxStores(Transaction transaction, PersistenceManager.AccessMode accessMode) {
        this.performOnAllTxStores(accessMode, writer -> writer.commit(transaction));
    }

    @Override
    public void rollbackAllTxStores(Transaction transaction, PersistenceManager.AccessMode accessMode) {
        this.performOnAllTxStores(accessMode, writer -> writer.rollback(transaction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdvancedCacheLoader getStateTransferProvider() {
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders) {
                StoreConfiguration storeConfiguration = this.configMap.get(l);
                if (!storeConfiguration.fetchPersistentState() || storeConfiguration.shared()) continue;
                AdvancedCacheLoader advancedCacheLoader = (AdvancedCacheLoader)l;
                return advancedCacheLoader;
            }
            Iterator<CacheLoader> iterator = null;
            return iterator;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.storesMutex.readLock().lock();
        try {
            for (CacheLoader l : this.loaders) {
                if (!(l instanceof AdvancedCacheLoader)) continue;
                int n = ((AdvancedCacheLoader)l).size();
                return n;
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
        return 0;
    }

    @Override
    public void setClearOnStop(boolean clearOnStop) {
        this.clearOnStop = clearOnStop;
    }

    public List<CacheLoader> getAllLoaders() {
        this.storesMutex.readLock().lock();
        try {
            ArrayList<CacheLoader> arrayList = new ArrayList<CacheLoader>(this.loaders);
            return arrayList;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    public List<CacheWriter> getAllWriters() {
        this.storesMutex.readLock().lock();
        try {
            ArrayList<CacheWriter> arrayList = new ArrayList<CacheWriter>(this.nonTxWriters);
            return arrayList;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    public List<CacheWriter> getAllTxWriters() {
        this.storesMutex.readLock().lock();
        try {
            ArrayList<CacheWriter> arrayList = new ArrayList<CacheWriter>(this.txWriters);
            return arrayList;
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    private void createLoadersAndWriters() {
        for (StoreConfiguration cfg : this.configuration.persistence().stores()) {
            Object bareInstance = this.cacheStoreFactoryRegistry.createInstance(cfg);
            StoreConfiguration processedConfiguration = this.cacheStoreFactoryRegistry.processStoreConfiguration(cfg);
            CacheWriter writer = this.createCacheWriter(bareInstance);
            CacheLoader loader = this.createCacheLoader(bareInstance);
            writer = this.postProcessWriter(processedConfiguration, writer);
            loader = this.postProcessReader(processedConfiguration, writer, loader);
            InitializationContextImpl ctx = new InitializationContextImpl(processedConfiguration, this.cache, this.m, this.timeService, this.byteBufferFactory, this.marshalledEntryFactory);
            this.initializeLoader(processedConfiguration, loader, ctx);
            this.initializeWriter(processedConfiguration, writer, ctx);
            this.initializeBareInstance(bareInstance, ctx);
        }
    }

    private CacheLoader postProcessReader(StoreConfiguration cfg, CacheWriter writer, CacheLoader loader) {
        if (cfg.async().enabled() && loader != null && writer != null) {
            loader = this.createAsyncLoader(loader, (AsyncCacheWriter)writer);
        }
        return loader;
    }

    private CacheWriter postProcessWriter(StoreConfiguration cfg, CacheWriter writer) {
        if (writer != null) {
            if (cfg.ignoreModifications()) {
                writer = null;
            } else if (cfg.singletonStore().enabled()) {
                writer = this.createSingletonWriter(cfg, writer);
            } else if (cfg.async().enabled()) {
                writer = this.createAsyncWriter(writer);
            }
        }
        return writer;
    }

    private CacheLoader createAsyncLoader(CacheLoader loader, AsyncCacheWriter asyncWriter) {
        AtomicReference<State> state = asyncWriter.getState();
        loader = loader instanceof AdvancedCacheLoader ? new AdvancedAsyncCacheLoader(loader, state) : new AsyncCacheLoader(loader, state);
        return loader;
    }

    private SingletonCacheWriter createSingletonWriter(StoreConfiguration cfg, CacheWriter writer) {
        return writer instanceof AdvancedCacheWriter ? new AdvancedSingletonCacheWriter(writer, cfg.singletonStore()) : new SingletonCacheWriter(writer, cfg.singletonStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeWriter(StoreConfiguration cfg, CacheWriter writer, InitializationContextImpl ctx) {
        if (writer != null) {
            if (writer instanceof DelegatingCacheWriter) {
                writer.init(ctx);
            }
            this.storesMutex.writeLock().lock();
            try {
                if (this.undelegate(writer) instanceof TransactionalCacheWriter && cfg.transactional()) {
                    if (this.configuration.transaction().transactionMode().isTransactional()) {
                        this.txWriters.add((TransactionalCacheWriter)writer);
                    } else {
                        this.nonTxWriters.add(writer);
                    }
                } else {
                    this.nonTxWriters.add(writer);
                }
            }
            finally {
                this.storesMutex.writeLock().unlock();
            }
            this.configMap.put(writer, cfg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLoader(StoreConfiguration cfg, CacheLoader loader, InitializationContextImpl ctx) {
        if (loader != null) {
            if (loader instanceof DelegatingCacheLoader) {
                loader.init(ctx);
            }
            this.storesMutex.writeLock().lock();
            try {
                this.loaders.add(loader);
            }
            finally {
                this.storesMutex.writeLock().unlock();
            }
            this.configMap.put(loader, cfg);
        }
    }

    private void initializeBareInstance(Object instance, InitializationContextImpl ctx) {
        if (instance instanceof CacheWriter) {
            ((CacheWriter)instance).init(ctx);
        } else {
            ((CacheLoader)instance).init(ctx);
        }
    }

    private CacheLoader createCacheLoader(Object instance) {
        return instance instanceof CacheLoader ? (CacheLoader)instance : null;
    }

    private CacheWriter createCacheWriter(Object instance) {
        return instance instanceof CacheWriter ? (CacheWriter)instance : null;
    }

    protected AsyncCacheWriter createAsyncWriter(CacheWriter writer) {
        return writer instanceof AdvancedCacheWriter ? new AdvancedAsyncCacheWriter(writer) : new AsyncCacheWriter(writer);
    }

    private CacheLoader undelegate(CacheLoader l) {
        return l instanceof DelegatingCacheLoader ? ((DelegatingCacheLoader)l).undelegate() : l;
    }

    private CacheWriter undelegate(CacheWriter w) {
        return w instanceof DelegatingCacheWriter ? ((DelegatingCacheWriter)w).undelegate() : w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdvancedCache<Object, Object> getCacheForStateInsertion() {
        ArrayList<Flag> flags = new ArrayList<Flag>(Arrays.asList(Flag.CACHE_MODE_LOCAL, Flag.SKIP_OWNERSHIP_CHECK, Flag.IGNORE_RETURN_VALUES, Flag.SKIP_CACHE_STORE, Flag.SKIP_LOCKING, Flag.SKIP_XSITE_BACKUP));
        boolean hasShared = false;
        this.storesMutex.readLock().lock();
        try {
            for (CacheWriter w : this.nonTxWriters) {
                if (!this.configMap.get(w).shared()) continue;
                hasShared = true;
                break;
            }
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
        if (hasShared) {
            if (this.indexShareable()) {
                flags.add(Flag.SKIP_INDEXING);
            }
        } else {
            flags.add(Flag.SKIP_INDEXING);
        }
        return this.cache.getAdvancedCache().withFlags(flags.toArray(new Flag[flags.size()]));
    }

    private boolean indexShareable() {
        return this.configuration.indexing().indexShareable();
    }

    private long getMaxEntries() {
        if (this.configuration.memory().isEvictionEnabled() && this.configuration.memory().evictionType() == EvictionType.COUNT) {
            return this.configuration.memory().size();
        }
        return Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadKey(AdvancedCache<Object, Object> cache, Object key, Object value, Metadata metadata) {
        Transaction transaction = this.suspendIfNeeded();
        boolean success = false;
        try {
            try {
                this.beginIfNeeded();
                cache.put(key, value, metadata);
                success = true;
            }
            catch (Exception e) {
                throw new PersistenceException("Unable to preload!", e);
            }
            finally {
                this.commitIfNeeded(success);
            }
        }
        finally {
            this.resumeIfNeeded(transaction);
        }
    }

    private void resumeIfNeeded(Transaction transaction) {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null && transaction != null) {
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    private Transaction suspendIfNeeded() {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            try {
                return this.transactionManager.suspend();
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
        return null;
    }

    private void beginIfNeeded() {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            try {
                this.transactionManager.begin();
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    private void commitIfNeeded(boolean success) {
        if (this.configuration.transaction().transactionMode().isTransactional() && this.transactionManager != null) {
            try {
                if (success) {
                    this.transactionManager.commit();
                } else {
                    this.transactionManager.rollback();
                }
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
    }

    public StreamingMarshaller getMarshaller() {
        return this.m;
    }

    private void removeCacheLoader(String storeType, Collection<CacheLoader> collection) {
        Iterator<CacheLoader> it = collection.iterator();
        while (it.hasNext()) {
            CacheLoader loader = it.next();
            this.doRemove(it, storeType, loader, this.undelegate(loader));
        }
    }

    private void removeCacheWriter(String storeType, Collection<? extends CacheWriter> collection) {
        Iterator<? extends CacheWriter> it = collection.iterator();
        while (it.hasNext()) {
            CacheWriter writer = it.next();
            this.doRemove(it, storeType, writer, this.undelegate(writer));
        }
    }

    private void doRemove(Iterator<? extends Lifecycle> it, String storeType, Lifecycle wrapper, Lifecycle actual) {
        if (actual.getClass().getName().equals(storeType)) {
            wrapper.stop();
            if (actual != wrapper) {
                actual.stop();
            }
            it.remove();
        }
    }

    private void performOnAllTxStores(PersistenceManager.AccessMode accessMode, Consumer<TransactionalCacheWriter> action) {
        this.storesMutex.readLock().lock();
        try {
            this.txWriters.stream().filter(writer -> accessMode.canPerform(this.configMap.get(writer))).forEach(action);
        }
        finally {
            this.storesMutex.readLock().unlock();
        }
    }

    private static class AdvancedPurgeListener<K, V>
    implements AdvancedCacheExpirationWriter.ExpirationPurgeListener<K, V> {
        private final ExpirationManager<K, V> expirationManager;

        private AdvancedPurgeListener(ExpirationManager<K, V> expirationManager) {
            this.expirationManager = expirationManager;
        }

        @Override
        public void marshalledEntryPurged(MarshalledEntry<K, V> entry) {
            this.expirationManager.handleInStoreExpiration(entry);
        }

        @Override
        public void entryPurged(K key) {
            this.expirationManager.handleInStoreExpiration(key);
        }
    }
}

