/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import java.time.Duration;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.extension.mod_cluster.ContainerEventHandlerServiceConfigurator;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.mod_cluster.undertow.UndertowEventHandlerAdapterConfiguration;
import org.wildfly.mod_cluster.undertow.UndertowEventHandlerAdapterService;

public class UndertowEventHandlerAdapterServiceConfigurator
implements CapabilityServiceConfigurator,
UndertowEventHandlerAdapterConfiguration {
    static final ServiceName SERVICE_NAME = ContainerEventHandlerServiceConfigurator.SERVICE_NAME.append(new String[]{"undertow"});
    private final String listenerName;
    private final Duration statusInterval;
    private volatile Supplier<ContainerEventHandler> eventHandler;
    private volatile Supplier<SuspendController> suspendController;
    private volatile SupplierDependency<UndertowService> service;
    private volatile SupplierDependency<UndertowListener> listener;

    public UndertowEventHandlerAdapterServiceConfigurator(String listenerName, Duration statusInterval) {
        this.listenerName = listenerName;
        this.statusInterval = statusInterval;
    }

    public ServiceName getServiceName() {
        return SERVICE_NAME;
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.service = new ServiceSupplierDependency(support.getCapabilityServiceName("org.wildfly.undertow"));
        this.listener = new ServiceSupplierDependency(support.getCapabilityServiceName("org.wildfly.undertow.listener", new String[]{this.listenerName}));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(SERVICE_NAME).build(target);
        new CompositeDependency(new Dependency[]{this.service, this.listener}).register(builder);
        this.eventHandler = builder.requires(ContainerEventHandlerServiceConfigurator.SERVICE_NAME);
        this.suspendController = builder.requires(SuspendController.SERVICE_NAME);
        UndertowEventHandlerAdapterService service = new UndertowEventHandlerAdapterService(this);
        return builder.setInstance((Service)service);
    }

    @Override
    public Duration getStatusInterval() {
        return this.statusInterval;
    }

    @Override
    public UndertowService getUndertowService() {
        return (UndertowService)this.service.get();
    }

    @Override
    public ContainerEventHandler getContainerEventHandler() {
        return this.eventHandler.get();
    }

    @Override
    public SuspendController getSuspendController() {
        return this.suspendController.get();
    }

    @Override
    public UndertowListener getListener() {
        return (UndertowListener)this.listener.get();
    }
}

