/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleClassTable;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshalledValueFactory;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactoryServiceConfiguratorProvider;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerFactory;
import org.wildfly.clustering.web.undertow.session.LocalSessionContext;
import org.wildfly.clustering.web.undertow.session.LocalSessionContextFactory;
import org.wildfly.extension.undertow.session.DistributableSessionManagerConfiguration;

public class DistributableSessionManagerFactoryServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Function<SessionManagerFactory<LocalSessionContext, Batch>, io.undertow.servlet.api.SessionManagerFactory> {
    static final Map<ReplicationGranularity, SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy> strategies = new EnumMap<ReplicationGranularity, SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy>(ReplicationGranularity.class);
    private final DistributableSessionManagerConfiguration config;
    private final CapabilityServiceConfigurator configurator;

    public DistributableSessionManagerFactoryServiceConfigurator(ServiceName name, final DistributableSessionManagerConfiguration config, SessionManagerFactoryServiceConfiguratorProvider provider) {
        super(name);
        this.config = config;
        Module module = config.getModule();
        SimpleMarshallingContext context = new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)module), (ClassLoader)module.getClassLoader());
        SimpleMarshalledValueFactory factory = new SimpleMarshalledValueFactory((MarshallingContext)context);
        LocalSessionContextFactory localContextFactory = new LocalSessionContextFactory();
        SessionManagerFactoryConfiguration<MarshallingContext, LocalSessionContext> configuration = new SessionManagerFactoryConfiguration<MarshallingContext, LocalSessionContext>((MarshalledValueFactory)factory, (MarshallingContext)context, (LocalContextFactory)localContextFactory){
            final /* synthetic */ MarshalledValueFactory val$factory;
            final /* synthetic */ MarshallingContext val$context;
            final /* synthetic */ LocalContextFactory val$localContextFactory;
            {
                this.val$factory = marshalledValueFactory;
                this.val$context = marshallingContext;
                this.val$localContextFactory = localContextFactory;
            }

            public int getMaxActiveSessions() {
                return config.getMaxActiveSessions();
            }

            public SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
                return strategies.get(config.getGranularity());
            }

            public String getServerName() {
                return config.getServerName();
            }

            public String getDeploymentName() {
                return config.getDeploymentName();
            }

            public String getCacheName() {
                return config.getCacheName();
            }

            public MarshalledValueFactory<MarshallingContext> getMarshalledValueFactory() {
                return this.val$factory;
            }

            public MarshallingContext getMarshallingContext() {
                return this.val$context;
            }

            public LocalContextFactory<LocalSessionContext> getLocalContextFactory() {
                return this.val$localContextFactory;
            }
        };
        this.configurator = provider.getServiceConfigurator((SessionManagerFactoryConfiguration)configuration);
    }

    @Override
    public io.undertow.servlet.api.SessionManagerFactory apply(SessionManagerFactory<LocalSessionContext, Batch> factory) {
        return new DistributableSessionManagerFactory(factory, this.config);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.configurator.configure(support);
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        this.configurator.build(target).install();
        ServiceBuilder builder = target.addService(this.getServiceName());
        Supplier impl = builder.requires(this.configurator.getServiceName());
        Consumer factory = builder.provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(factory, (Function)this, impl);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    static {
        strategies.put(ReplicationGranularity.SESSION, SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy.COARSE);
        strategies.put(ReplicationGranularity.ATTRIBUTE, SessionManagerFactoryConfiguration.SessionAttributePersistenceStrategy.FINE);
    }

    static enum MarshallingVersion implements Function<Module, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(Module module) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                config.setClassTable((ClassTable)new SimpleClassTable(new Class[]{Serializable.class, Externalizable.class}));
                return config;
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(Module module) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                config.setClassTable((ClassTable)new SimpleClassTable(new Class[]{Serializable.class, Externalizable.class}));
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable((ClassLoader)module.getClassLoader()));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

