/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.triangle.FunctionalBackupWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.ByteString;

public class SingleKeyFunctionalBackupWriteCommand
extends FunctionalBackupWriteCommand {
    public static final byte COMMAND_ID = 77;
    private static final Operation[] CACHED_OPERATION = Operation.values();
    private Operation operation;
    private Object key;
    private Object value;
    private Object prevValue;
    private Metadata prevMetadata;

    public SingleKeyFunctionalBackupWriteCommand() {
        super(null);
    }

    public SingleKeyFunctionalBackupWriteCommand(ByteString cacheName) {
        super(cacheName);
    }

    private static Operation valueOf(int index) {
        return CACHED_OPERATION[index];
    }

    public void init(InvocationContextFactory factory, AsyncInterceptorChain chain, ComponentRegistry componentRegistry) {
        this.injectDependencies(factory, chain);
        this.componentRegistry = componentRegistry;
    }

    @Override
    public byte getCommandId() {
        return 77;
    }

    public void setReadWriteKeyCommand(ReadWriteKeyCommand command) {
        this.operation = Operation.READ_WRITE;
        this.setCommonFields(command);
        this.function = command.getFunction();
    }

    public void setReadWriteKeyValueCommand(ReadWriteKeyValueCommand command) {
        this.operation = Operation.READ_WRITE_KEY_VALUE;
        this.setCommonFields(command);
        this.function = command.getBiFunction();
        this.value = command.getArgument();
        this.prevValue = command.getPrevValue();
        this.prevMetadata = command.getPrevMetadata();
    }

    public void setWriteOnlyKeyValueCommand(WriteOnlyKeyValueCommand command) {
        this.operation = Operation.WRITE_ONLY_KEY_VALUE;
        this.setCommonFields(command);
        this.function = command.getBiConsumer();
        this.value = command.getArgument();
    }

    public void setWriteOnlyKeyCommand(WriteOnlyKeyCommand command) {
        this.operation = Operation.WRITE_ONLY;
        this.setCommonFields(command);
        this.function = command.getConsumer();
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        this.writeBase(output);
        this.writeFunctionAndParams(output);
        MarshallUtil.marshallEnum((Enum)this.operation, (ObjectOutput)output);
        output.writeObject(this.key);
        switch (this.operation) {
            case READ_WRITE_KEY_VALUE: {
                output.writeObject(this.prevValue);
                output.writeObject(this.prevMetadata);
            }
            case WRITE_ONLY_KEY_VALUE: {
                output.writeObject(this.value);
            }
        }
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.readBase(input);
        this.readFunctionAndParams(input);
        this.operation = (Operation)MarshallUtil.unmarshallEnum((ObjectInput)input, SingleKeyFunctionalBackupWriteCommand::valueOf);
        this.key = input.readObject();
        switch (this.operation) {
            case READ_WRITE_KEY_VALUE: {
                this.prevValue = input.readObject();
                this.prevMetadata = (Metadata)input.readObject();
            }
            case WRITE_ONLY_KEY_VALUE: {
                this.value = input.readObject();
            }
        }
    }

    @Override
    WriteCommand createWriteCommand() {
        switch (this.operation) {
            case READ_WRITE: {
                return new ReadWriteKeyCommand(this.key, (Function)this.function, this.getCommandInvocationId(), ValueMatcher.MATCH_ALWAYS, this.params, this.keyDataConversion, this.valueDataConversion, this.componentRegistry);
            }
            case READ_WRITE_KEY_VALUE: {
                return this.createReadWriteKeyValueCommand();
            }
            case WRITE_ONLY: {
                return new WriteOnlyKeyCommand(this.key, (Consumer)this.function, this.getCommandInvocationId(), ValueMatcher.MATCH_ALWAYS, this.params, this.keyDataConversion, this.valueDataConversion, this.componentRegistry);
            }
            case WRITE_ONLY_KEY_VALUE: {
                return new WriteOnlyKeyValueCommand(this.key, this.value, (BiConsumer)this.function, this.getCommandInvocationId(), ValueMatcher.MATCH_ALWAYS, this.params, this.keyDataConversion, this.valueDataConversion, this.componentRegistry);
            }
        }
        throw new IllegalStateException("Unknown operation " + (Object)((Object)this.operation));
    }

    private <C extends AbstractWriteKeyCommand> void setCommonFields(C command) {
        this.setCommonAttributesFromCommand(command);
        this.setFunctionalCommand(command);
        this.key = command.getKey();
    }

    private ReadWriteKeyValueCommand createReadWriteKeyValueCommand() {
        ReadWriteKeyValueCommand cmd = new ReadWriteKeyValueCommand(this.key, this.value, (BiFunction)this.function, this.getCommandInvocationId(), ValueMatcher.MATCH_ALWAYS, this.params, this.keyDataConversion, this.valueDataConversion, this.componentRegistry);
        cmd.setPrevValueAndMetadata(this.prevValue, this.prevMetadata);
        return cmd;
    }

    private static enum Operation {
        READ_WRITE_KEY_VALUE,
        READ_WRITE,
        WRITE_ONLY_KEY_VALUE,
        WRITE_ONLY;

    }
}

