/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Version;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.GlobalStateProvider;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.globalstate.impl.ScopedPersistentStateImpl;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyControlCommand;
import org.infinispan.topology.CacheTopologyHandler;
import org.infinispan.topology.LocalCacheStatus;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.ManagerStatusResponse;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.topology.RebalancingStatus;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="LocalTopologyManager", description="Controls the cache membership and state transfer")
public class LocalTopologyManagerImpl
implements LocalTopologyManager,
GlobalStateProvider {
    private static Log log = LogFactory.getLog(LocalTopologyManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    private Transport transport;
    @Inject
    @ComponentName(value="org.infinispan.executors.transport")
    private ExecutorService asyncTransportExecutor;
    @Inject
    private GlobalComponentRegistry gcr;
    @Inject
    private TimeService timeService;
    @Inject
    private GlobalStateManager globalStateManager;
    @Inject
    private PersistentUUIDManager persistentUUIDManager;
    private final WithinThreadExecutor withinThreadExecutor = new WithinThreadExecutor();
    private final Map<String, LocalCacheStatus> runningCaches = Collections.synchronizedMap(new HashMap());
    private volatile boolean running;
    @GuardedBy(value="runningCaches")
    private int latestStatusResponseViewId;
    private PersistentUUID persistentUUID;

    @Start(priority=0)
    public void preStart() {
        if (this.globalStateManager != null) {
            this.globalStateManager.registerStateProvider(this);
        }
    }

    @Start(priority=100)
    @GuardedBy(value="runningCaches")
    public void start() {
        if (trace) {
            log.tracef("Starting LocalTopologyManager on %s", this.transport.getAddress());
        }
        if (this.persistentUUID == null) {
            this.persistentUUID = PersistentUUID.randomUUID();
            this.globalStateManager.writeGlobalState();
        }
        this.persistentUUIDManager.addPersistentAddressMapping(this.transport.getAddress(), this.persistentUUID);
        this.running = true;
        this.latestStatusResponseViewId = this.transport.getViewId();
    }

    @Stop(priority=9)
    public void stop() {
        if (trace) {
            log.tracef("Stopping LocalTopologyManager on %s", this.transport.getAddress());
        }
        this.persistentUUIDManager.removePersistentAddressMapping(this.persistentUUID);
        this.running = false;
        this.withinThreadExecutor.shutdown();
    }

    /*
     * Exception decompiling
     */
    @Override
    public CacheTopology join(String cacheName, CacheJoinInfo joinInfo, CacheTopologyHandler stm, PartitionHandlingManager phm) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void leave(String cacheName) {
        log.debugf("Node %s leaving cache %s", this.transport.getAddress(), cacheName);
        LocalCacheStatus cacheStatus = this.runningCaches.remove(cacheName);
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.LEAVE, this.transport.getAddress(), this.transport.getViewId());
        try {
            this.executeOnCoordinator(command, cacheStatus.getJoinInfo().getTimeout());
        }
        catch (Exception e) {
            log.debugf(e, "Error sending the leave request for cache %s to coordinator", cacheName);
        }
    }

    @Override
    public void confirmRebalancePhase(String cacheName, int topologyId, int rebalanceId, Throwable throwable) {
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.REBALANCE_PHASE_CONFIRM, this.transport.getAddress(), topologyId, rebalanceId, throwable, this.transport.getViewId());
        try {
            this.executeOnCoordinatorAsync(command);
        }
        catch (Exception e) {
            log.debugf(e, "Error sending the rebalance completed notification for cache %s to the coordinator", cacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagerStatusResponse handleStatusRequest(int viewId) {
        try {
            this.waitForView(viewId, this.getGlobalTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new ManagerStatusResponse(Collections.emptyMap(), true);
        }
        HashMap<String, CacheStatusResponse> caches = new HashMap<String, CacheStatusResponse>();
        Map<String, LocalCacheStatus> map = this.runningCaches;
        synchronized (map) {
            this.latestStatusResponseViewId = viewId;
            for (Map.Entry<String, LocalCacheStatus> e : this.runningCaches.entrySet()) {
                String cacheName = e.getKey();
                LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
                caches.put(e.getKey(), new CacheStatusResponse(cacheStatus.getJoinInfo(), cacheStatus.getCurrentTopology(), cacheStatus.getStableTopology(), cacheStatus.getPartitionHandlingManager().getAvailabilityMode()));
            }
        }
        boolean rebalancingEnabled = true;
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(null, CacheTopologyControlCommand.Type.POLICY_GET_STATUS, this.transport.getAddress(), this.transport.getViewId());
        try {
            this.gcr.wireDependencies(command);
            SuccessfulResponse response = (SuccessfulResponse)command.invoke();
            rebalancingEnabled = (Boolean)response.getResponseValue();
        }
        catch (Throwable t) {
            log.warn("Failed to obtain the rebalancing status", t);
        }
        log.debugf("Sending cluster status response for view %d", viewId);
        return new ManagerStatusResponse(caches, rebalancingEnabled);
    }

    @Override
    public void handleTopologyUpdate(String cacheName, CacheTopology cacheTopology, AvailabilityMode availabilityMode, int viewId, Address sender) throws InterruptedException {
        if (this.ignoreTopologyUpdate(cacheName, cacheTopology)) {
            return;
        }
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        cacheStatus.getTopologyUpdatesExecutor().execute(() -> {
            try {
                this.doHandleTopologyUpdate(cacheName, cacheTopology, availabilityMode, viewId, sender, cacheStatus);
            }
            catch (Throwable t) {
                log.topologyUpdateError(cacheName, t);
            }
        });
    }

    private boolean ignoreTopologyUpdate(String cacheName, CacheTopology cacheTopology) {
        if (!this.running) {
            log.tracef("Ignoring consistent hash update %s for cache %s, the local cache manager is not running", cacheTopology.getTopologyId(), cacheName);
            return true;
        }
        if (this.runningCaches.get(cacheName) == null) {
            log.tracef("Ignoring consistent hash update %s for cache %s that doesn't exist locally", cacheTopology.getTopologyId(), cacheName);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doHandleTopologyUpdate(String cacheName, CacheTopology cacheTopology, AvailabilityMode availabilityMode, int viewId, Address sender, LocalCacheStatus cacheStatus) {
        try {
            this.waitForView(viewId, cacheStatus.getJoinInfo().getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
        LocalCacheStatus localCacheStatus = cacheStatus;
        synchronized (localCacheStatus) {
            boolean startConflictResolution;
            boolean updateAvailabilityModeFirst;
            if (cacheTopology == null) {
                return true;
            }
            this.registerPersistentUUID(cacheTopology);
            CacheTopology existingTopology = cacheStatus.getCurrentTopology();
            if (existingTopology != null && cacheTopology.getTopologyId() <= existingTopology.getTopologyId()) {
                log.debugf("Ignoring late consistent hash update for cache %s, current topology is %s: %s", cacheName, existingTopology.getTopologyId(), cacheTopology);
                return false;
            }
            CacheTopologyHandler handler = cacheStatus.getHandler();
            this.resetLocalTopologyBeforeRebalance(cacheName, cacheTopology, existingTopology, handler);
            if (!this.updateCacheTopology(cacheName, cacheTopology, viewId, sender, cacheStatus)) {
                return false;
            }
            ConsistentHash currentCH = cacheTopology.getCurrentCH();
            ConsistentHash pendingCH = cacheTopology.getPendingCH();
            ConsistentHash unionCH = null;
            if (pendingCH != null) {
                ConsistentHashFactory chf = cacheStatus.getJoinInfo().getConsistentHashFactory();
                switch (cacheTopology.getPhase()) {
                    case READ_NEW_WRITE_ALL: {
                        unionCH = chf.union(pendingCH, currentCH);
                        break;
                    }
                    default: {
                        unionCH = chf.union(currentCH, pendingCH);
                    }
                }
            }
            CacheTopology unionTopology = new CacheTopology(cacheTopology.getTopologyId(), cacheTopology.getRebalanceId(), currentCH, pendingCH, unionCH, cacheTopology.getPhase(), cacheTopology.getActualMembers(), this.persistentUUIDManager.mapAddresses(cacheTopology.getActualMembers()));
            unionTopology.logRoutingTableInformation();
            boolean bl = updateAvailabilityModeFirst = availabilityMode != AvailabilityMode.AVAILABLE;
            if (updateAvailabilityModeFirst && availabilityMode != null) {
                cacheStatus.getPartitionHandlingManager().setAvailabilityMode(availabilityMode);
            }
            boolean bl2 = startConflictResolution = cacheTopology.getPhase() == CacheTopology.Phase.CONFLICT_RESOLUTION;
            if (!(startConflictResolution || existingTopology != null && existingTopology.getRebalanceId() == cacheTopology.getRebalanceId() || unionCH == null)) {
                log.tracef("This topology update has a pending CH, starting the rebalance now", new Object[0]);
                handler.rebalance(unionTopology);
            } else {
                handler.updateConsistentHash(unionTopology);
            }
            if (!updateAvailabilityModeFirst && !startConflictResolution) {
                cacheStatus.getPartitionHandlingManager().setAvailabilityMode(availabilityMode);
            }
            return true;
        }
    }

    private void registerPersistentUUID(CacheTopology cacheTopology) {
        int count = cacheTopology.getActualMembers().size();
        for (int i = 0; i < count; ++i) {
            this.persistentUUIDManager.addPersistentAddressMapping(cacheTopology.getActualMembers().get(i), cacheTopology.getMembersPersistentUUIDs().get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateCacheTopology(String cacheName, CacheTopology cacheTopology, int viewId, Address sender, LocalCacheStatus cacheStatus) {
        Map<String, LocalCacheStatus> map = this.runningCaches;
        synchronized (map) {
            if (!this.validateCommandViewId(cacheTopology, viewId, sender, cacheName)) {
                return false;
            }
            log.debugf("Updating local topology for cache %s: %s", cacheName, cacheTopology);
            cacheStatus.setCurrentTopology(cacheTopology);
            return true;
        }
    }

    @GuardedBy(value="runningCaches")
    private boolean validateCommandViewId(CacheTopology cacheTopology, int viewId, Address sender, String cacheName) {
        if (!sender.equals(this.transport.getCoordinator())) {
            log.debugf("Ignoring topology %d for cache %s from old coordinator %s", cacheTopology.getTopologyId(), cacheName, sender);
            return false;
        }
        if (viewId < this.latestStatusResponseViewId) {
            log.debugf("Ignoring topology %d for cache %s from view %d received after status request from view %d", new Object[]{cacheTopology.getTopologyId(), cacheName, viewId, this.latestStatusResponseViewId});
            return false;
        }
        return true;
    }

    private void resetLocalTopologyBeforeRebalance(String cacheName, CacheTopology newCacheTopology, CacheTopology oldCacheTopology, CacheTopologyHandler handler) {
        boolean newRebalance;
        boolean bl = newRebalance = newCacheTopology.getPhase() != CacheTopology.Phase.NO_REBALANCE && newCacheTopology.getPhase() != CacheTopology.Phase.CONFLICT_RESOLUTION;
        if (newRebalance) {
            if (oldCacheTopology == null) {
                return;
            }
            if (newCacheTopology.getTopologyId() == oldCacheTopology.getTopologyId() + 1) {
                return;
            }
            if (newCacheTopology.getRebalanceId() != oldCacheTopology.getRebalanceId()) {
                this.registerPersistentUUID(newCacheTopology);
                CacheTopology resetTopology = new CacheTopology(newCacheTopology.getTopologyId() - 1, newCacheTopology.getRebalanceId() - 1, newCacheTopology.getCurrentCH(), null, CacheTopology.Phase.NO_REBALANCE, newCacheTopology.getActualMembers(), this.persistentUUIDManager.mapAddresses(newCacheTopology.getActualMembers()));
                log.debugf("Installing fake cache topology %s for cache %s", resetTopology, cacheName);
                handler.updateConsistentHash(resetTopology);
            }
        }
    }

    @Override
    public void handleStableTopologyUpdate(String cacheName, CacheTopology newStableTopology, Address sender, int viewId) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        if (cacheStatus != null) {
            cacheStatus.getTopologyUpdatesExecutor().execute(() -> this.doHandleStableTopologyUpdate(cacheName, newStableTopology, viewId, sender, cacheStatus));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleStableTopologyUpdate(String cacheName, CacheTopology newStableTopology, int viewId, Address sender, LocalCacheStatus cacheStatus) {
        Map<String, LocalCacheStatus> map = this.runningCaches;
        synchronized (map) {
            if (!this.validateCommandViewId(newStableTopology, viewId, sender, cacheName)) {
                return;
            }
            CacheTopology stableTopology = cacheStatus.getStableTopology();
            if (stableTopology == null || stableTopology.getTopologyId() < newStableTopology.getTopologyId()) {
                log.tracef("Updating stable topology for cache %s: %s", cacheName, newStableTopology);
                cacheStatus.setStableTopology(newStableTopology);
            }
        }
    }

    @Override
    public void handleRebalance(String cacheName, CacheTopology cacheTopology, int viewId, Address sender) throws InterruptedException {
        if (!this.running) {
            log.debugf("Ignoring rebalance request %s for cache %s, the local cache manager is not running", cacheTopology.getTopologyId(), cacheName);
            return;
        }
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        if (cacheStatus == null) {
            log.tracef("Ignoring rebalance %s for cache %s that doesn't exist locally", cacheTopology.getTopologyId(), cacheName);
            return;
        }
        cacheStatus.getTopologyUpdatesExecutor().execute(() -> {
            try {
                this.doHandleRebalance(viewId, cacheStatus, cacheTopology, cacheName, sender);
            }
            catch (Throwable t) {
                log.rebalanceStartError(cacheName, t);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleRebalance(int viewId, LocalCacheStatus cacheStatus, CacheTopology cacheTopology, String cacheName, Address sender) {
        try {
            this.waitForView(viewId, cacheStatus.getJoinInfo().getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return;
        }
        LocalCacheStatus localCacheStatus = cacheStatus;
        synchronized (localCacheStatus) {
            CacheTopology existingTopology = cacheStatus.getCurrentTopology();
            if (existingTopology != null && cacheTopology.getTopologyId() <= existingTopology.getTopologyId()) {
                log.debugf("Ignoring old rebalance for cache %s, current topology is %s: %s", cacheName, existingTopology.getTopologyId(), cacheTopology);
                return;
            }
            if (!this.updateCacheTopology(cacheName, cacheTopology, viewId, sender, cacheStatus)) {
                return;
            }
            log.debugf("Starting local rebalance for cache %s, topology = %s", cacheName, cacheTopology);
            cacheTopology.logRoutingTableInformation();
            CacheTopologyHandler handler = cacheStatus.getHandler();
            this.resetLocalTopologyBeforeRebalance(cacheName, cacheTopology, existingTopology, handler);
            ConsistentHash unionCH = cacheStatus.getJoinInfo().getConsistentHashFactory().union(cacheTopology.getCurrentCH(), cacheTopology.getPendingCH());
            CacheTopology newTopology = new CacheTopology(cacheTopology.getTopologyId(), cacheTopology.getRebalanceId(), cacheTopology.getCurrentCH(), cacheTopology.getPendingCH(), unionCH, cacheTopology.getPhase(), cacheTopology.getActualMembers(), cacheTopology.getMembersPersistentUUIDs());
            handler.rebalance(newTopology);
        }
    }

    @Override
    public CacheTopology getCacheTopology(String cacheName) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        return cacheStatus != null ? cacheStatus.getCurrentTopology() : null;
    }

    @Override
    public CacheTopology getStableCacheTopology(String cacheName) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        return cacheStatus != null ? cacheStatus.getStableTopology() : null;
    }

    @Override
    public boolean isTotalOrderCache(String cacheName) {
        if (!this.running) {
            log.tracef("isTotalOrderCache(%s) returning false because the local cache manager is not running", cacheName);
            return false;
        }
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        if (cacheStatus == null) {
            log.tracef("isTotalOrderCache(%s) returning false because the cache doesn't exist locally", cacheName);
            return false;
        }
        boolean totalOrder = cacheStatus.getJoinInfo().isTotalOrder();
        log.tracef("isTotalOrderCache(%s) returning %s", cacheName, totalOrder);
        return totalOrder;
    }

    private void waitForView(int viewId, long timeout, TimeUnit timeUnit) throws InterruptedException {
        try {
            this.transport.withView(viewId).get(timeout, timeUnit);
        }
        catch (ExecutionException e) {
            throw new CacheException(e.getCause());
        }
        catch (TimeoutException e) {
            throw log.timeoutWaitingForView(viewId, this.transport.getViewId());
        }
    }

    @Override
    @ManagedAttribute(description="Rebalancing enabled", displayName="Rebalancing enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isRebalancingEnabled() throws Exception {
        return this.isCacheRebalancingEnabled(null);
    }

    @Override
    public void setRebalancingEnabled(boolean enabled) throws Exception {
        this.setCacheRebalancingEnabled(null, enabled);
    }

    @Override
    public boolean isCacheRebalancingEnabled(String cacheName) throws Exception {
        int viewId = this.transport.getViewId();
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.POLICY_GET_STATUS, this.transport.getAddress(), viewId);
        return (Boolean)this.executeOnCoordinatorRetry(command, viewId);
    }

    public <T> T executeOnCoordinatorRetry(ReplicableCommand command, int viewId) throws Exception {
        boolean retried = false;
        long endNanos = this.timeService.expectedEndTime(this.getGlobalTimeout(), TimeUnit.MILLISECONDS);
        while (true) {
            try {
                long remainingMillis = this.timeService.remainingTime(endNanos, TimeUnit.MILLISECONDS);
                return (T)this.executeOnCoordinator(command, remainingMillis);
            }
            catch (SuspectException e) {
                if (trace) {
                    log.tracef("Coordinator left the cluster while querying rebalancing status, retrying", new Object[0]);
                }
                if (retried) {
                    viewId = Math.max(viewId + 1, this.transport.getViewId());
                    long remainingNanos = this.timeService.remainingTime(endNanos, TimeUnit.NANOSECONDS);
                    this.waitForView(viewId, remainingNanos, TimeUnit.NANOSECONDS);
                    retried = false;
                    continue;
                }
                retried = true;
                continue;
            }
            break;
        }
    }

    @Override
    public void setCacheRebalancingEnabled(String cacheName, boolean enabled) throws Exception {
        CacheTopologyControlCommand.Type type = enabled ? CacheTopologyControlCommand.Type.POLICY_ENABLE : CacheTopologyControlCommand.Type.POLICY_DISABLE;
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, type, this.transport.getAddress(), this.transport.getViewId());
        this.executeOnClusterSync(command, this.getGlobalTimeout(), false, false);
    }

    @Override
    public RebalancingStatus getRebalancingStatus(String cacheName) throws Exception {
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, CacheTopologyControlCommand.Type.REBALANCING_GET_STATUS, this.transport.getAddress(), this.transport.getViewId());
        int viewId = this.transport.getViewId();
        return (RebalancingStatus)((Object)this.executeOnCoordinatorRetry(command, viewId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(description="Cluster availability", displayName="Cluster availability", dataType=DataType.TRAIT, writable=false)
    public String getClusterAvailability() {
        AvailabilityMode clusterAvailability = AvailabilityMode.AVAILABLE;
        Map<String, LocalCacheStatus> map = this.runningCaches;
        synchronized (map) {
            for (LocalCacheStatus cacheStatus : this.runningCaches.values()) {
                AvailabilityMode availabilityMode = cacheStatus.getPartitionHandlingManager().getAvailabilityMode();
                clusterAvailability = clusterAvailability.min(availabilityMode);
            }
        }
        return clusterAvailability.toString();
    }

    @Override
    public AvailabilityMode getCacheAvailability(String cacheName) {
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        return cacheStatus.getPartitionHandlingManager().getAvailabilityMode();
    }

    @Override
    public void setCacheAvailability(String cacheName, AvailabilityMode availabilityMode) throws Exception {
        CacheTopologyControlCommand.Type type = CacheTopologyControlCommand.Type.AVAILABILITY_MODE_CHANGE;
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(cacheName, type, this.transport.getAddress(), availabilityMode, this.transport.getViewId());
        this.executeOnCoordinator(command, this.getGlobalTimeout());
    }

    @Override
    public void cacheShutdown(String name) throws Exception {
        CacheTopologyControlCommand command = new CacheTopologyControlCommand(name, CacheTopologyControlCommand.Type.SHUTDOWN_REQUEST, this.transport.getAddress(), this.transport.getViewId());
        this.executeOnCoordinator(command, this.getGlobalTimeout());
    }

    @Override
    public void handleCacheShutdown(String cacheName) {
        ComponentRegistry cr = this.gcr.getNamedComponentRegistry(cacheName);
        PassivationManager passivationManager = cr.getComponent(PassivationManager.class);
        if (passivationManager != null) {
            passivationManager.passivateAll();
        }
        ScopedPersistentStateImpl cacheState = new ScopedPersistentStateImpl(cacheName);
        cacheState.setProperty("@version", Version.getVersion());
        cacheState.setProperty("@timestamp", this.timeService.instant().toString());
        cacheState.setProperty("version-major", Version.getMajor());
        LocalCacheStatus cacheStatus = this.runningCaches.get(cacheName);
        cacheStatus.getCurrentTopology().getCurrentCH().remapAddresses(this.persistentUUIDManager.addressToPersistentUUID()).toScopedState(cacheState);
        this.globalStateManager.writeScopedState(cacheState);
    }

    private Object executeOnCoordinator(ReplicableCommand command, long timeout) throws Exception {
        Response response;
        if (this.transport.isCoordinator()) {
            try {
                if (trace) {
                    log.tracef("Attempting to execute command on self: %s", command);
                }
                this.gcr.wireDependencies(command);
                response = (Response)command.invoke();
            }
            catch (Throwable t) {
                throw new CacheException("Error handling join request", t);
            }
        } else {
            Address coordinator = this.transport.getCoordinator();
            Map<Address, Response> responseMap = this.transport.invokeRemotely(Collections.singleton(coordinator), command, ResponseMode.SYNCHRONOUS, timeout, null, DeliverOrder.NONE, false);
            response = responseMap.get(coordinator);
        }
        if (response == null || !response.isSuccessful()) {
            Exception exception = response instanceof ExceptionResponse ? ((ExceptionResponse)response).getException() : null;
            throw new CacheException("Bad response received from coordinator: " + response, (Throwable)exception);
        }
        return ((SuccessfulResponse)response).getResponseValue();
    }

    private void executeOnCoordinatorAsync(ReplicableCommand command) throws Exception {
        if (this.transport.isCoordinator()) {
            this.asyncTransportExecutor.execute(() -> {
                if (trace) {
                    log.tracef("Attempting to execute command on self: %s", command);
                }
                this.gcr.wireDependencies(command);
                try {
                    command.invoke();
                }
                catch (Throwable t) {
                    log.errorf(t, "Failed to execute ReplicableCommand %s on coordinator async: %s", command, t.getMessage());
                }
            });
        } else {
            Address coordinator = this.transport.getCoordinator();
            this.transport.invokeRemotely(Collections.singleton(coordinator), command, ResponseMode.ASYNCHRONOUS, 0L, null, DeliverOrder.NONE, false);
        }
    }

    private Map<Address, Object> executeOnClusterSync(ReplicableCommand command, int timeout, boolean totalOrder, boolean distributed) throws Exception {
        Response localResponse;
        if (totalOrder) {
            Map<Address, Response> responseMap = this.transport.invokeRemotely(null, command, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, timeout, null, DeliverOrder.TOTAL, distributed);
            return this.parseResponses(responseMap);
        }
        CompletableFuture<Map<Address, Response>> remoteFuture = this.transport.invokeRemotelyAsync(null, command, ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, timeout, null, DeliverOrder.NONE, false);
        this.gcr.wireDependencies(command);
        try {
            if (trace) {
                log.tracef("Attempting to execute command on self: %s", command);
            }
            localResponse = (Response)command.invoke();
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
        if (!localResponse.isSuccessful()) {
            throw new CacheException("Unsuccessful local response");
        }
        Map responseMap = (Map)remoteFuture.get(timeout, TimeUnit.MILLISECONDS);
        Map<Address, Object> responseValues = this.parseResponses(responseMap);
        responseValues.put(this.transport.getAddress(), ((SuccessfulResponse)localResponse).getResponseValue());
        return responseValues;
    }

    private Map<Address, Object> parseResponses(Map<Address, Response> responseMap) {
        HashMap<Address, Object> responseValues = new HashMap<Address, Object>(this.transport.getMembers().size());
        for (Map.Entry<Address, Response> entry : responseMap.entrySet()) {
            Address address = entry.getKey();
            Response response = entry.getValue();
            if (!response.isSuccessful()) {
                Exception cause = response instanceof ExceptionResponse ? ((ExceptionResponse)response).getException() : null;
                throw new CacheException("Unsuccessful response received from node " + address + ": " + response, (Throwable)cause);
            }
            responseValues.put(address, ((SuccessfulResponse)response).getResponseValue());
        }
        return responseValues;
    }

    private int getGlobalTimeout() {
        return (int)this.gcr.getGlobalConfiguration().transport().distributedSyncTimeout();
    }

    @Override
    public void prepareForPersist(ScopedPersistentState state) {
        state.setProperty("uuid", this.persistentUUID.toString());
    }

    @Override
    public void prepareForRestore(ScopedPersistentState state) {
        if (!state.containsProperty("uuid")) {
            throw log.invalidPersistentState("___global");
        }
        this.persistentUUID = PersistentUUID.fromString(state.getProperty("uuid"));
    }

    @Override
    public PersistentUUID getPersistentUUID() {
        return this.persistentUUID;
    }

    private static /* synthetic */ CompletableFuture lambda$join$0(CompletableFuture joinFuture) {
        return joinFuture;
    }
}

