/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ModuleServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ChannelClusterServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.ForkChannelFactoryServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.naming.BinderServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.service.IdentityServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.spi.CapabilityServiceNameRegistry;
import org.wildfly.clustering.spi.DistributedGroupServiceConfiguratorProvider;
import org.wildfly.clustering.spi.GroupServiceConfiguratorProvider;
import org.wildfly.clustering.spi.ServiceNameRegistry;

public class ChannelServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        String stack = ChannelResourceDefinition.Attribute.STACK.resolveModelAttribute((ExpressionResolver)context, model).asString();
        ServiceTarget target = context.getServiceTarget();
        new ChannelClusterServiceConfigurator(address).configure(context, model).build(target).install();
        new ChannelServiceConfigurator((Capability)ChannelResourceDefinition.Capability.JCHANNEL, address).statisticsEnabled(ChannelResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean()).configure(context, model).build(target).install();
        new IdentityServiceConfigurator(ChannelResourceDefinition.Capability.JCHANNEL_FACTORY.getServiceName(address), JGroupsRequirement.CHANNEL_FACTORY.getServiceName(context, stack)).build(target).install();
        new ForkChannelFactoryServiceConfigurator((Capability)ChannelResourceDefinition.Capability.FORK_CHANNEL_FACTORY, address.append(new PathElement[]{ForkResourceDefinition.pathElement(name)})).configure(context, new ModelNode()).build(target).install();
        new ModuleServiceConfigurator(ChannelResourceDefinition.Capability.JCHANNEL_MODULE.getServiceName(address), (Attribute)ChannelResourceDefinition.Attribute.MODULE).configure(context, model).build(target).setInitialMode(ServiceController.Mode.PASSIVE).install();
        new BinderServiceConfigurator(JGroupsBindingFactory.createChannelBinding(name), JGroupsRequirement.CHANNEL.getServiceName(context, name)).build(target).install();
        new BinderServiceConfigurator(JGroupsBindingFactory.createChannelFactoryBinding(name), JGroupsRequirement.CHANNEL_FACTORY.getServiceName(context, name)).build(target).install();
        CapabilityServiceNameRegistry registry = new CapabilityServiceNameRegistry(ChannelResourceDefinition.CLUSTERING_CAPABILITIES, address);
        for (GroupServiceConfiguratorProvider groupServiceConfiguratorProvider : ServiceLoader.load(DistributedGroupServiceConfiguratorProvider.class, DistributedGroupServiceConfiguratorProvider.class.getClassLoader())) {
            for (CapabilityServiceConfigurator configurator : groupServiceConfiguratorProvider.getServiceConfigurators((ServiceNameRegistry)registry, name)) {
                JGroupsLogger.ROOT_LOGGER.debugf("Installing %s for channel %s", configurator.getServiceName(), name);
                configurator.configure(context).build(target).install();
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        for (ChannelResourceDefinition.Capability capability : EnumSet.allOf(ChannelResourceDefinition.Capability.class)) {
            context.removeService(capability.getServiceName(address));
        }
        context.removeService(JGroupsBindingFactory.createChannelBinding(name).getBinderServiceName());
        context.removeService(JGroupsBindingFactory.createChannelFactoryBinding(name).getBinderServiceName());
        CapabilityServiceNameRegistry registry = new CapabilityServiceNameRegistry(ChannelResourceDefinition.CLUSTERING_CAPABILITIES, address);
        for (GroupServiceConfiguratorProvider groupServiceConfiguratorProvider : ServiceLoader.load(DistributedGroupServiceConfiguratorProvider.class, DistributedGroupServiceConfiguratorProvider.class.getClassLoader())) {
            for (ServiceNameProvider configurator : groupServiceConfiguratorProvider.getServiceConfigurators((ServiceNameRegistry)registry, name)) {
                JGroupsLogger.ROOT_LOGGER.debugf("Removing %s for channel %s", configurator.getServiceName(), name);
                context.removeService(configurator.getServiceName());
            }
        }
    }
}

