/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.persistence.Store;
import org.infinispan.filter.KeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.KeyValuePair;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodStoreConfiguration;
import org.wildfly.clustering.infinispan.spi.RemoteCacheContainer;

@Store(shared=true)
public class HotRodStore<K, V>
implements AdvancedLoadWriteStore<K, V> {
    private InitializationContext ctx;
    private RemoteCache<byte[], byte[]> remoteCache;

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        HotRodStoreConfiguration configuration = (HotRodStoreConfiguration)ctx.getConfiguration();
        RemoteCacheContainer remoteCacheContainer = (RemoteCacheContainer)configuration.attributes().attribute(HotRodStoreConfiguration.REMOTE_CACHE_CONTAINER).get();
        String cacheConfiguration = (String)configuration.attributes().attribute(HotRodStoreConfiguration.CACHE_CONFIGURATION).get();
        String cacheName = ctx.getCache().getName();
        try {
            ProtocolVersion protocolVersion = remoteCacheContainer.getConfiguration().version();
            if (EnumSet.of(ProtocolVersion.PROTOCOL_VERSION_26, new ProtocolVersion[]{ProtocolVersion.PROTOCOL_VERSION_25, ProtocolVersion.PROTOCOL_VERSION_24, ProtocolVersion.PROTOCOL_VERSION_23, ProtocolVersion.PROTOCOL_VERSION_22, ProtocolVersion.PROTOCOL_VERSION_21, ProtocolVersion.PROTOCOL_VERSION_20, ProtocolVersion.PROTOCOL_VERSION_13, ProtocolVersion.PROTOCOL_VERSION_12, ProtocolVersion.PROTOCOL_VERSION_11, ProtocolVersion.PROTOCOL_VERSION_10}).contains(protocolVersion)) {
                InfinispanLogger.ROOT_LOGGER.remoteCacheMustBeDefined(protocolVersion.toString(), cacheName);
                this.remoteCache = remoteCacheContainer.getCache(cacheName, false);
            } else {
                InfinispanLogger.ROOT_LOGGER.remoteCacheCreated(cacheName, cacheConfiguration);
                this.remoteCache = remoteCacheContainer.administration().getOrCreateCache(cacheName, cacheConfiguration);
            }
        }
        catch (HotRodClientException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public MarshalledEntry<K, V> load(Object key) throws PersistenceException {
        byte[] bytes = (byte[])this.remoteCache.get((Object)this.marshall(key));
        if (bytes == null) {
            return null;
        }
        KeyValuePair keyValuePair = (KeyValuePair)this.unmarshall(bytes);
        return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, (ByteBuffer)keyValuePair.getKey(), (ByteBuffer)keyValuePair.getValue());
    }

    public void write(MarshalledEntry<? extends K, ? extends V> entry) {
        this.remoteCache.put((Object)this.marshall(entry.getKey()), (Object)this.marshall(entry));
    }

    public void writeBatch(Iterable<MarshalledEntry<? extends K, ? extends V>> marshalledEntries) {
        HashMap<byte[], byte[]> batch = new HashMap<byte[], byte[]>();
        for (MarshalledEntry<K, V> marshalledEntry : marshalledEntries) {
            batch.put(this.marshall(marshalledEntry.getKey()), this.marshall(marshalledEntry));
        }
        if (!batch.isEmpty()) {
            this.remoteCache.putAll(batch);
        }
    }

    public boolean contains(Object key) {
        return this.remoteCache.containsKey((Object)this.marshall(key));
    }

    public boolean delete(Object key) {
        return this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)this.marshall(key)) != null;
    }

    public void process(KeyFilter<? super K> filter, AdvancedCacheLoader.CacheLoaderTask<K, V> task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        TaskContextImpl taskContext = new TaskContextImpl();
        for (byte[] key : this.remoteCache.keySet()) {
            if (taskContext.isStopped()) break;
            Object typedKey = this.unmarshall(key);
            if (filter != null && !filter.accept(typedKey)) continue;
            try {
                MarshalledEntry<K, V> marshalledEntry = this.load(key);
                if (marshalledEntry == null) continue;
                task.processEntry(marshalledEntry, (AdvancedCacheLoader.TaskContext)taskContext);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public int size() {
        return this.remoteCache.size();
    }

    public void clear() {
        this.remoteCache.clear();
    }

    public void purge(Executor threadPool, AdvancedCacheWriter.PurgeListener<? super K> listener) {
    }

    private byte[] marshall(Object key) throws PersistenceException {
        try {
            return key instanceof WrappedByteArray ? ((WrappedByteArray)key).getBytes() : this.ctx.getMarshaller().objectToByteBuffer(key);
        }
        catch (IOException | InterruptedException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private byte[] marshall(MarshalledEntry<?, ?> entry) {
        return this.marshall(new KeyValuePair((Object)entry.getValueBytes(), (Object)entry.getMetadataBytes()));
    }

    private Object unmarshall(byte[] bytes) throws PersistenceException {
        try {
            return this.ctx.getMarshaller().objectFromByteBuffer(bytes);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

