/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.ReadlineFlag;
import org.aesh.readline.action.ActionDecoder;
import org.aesh.readline.alias.AliasCompletion;
import org.aesh.readline.alias.AliasManager;
import org.aesh.readline.alias.AliasPreProcessor;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.completion.CompletionHandler;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.history.FileHistory;
import org.aesh.readline.history.History;
import org.aesh.readline.history.InMemoryHistory;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.terminal.TerminalBuilder;
import org.aesh.readline.terminal.impl.WinSysTerminal;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.readline.util.FileAccessPermission;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Terminal;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.Util;
import org.jboss.logging.Logger;

public class ReadlineConsole {
    private static final Logger LOG = Logger.getLogger((String)ReadlineConsole.class.getName());
    private static final boolean isTraceEnabled = LOG.isTraceEnabled();
    private final List<Completion> completions = new ArrayList<Completion>();
    private Readline readline;
    private CLITerminalConnection connection;
    private final CommandHistory history = new HistoryImpl();
    private final FileHistory readlineHistory;
    private Prompt prompt;
    private final Settings settings;
    private volatile boolean started;
    private volatile boolean closed;
    private Thread startThread;
    private Thread readingThread;
    private Consumer<String> callback;
    private final ExecutorService executor = Executors.newFixedThreadPool(1, r -> new Thread(r, "CLI command"));
    private StringBuilder outputCollector;
    private final AliasManager aliasManager;
    private final List<Function<String, Optional<String>>> preProcessors = new ArrayList<Function<String, Optional<String>>>();
    private static final EnumMap<ReadlineFlag, Integer> READLINE_FLAGS = new EnumMap(ReadlineFlag.class);
    private Consumer<Signal> interruptHandler;
    private boolean isSystemTerminal;
    private boolean forcePaging;
    private History searchHistory = new InMemoryHistory();
    private Paging paging;

    ReadlineConsole(Settings settings) throws IOException {
        this.settings = settings;
        this.readlineHistory = new FileHistory(settings.getHistoryFile(), settings.getHistorySize(), settings.getPermission(), false);
        if (settings.isDisableHistory()) {
            this.readlineHistory.disable();
        } else {
            this.readlineHistory.enable();
        }
        if (isTraceEnabled) {
            LOG.tracef("History is enabled? %s", (Object)(!settings.isDisableHistory() ? 1 : 0));
        }
        this.aliasManager = new AliasManager(new File(Config.getHomeDir() + Config.getPathSeparator() + ".aesh_aliases"), true);
        AliasPreProcessor aliasPreProcessor = new AliasPreProcessor(this.aliasManager);
        this.preProcessors.add((Function<String, Optional<String>>)aliasPreProcessor);
        this.completions.add((Completion)new AliasCompletion(this.aliasManager));
        this.readline = new Readline();
    }

    private void initializeConnection() throws IOException {
        if (this.connection == null) {
            this.connection = this.newConnection();
            this.connection.setSizeHandler(new Consumer<Size>(){

                @Override
                public void accept(Size t) {
                    if (ReadlineConsole.this.paging != null) {
                        ReadlineConsole.this.paging.redraw(ReadlineConsole.this.connection.getTerminal().getSize());
                    }
                }
            });
            this.interruptHandler = signal -> {
                if (signal == Signal.INT) {
                    LOG.trace((Object)"Calling InterruptHandler");
                    this.connection.write(Config.getLineSeparator());
                    this.connection.close();
                }
            };
            this.connection.setSignalHandler(this.interruptHandler);
            Attributes attr = this.connection.getAttributes();
            attr.setLocalFlag(Attributes.LocalFlag.ECHOCTL, false);
            this.connection.setAttributes(attr);
            this.connection.enterRawMode();
        }
    }

    public void setActionCallback(Consumer<String> callback) {
        this.callback = callback;
    }

    private CLITerminalConnection newConnection() throws IOException {
        LOG.trace((Object)"Creating terminal connection");
        Terminal terminal = TerminalBuilder.builder().input(this.settings.getInStream() == null ? System.in : this.settings.getInStream()).output(this.settings.getOutStream()).nativeSignals(true).name("CLI Terminal").system(!this.settings.isOutputRedefined()).build();
        if (isTraceEnabled) {
            LOG.tracef("New Terminal %s", terminal.getClass());
        }
        CLITerminalConnection c = new CLITerminalConnection(terminal);
        this.isSystemTerminal = c.supportsAnsi();
        return c;
    }

    public void setCompletionHandler(CompletionHandler<? extends CompleteOperation> ch) {
        this.readline = new Readline(EditModeBuilder.builder().create(), null, ch);
    }

    private Readline getReadLine() {
        if (this.readline == null) {
            this.readline = new Readline();
        }
        return this.readline;
    }

    public void addCompleter(Completion<? extends CompleteOperation> completer) {
        this.completions.add(completer);
    }

    public CommandHistory getHistory() {
        return this.history;
    }

    public void clearScreen() {
        if (this.connection != null) {
            this.connection.stdoutHandler().accept(ANSI.CLEAR_SCREEN);
        }
    }

    public String formatColumns(Collection<String> list) {
        String[] newList = new String[list.size()];
        list.toArray(newList);
        return Parser.formatDisplayList((String[])newList, (int)this.getHeight(), (int)this.getWidth());
    }

    public void print(String line, boolean collect) {
        LOG.tracef("Print %s", (Object)line);
        if (collect && this.outputCollector != null) {
            this.outputCollector.append(line);
        } else if (this.connection == null) {
            PrintStream out = this.settings.getOutStream() == null ? System.out : this.settings.getOutStream();
            try {
                ((OutputStream)out).write(line.getBytes());
            }
            catch (IOException ex) {
                LOG.tracef("Print exception %s", (Object)ex);
            }
        } else {
            this.connection.write(line);
        }
    }

    public Key readKey() throws InterruptedException, IOException {
        return Key.findStartKey((int[])this.read());
    }

    private void printCollectedOutput() {
        if (this.outputCollector == null || this.outputCollector.length() == 0) {
            return;
        }
        try {
            String line = this.outputCollector.toString();
            if (line.isEmpty()) {
                return;
            }
            this.paging = new Paging(line, this.connection.size());
            while (this.paging.inWorkflow()) {
                if (this.paging.needPrompt()) {
                    try {
                        this.connection.write(ANSI.CURSOR_SAVE);
                        this.paging.drawPrompt();
                        Key k = this.readKey();
                        this.connection.write(ANSI.CURSOR_RESTORE);
                        this.connection.stdoutHandler().accept(ANSI.ERASE_LINE_FROM_CURSOR);
                        if (k == null) {
                            this.paging.exit();
                            continue;
                        }
                        switch (k) {
                            case SPACE: 
                            case PGDOWN_2: 
                            case PGDOWN: {
                                this.paging.pageDown();
                                break;
                            }
                            case BACKSLASH: 
                            case PGUP_2: 
                            case PGUP: {
                                this.paging.pageUp();
                                break;
                            }
                            case N: {
                                this.paging.previousMatch();
                                break;
                            }
                            case n: {
                                this.paging.nextMatch();
                                break;
                            }
                            case SLASH: {
                                this.paging.search();
                                break;
                            }
                            case SEMI_COLON: 
                            case UP_2: 
                            case UP: {
                                this.paging.lineUp();
                                break;
                            }
                            case DOWN: 
                            case DOWN_2: 
                            case ENTER: 
                            case CTRL_M: {
                                this.paging.lineDown();
                                break;
                            }
                            case HOME: 
                            case HOME_2: 
                            case g: {
                                this.paging.goHome();
                                break;
                            }
                            case END: 
                            case END_2: 
                            case END_3: 
                            case G: {
                                this.paging.goEnd();
                                break;
                            }
                            case Q: 
                            case ESC: 
                            case q: {
                                this.paging.exit();
                            }
                        }
                        continue;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(ex);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                this.paging.printCurrentLine();
            }
        }
        finally {
            this.paging.pagingDone();
            this.paging = null;
            this.outputCollector = null;
        }
    }

    private void displayHightlighted(String pattern, String l) {
        int index = l.indexOf(pattern);
        while (index >= 0) {
            this.connection.write(l.substring(0, index));
            this.connection.write(ANSI.INVERT_BACKGROUND);
            this.connection.write(pattern);
            this.connection.write("\u001b[0m");
            l = l.substring(index + pattern.length());
            index = l.indexOf(pattern);
        }
        this.connection.write(l + Config.getLineSeparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] read() throws InterruptedException, IOException {
        this.initializeConnection();
        ActionDecoder decoder = new ActionDecoder();
        int[][] key = new int[][]{null};
        this.readingThread = Thread.currentThread();
        Consumer prevHandler = this.connection.getSignalHandler();
        this.connection.setSignalHandler(this.interruptHandler);
        CountDownLatch latch = new CountDownLatch(1);
        Attributes attributes = this.connection.enterRawMode();
        this.connection.setStdinHandler(keys -> {
            decoder.add(keys);
            if (decoder.hasNext()) {
                key[0] = decoder.next().buffer().array();
                this.connection.setStdinHandler(null);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        finally {
            this.connection.setSignalHandler(prevHandler);
            this.connection.setAttributes(attributes);
            this.readingThread = null;
        }
        return key[0];
    }

    public void printNewLine(boolean collect) {
        this.print(Config.getLineSeparator(), collect);
    }

    public String readLine(String prompt) throws IOException, InterruptedException {
        return this.readLine(prompt, (Character)null);
    }

    public String readLine(String prompt, Character mask) throws InterruptedException, IOException {
        this.logPromptMask(prompt, mask);
        return this.readLine(new Prompt(prompt, mask));
    }

    public String readLine(Prompt prompt) throws InterruptedException, IOException {
        return this.readLine(prompt, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(Prompt prompt, Completion completer) throws InterruptedException, IOException {
        if (this.started) {
            this.printCollectedOutput();
            this.outputCollector = this.createCollector();
        }
        this.readingThread = Thread.currentThread();
        try {
            if (!this.started) {
                String string = this.promptFromNonStartedConsole(prompt, completer);
                return string;
            }
            String string = this.promptFromStartedConsole(prompt, completer, null);
            return string;
        }
        finally {
            this.readingThread = null;
        }
    }

    private String readPattern() throws InterruptedException, IOException {
        this.readingThread = Thread.currentThread();
        try {
            String string = this.promptFromStartedConsole(new Prompt("/", (Character)null), null, this.searchHistory);
            return string;
        }
        finally {
            this.readingThread = null;
        }
    }

    private StringBuilder createCollector() {
        if (!this.isPagingOutputEnabled()) {
            return null;
        }
        return new StringBuilder();
    }

    private String promptFromNonStartedConsole(Prompt prompt, Completion completer) throws InterruptedException, IOException {
        this.initializeConnection();
        LOG.trace((Object)"Not started");
        String[] out = new String[1];
        if (this.connection.suspended()) {
            this.connection.awake();
        }
        ArrayList<Completion> lst = null;
        if (completer != null) {
            lst = new ArrayList<Completion>();
            lst.add(completer);
        }
        this.getReadLine().readline((Connection)this.connection, prompt, newLine -> {
            out[0] = newLine;
            LOG.trace((Object)"Got some input");
            this.connection.stopReading();
        }, lst, null, null, null, READLINE_FLAGS);
        this.connection.openBlockingInterruptable();
        LOG.trace((Object)"Done for prompt");
        return out[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String promptFromStartedConsole(Prompt prompt, Completion completer, History history) throws InterruptedException, IOException {
        this.initializeConnection();
        String[] out = new String[1];
        if (this.readingThread == this.startThread) {
            throw new RuntimeException("Can't prompt from the Thread that is reading terminal input");
        }
        ArrayList<Completion> lst = null;
        if (completer != null) {
            lst = new ArrayList<Completion>();
            lst.add(completer);
        }
        CountDownLatch latch = new CountDownLatch(1);
        Consumer prevHandler = this.connection.getSignalHandler();
        this.connection.setSignalHandler(this.interruptHandler);
        this.readline.readline((Connection)this.connection, prompt, newLine -> {
            out[0] = newLine;
            LOG.trace((Object)"Got some input");
            latch.countDown();
        }, lst, null, history, null, READLINE_FLAGS);
        try {
            latch.await();
        }
        finally {
            this.connection.setSignalHandler(prevHandler);
        }
        LOG.trace((Object)"Done for prompt");
        return out[0];
    }

    private void logPromptMask(String prompt, Character mask) {
        LOG.tracef("Prompt %s mask %s", (Object)prompt, (Object)mask);
    }

    public int getTerminalWidth() {
        return this.getWidth();
    }

    public int getTerminalHeight() {
        return this.getHeight();
    }

    private int getHeight() {
        if (this.connection == null) {
            return 40;
        }
        return this.connection.size().getHeight();
    }

    private int getWidth() {
        if (this.connection == null) {
            return 80;
        }
        return this.connection.size().getWidth();
    }

    public void start() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Console has already been closed");
        }
        if (!this.started) {
            this.initializeConnection();
            this.startThread = Thread.currentThread();
            this.started = true;
            this.loop();
            LOG.tracef("Started in thread %s. Waiting...", (Object)this.startThread.getName());
            try {
                this.connection.openBlockingInterruptable();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.trace((Object)"Leaving console");
        } else {
            LOG.trace((Object)"Already started");
        }
    }

    private void loop() {
        try {
            if (isTraceEnabled) {
                LOG.tracef("Set a readline callback with prompt %s", (Object)this.prompt);
            }
            if (!this.closed) {
                this.getReadLine().readline((Connection)this.connection, this.prompt, line -> {
                    LOG.tracef("Executing command %s in a new thread.", line);
                    if (line == null || line.trim().length() == 0 || this.handleAlias((String)line)) {
                        this.loop();
                        return;
                    }
                    this.executor.submit(() -> {
                        Consumer handler = this.connection.getSignalHandler();
                        Thread callingThread = Thread.currentThread();
                        this.connection.setSignalHandler(signal -> {
                            switch (signal) {
                                case INT: {
                                    LOG.tracef("Interrupting command: %s", line);
                                    callingThread.interrupt();
                                }
                            }
                        });
                        try {
                            this.outputCollector = this.createCollector();
                            this.callback.accept((String)line);
                        }
                        catch (Throwable thr) {
                            this.connection.write("Unexpected exception");
                            thr.printStackTrace();
                        }
                        finally {
                            this.printCollectedOutput();
                            Thread.interrupted();
                            this.connection.setSignalHandler(handler);
                            LOG.tracef("Done Executing command %s", line);
                            this.loop();
                        }
                    });
                }, this.completions, this.preProcessors, (History)this.readlineHistory, null, READLINE_FLAGS);
            }
        }
        catch (Exception ex) {
            this.connection.write("Unexpected exception");
            ex.printStackTrace();
        }
    }

    private boolean handleAlias(String line) {
        if (line.startsWith("alias ") || line.equals("alias")) {
            String out = this.aliasManager.parseAlias(line.trim());
            if (out != null) {
                this.print(out, false);
            }
            return true;
        }
        if (line.startsWith("unalias ") || line.equals("unalias")) {
            String out = this.aliasManager.removeAlias(line.trim());
            if (out != null) {
                this.print(out, false);
            }
            return true;
        }
        return false;
    }

    public void stop() {
        if (!this.closed) {
            LOG.trace((Object)"Stopping.");
            this.closed = true;
            if (this.readingThread != null) {
                LOG.trace((Object)"Interrupting reading thread");
                this.readingThread.interrupt();
            }
            if (this.started) {
                this.readlineHistory.stop();
                this.aliasManager.persist();
            }
            this.executor.shutdown();
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    public boolean running() {
        return this.started;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt.contains("\u001b[") ? new Prompt(Parser.stripAwayAnsiCodes((String)prompt), prompt) : new Prompt(prompt);
    }

    public void setPrompt(Prompt prompt) {
        this.prompt = prompt;
    }

    public boolean isPagingOutputEnabled() {
        if (this.forcePaging) {
            return true;
        }
        return this.isSystemTerminal;
    }

    public boolean isPagingOutputActive() {
        return this.paging != null && this.paging.paging;
    }

    public void forcePagingOutput(boolean forcePaging) {
        this.forcePaging = forcePaging;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String handleBuiltins(String line) {
        if (this.handleAlias(line)) {
            return null;
        }
        return this.parse(line);
    }

    private String parse(String line) {
        Optional out = this.aliasManager.getAliasName(line);
        if (out.isPresent()) {
            line = (String)out.get();
        }
        return line;
    }

    static {
        READLINE_FLAGS.put(ReadlineFlag.NO_PROMPT_REDRAW_ON_INTR, Integer.MAX_VALUE);
    }

    private class Paging {
        private boolean notFound;
        private boolean searchingMode;
        private int currentLine;
        private int allLines;
        private int lastScrolledLines;
        private List<String> lines;
        private final String[] splitLines;
        private int jumpIndex = -1;
        private String pattern;
        private int max;
        private boolean paging;
        private final boolean alternateSupported;

        Paging(String output, Size termSize) {
            this.splitLines = output.split("\\R", -1);
            this.lines = this.buildLines(termSize);
            this.lastScrolledLines = this.lines.size();
            this.max = termSize.getHeight() - 1;
            this.alternateSupported = Util.isWindows() ? WinSysTerminal.isVTSupported() || ReadlineConsole.this.forcePaging : true;
            if (this.lines.size() > this.max) {
                if (this.alternateSupported) {
                    ReadlineConsole.this.connection.write(ANSI.ALTERNATE_BUFFER);
                    ReadlineConsole.this.clearScreen();
                }
                this.paging = true;
            }
        }

        private List<String> buildLines(Size size) {
            ArrayList<String> lst = new ArrayList<String>();
            int width = Util.isWindows() ? size.getWidth() - 1 : size.getWidth();
            String[] stringArray = this.splitLines;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String l;
                String remaining = l = stringArray[i];
                do {
                    String st = remaining.substring(0, Math.min(remaining.length(), width));
                    lst.add(st);
                } while (!(remaining = remaining.substring(Math.min(remaining.length(), width))).isEmpty());
            }
            return lst;
        }

        int getMax() {
            return this.max;
        }

        void pagingDone() {
            if (this.paging && this.alternateSupported) {
                ReadlineConsole.this.connection.write(ANSI.MAIN_BUFFER);
                this.printScrolledLines();
            }
        }

        boolean needPrompt() {
            return this.currentLine > this.getMax() - 1 && this.jumpIndex == -1 || this.endBuffer() && this.searchingMode;
        }

        boolean inWorkflow() {
            return this.allLines < this.lines.size() || this.searchingMode;
        }

        void exit() {
            this.lastScrolledLines = this.allLines;
            this.allLines = this.lines.size();
            this.searchingMode = false;
        }

        void pageDown() {
            this.notFound = false;
            this.currentLine = 0;
            if (this.endBuffer()) {
                this.exit();
            }
        }

        void pageUp() {
            if (!this.alternateSupported) {
                return;
            }
            ReadlineConsole.this.clearScreen();
            this.notFound = false;
            this.currentLine = 0;
            this.allLines = this.allLines > 2 * this.getMax() ? (this.allLines -= 2 * this.getMax()) : 0;
        }

        void previousMatch() {
            if (!this.alternateSupported) {
                return;
            }
            if (!this.searchingMode && ReadlineConsole.this.searchHistory.size() != 0) {
                int[] p = ReadlineConsole.this.searchHistory.get(ReadlineConsole.this.searchHistory.size() - 1);
                this.pattern = Parser.fromCodePoints((int[])p);
                this.searchingMode = true;
            }
            if (this.searchingMode) {
                int previous;
                if (this.allLines <= this.getMax()) {
                    this.notFound = true;
                }
                if ((previous = this.previousMatch(this.pattern, this.lines, this.allLines - this.getMax() - 1)) >= 0) {
                    this.jumpIndex = this.allLines - previous - 1;
                    this.notFound = false;
                    this.resetScreen();
                } else {
                    this.notFound = true;
                }
            }
        }

        private int previousMatch(String pattern, List<String> lines, int currentLine) {
            int previous = 0;
            for (int i = currentLine; i >= 0; --i) {
                String l = lines.get(i);
                if (l.contains(pattern)) {
                    return previous;
                }
                ++previous;
            }
            return -1;
        }

        private void nextMatch() {
            if (!this.alternateSupported) {
                return;
            }
            if (this.searchingMode) {
                if (this.endBuffer()) {
                    this.notFound = true;
                } else {
                    int start = this.allLines - this.getMax() < 0 ? 0 : this.allLines - this.getMax();
                    int next = this.nextMatch(this.pattern, this.lines, start + 1);
                    if (next >= 0) {
                        this.jumpIndex = Math.min(this.allLines + next + 1, this.lines.size());
                        this.notFound = false;
                        this.resetScreen();
                    } else {
                        this.notFound = true;
                    }
                }
            } else if (ReadlineConsole.this.searchHistory.size() != 0) {
                int[] p = ReadlineConsole.this.searchHistory.get(ReadlineConsole.this.searchHistory.size() - 1);
                this.doSearch(Parser.fromCodePoints((int[])p));
            }
        }

        private int nextMatch(String pattern, List<String> lines, int currentLine) {
            int next = 0;
            for (int i = currentLine; i < lines.size(); ++i) {
                String l = lines.get(i);
                if (l.contains(pattern)) {
                    return next;
                }
                ++next;
            }
            return -1;
        }

        private void search() throws InterruptedException, IOException {
            if (!this.alternateSupported) {
                return;
            }
            this.doSearch(ReadlineConsole.this.readPattern());
        }

        private void doSearch(String pattern) {
            if (pattern == null || pattern.isEmpty()) {
                this.jumpIndex = this.allLines;
            } else {
                this.pattern = pattern;
                int start = this.allLines - this.getMax() < 0 ? 0 : this.allLines - this.getMax();
                int next = this.nextMatch(pattern, this.lines, start);
                if (next >= 0) {
                    this.jumpIndex = Math.min(this.allLines + next, this.lines.size());
                    this.searchingMode = true;
                    this.notFound = false;
                } else {
                    this.notFound = true;
                    int n = this.nextMatch(pattern, this.lines, 0);
                    if (n >= 0) {
                        this.searchingMode = true;
                    }
                    this.jumpIndex = this.allLines;
                }
            }
            this.resetScreen();
        }

        private void lineUp() {
            if (!this.alternateSupported) {
                return;
            }
            this.notFound = false;
            if (this.allLines > this.getMax()) {
                this.currentLine = 0;
                this.allLines -= this.getMax() + 1;
                ReadlineConsole.this.clearScreen();
            }
        }

        private void lineDown() {
            this.notFound = false;
            if (this.endBuffer()) {
                this.exit();
            }
            --this.currentLine;
        }

        private int getPercentage() {
            return this.allLines * 100 / this.lines.size();
        }

        private String nextCurrentLine() {
            String line = this.lines.get(this.allLines);
            ++this.currentLine;
            ++this.allLines;
            if (this.jumpIndex == this.allLines) {
                this.currentLine = this.getMax();
                this.jumpIndex = -1;
            }
            return line;
        }

        private boolean endBuffer() {
            return this.allLines == this.lines.size();
        }

        private void redraw(Size size) {
            if (!this.alternateSupported) {
                return;
            }
            int oldMax = this.max;
            this.max = size.getHeight() - 1;
            this.lines = this.buildLines(size);
            this.jumpIndex = this.lines.size() > this.max ? this.allLines + (this.max - oldMax) : -1;
            this.resetScreen();
            while (this.inWorkflow() && !this.needPrompt()) {
                this.printCurrentLine();
            }
            this.drawPrompt();
        }

        private void printCurrentLine() {
            String l = this.nextCurrentLine();
            if (this.searchingMode) {
                ReadlineConsole.this.displayHightlighted(this.pattern, l);
            } else {
                ReadlineConsole.this.connection.write(l + Config.getLineSeparator());
            }
        }

        private void printScrolledLines() {
            for (int i = 0; i < this.lastScrolledLines; ++i) {
                String l = this.lines.get(i);
                ReadlineConsole.this.connection.write(l + Config.getLineSeparator());
            }
        }

        private void drawPrompt() {
            if (this.notFound) {
                ReadlineConsole.this.connection.write(ANSI.INVERT_BACKGROUND);
                ReadlineConsole.this.connection.write("Pattern not found");
                ReadlineConsole.this.connection.write("\u001b[0m");
            } else {
                ReadlineConsole.this.connection.write("--More(" + this.getPercentage() + "%)--");
            }
        }

        private void goHome() {
            if (!this.alternateSupported) {
                return;
            }
            this.notFound = false;
            this.resetScreen();
        }

        private void goEnd() {
            this.notFound = false;
            if (this.allLines < this.lines.size() - 1) {
                this.jumpIndex = this.lines.size() - 1;
            }
        }

        private void resetScreen() {
            this.currentLine = 0;
            this.allLines = 0;
            ReadlineConsole.this.clearScreen();
        }
    }

    class HistoryImpl
    implements CommandHistory {
        HistoryImpl() {
        }

        @Override
        public List<String> asList() {
            ArrayList<String> lst = new ArrayList<String>();
            for (int[] l : ReadlineConsole.this.readlineHistory.getAll()) {
                lst.add(Parser.stripAwayAnsiCodes((String)Parser.fromCodePoints((int[])l)));
            }
            return lst;
        }

        @Override
        public boolean isUseHistory() {
            return ReadlineConsole.this.readlineHistory.isEnabled();
        }

        @Override
        public void setUseHistory(boolean useHistory) {
            if (useHistory) {
                ReadlineConsole.this.readlineHistory.enable();
            } else {
                ReadlineConsole.this.readlineHistory.disable();
            }
        }

        @Override
        public void clear() {
            ReadlineConsole.this.readlineHistory.clear();
        }

        @Override
        public int getMaxSize() {
            return ReadlineConsole.this.readlineHistory.size();
        }
    }

    public static class SettingsBuilder {
        private InputStream inStream;
        private OutputStream outStream;
        private boolean disableHistory;
        private File historyFile;
        private int historySize;
        private FileAccessPermission permission;
        private Runnable interrupt;
        private boolean outputRedefined;

        public SettingsBuilder inputStream(InputStream inStream) {
            this.inStream = inStream;
            return this;
        }

        public SettingsBuilder outputStream(OutputStream outStream) {
            this.outStream = outStream;
            return this;
        }

        public SettingsBuilder disableHistory(boolean disableHistory) {
            this.disableHistory = disableHistory;
            return this;
        }

        public SettingsBuilder historyFile(File historyFile) {
            this.historyFile = historyFile;
            return this;
        }

        public SettingsBuilder historySize(int historySize) {
            this.historySize = historySize;
            return this;
        }

        public SettingsBuilder historyFilePermission(FileAccessPermission permission) {
            this.permission = permission;
            return this;
        }

        public SettingsBuilder interruptHook(Runnable interrupt) {
            this.interrupt = interrupt;
            return this;
        }

        public SettingsBuilder outputRedefined(boolean outputRedefined) {
            this.outputRedefined = outputRedefined;
            return this;
        }

        public Settings create() {
            return new SettingsImpl(this.inStream, this.outStream, this.outputRedefined, this.disableHistory, this.historyFile, this.historySize, this.permission, this.interrupt);
        }
    }

    private static class SettingsImpl
    implements Settings {
        private final InputStream inStream;
        private final OutputStream outStream;
        private final boolean disableHistory;
        private final File historyFile;
        private final int historySize;
        private final FileAccessPermission permission;
        private final Runnable interrupt;
        private final boolean outputRedefined;

        private SettingsImpl(InputStream inStream, OutputStream outStream, boolean outputRedefined, boolean disableHistory, File historyFile, int historySize, FileAccessPermission permission, Runnable interrupt) {
            this.inStream = inStream;
            this.outStream = outStream;
            this.outputRedefined = outputRedefined;
            this.disableHistory = disableHistory;
            this.historyFile = historyFile;
            this.historySize = historySize;
            this.permission = permission;
            this.interrupt = interrupt;
        }

        @Override
        public InputStream getInStream() {
            return this.inStream;
        }

        @Override
        public OutputStream getOutStream() {
            return this.outStream;
        }

        @Override
        public boolean isDisableHistory() {
            return this.disableHistory;
        }

        @Override
        public boolean isOutputRedefined() {
            return this.outputRedefined;
        }

        @Override
        public File getHistoryFile() {
            return this.historyFile;
        }

        @Override
        public int getHistorySize() {
            return this.historySize;
        }

        @Override
        public FileAccessPermission getPermission() {
            return this.permission;
        }

        @Override
        public Runnable getInterrupt() {
            return this.interrupt;
        }
    }

    private static class CLITerminalConnection
    extends TerminalConnection {
        private final Consumer<int[]> interceptor = ints -> {
            if (isTraceEnabled) {
                LOG.tracef("Writing %s", (Object)Parser.stripAwayAnsiCodes((String)Parser.fromCodePoints((int[])ints)));
            }
            CLITerminalConnection.super.stdoutHandler().accept(ints);
        };
        private Thread connectionThread;

        CLITerminalConnection(Terminal terminal) {
            super(terminal);
        }

        public Consumer<int[]> stdoutHandler() {
            return this.interceptor;
        }

        public void openBlockingInterruptable() throws InterruptedException {
            this.connectionThread = new Thread(() -> {
                Thread thr = new Thread(() -> super.openBlocking(), "CLI Terminal Connection (uninterruptable)");
                thr.start();
                try {
                    thr.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }, "CLI Terminal Connection (interruptable)");
            this.connectionThread.start();
            this.connectionThread.join();
        }

        public void close() {
            super.close();
            if (this.connectionThread != null) {
                this.connectionThread.interrupt();
            }
        }
    }

    public static interface Settings {
        public InputStream getInStream();

        public OutputStream getOutStream();

        public boolean isDisableHistory();

        public boolean isOutputRedefined();

        public File getHistoryFile();

        public int getHistorySize();

        public FileAccessPermission getPermission();

        public Runnable getInterrupt();
    }
}

