/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.deployment;

import java.util.ArrayList;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.jsf.deployment.JSFModuleIdFactory;
import org.jboss.as.jsf.deployment.JsfVersionMarker;
import org.jboss.as.jsf.logging.JSFLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public class JSFDependencyProcessor
implements DeploymentUnitProcessor {
    public static final String IS_CDI_PARAM = "org.jboss.jbossfaces.IS_CDI";
    private static final ModuleIdentifier JSF_SUBSYSTEM = ModuleIdentifier.create((String)"org.jboss.as.jsf");
    private JSFModuleIdFactory moduleIdFactory = JSFModuleIdFactory.getInstance();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit tl = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        if (JsfVersionMarker.isJsfDisabled(deploymentUnit)) {
            this.addJSFAPI("Mojarra-2.0", moduleSpecification, moduleLoader);
            return;
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit) && !DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        String jsfVersion = JsfVersionMarker.getVersion(tl);
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        String defaultJsfVersion = JSFModuleIdFactory.getInstance().getDefaultSlot();
        if (!this.moduleIdFactory.isValidJSFSlot(jsfVersion)) {
            JSFLogger.ROOT_LOGGER.unknownJSFVersion(jsfVersion, defaultJsfVersion);
            jsfVersion = defaultJsfVersion;
        }
        if (jsfVersion.equals(defaultJsfVersion) && !this.moduleIdFactory.isValidJSFSlot(jsfVersion)) {
            throw JSFLogger.ROOT_LOGGER.invalidDefaultJSFImpl(defaultJsfVersion);
        }
        this.addJSFAPI(jsfVersion, moduleSpecification, moduleLoader);
        this.addJSFImpl(jsfVersion, moduleSpecification, moduleLoader);
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, JSF_SUBSYSTEM, false, false, true, false));
        this.addJSFInjection(jsfVersion, moduleSpecification, moduleLoader);
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData != null) {
            this.addCDIFlag(warMetaData, deploymentUnit);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void addJSFAPI(String jsfVersion, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        ModuleIdentifier jsfModule = this.moduleIdFactory.getApiModId(jsfVersion);
        ModuleDependency jsfAPI = new ModuleDependency(moduleLoader, jsfModule, false, false, false, false);
        moduleSpecification.addSystemDependency(jsfAPI);
    }

    private void addJSFImpl(String jsfVersion, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        ModuleIdentifier jsfModule = this.moduleIdFactory.getImplModId(jsfVersion);
        ModuleDependency jsfImpl = new ModuleDependency(moduleLoader, jsfModule, false, false, true, false);
        jsfImpl.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpecification.addSystemDependency(jsfImpl);
    }

    private void addJSFInjection(String jsfVersion, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        if (jsfVersion.equals("WAR_BUNDLES_JSF_IMPL")) {
            return;
        }
        ModuleIdentifier jsfInjectionModule = this.moduleIdFactory.getInjectionModId(jsfVersion);
        ModuleDependency jsfInjectionDependency = new ModuleDependency(moduleLoader, jsfInjectionModule, false, true, true, false);
        jsfInjectionDependency.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpecification.addSystemDependency(jsfInjectionDependency);
    }

    private void addCDIFlag(WarMetaData warMetaData, DeploymentUnit deploymentUnit) {
        ArrayList<ParamValueMetaData> contextParams;
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        if ((contextParams = webMetaData.getContextParams()) == null) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        boolean isCDI = WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit);
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(IS_CDI_PARAM);
        param.setParamValue(Boolean.toString(isCDI));
        contextParams.add(param);
        webMetaData.setContextParams(contextParams);
    }
}

