/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.resources;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.resources.DomainResolver;
import org.jboss.as.host.controller.mgmt.DomainHostExcludeRegistry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HostExcludeResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"host-exclude");
    public static final SimpleAttributeDefinition HOST_RELEASE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"host-release", (ModelType)ModelType.STRING, (boolean)false).setXmlName("id")).setAlternatives(new String[]{"management-major-version"})).setValidator((ParameterValidator)EnumValidator.create(KnownRelease.class, (boolean)false, (boolean)false))).build();
    public static final SimpleAttributeDefinition MANAGEMENT_MAJOR_VERSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-major-version", (ModelType)ModelType.INT, (boolean)false).setXmlName("major-version")).setAlternatives(new String[]{"host-release"})).setRequires(new String[]{"management-minor-version"})).build();
    public static final SimpleAttributeDefinition MANAGEMENT_MINOR_VERSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-minor-version", (ModelType)ModelType.INT).setRequired(false)).setXmlName("minor-version")).setAlternatives(new String[]{"host-release"})).setRequires(new String[]{"management-major-version"})).build();
    public static final SimpleAttributeDefinition MANAGEMENT_MICRO_VERSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-micro-version", (ModelType)ModelType.INT).setRequired(false)).setXmlName("micro-version")).setAlternatives(new String[]{"host-release"})).setRequires(new String[]{"management-major-version", "management-minor-version"})).build();
    public static final AttributeDefinition EXCLUDED_EXTENSIONS = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("excluded-extensions").setRequired(false)).build();
    public static final AttributeDefinition ACTIVE_SERVER_GROUPS = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("active-server-groups").setRequired(false)).build();
    public static final AttributeDefinition ACTIVE_SOCKET_BINDING_GROUPS = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("active-socket-binding-groups").setRequired(false)).build();
    private static final AttributeDefinition[] attributes = new AttributeDefinition[]{MANAGEMENT_MAJOR_VERSION, MANAGEMENT_MINOR_VERSION, MANAGEMENT_MICRO_VERSION, HOST_RELEASE, EXCLUDED_EXTENSIONS, ACTIVE_SERVER_GROUPS, ACTIVE_SOCKET_BINDING_GROUPS};
    private final DomainHostExcludeRegistry domainHostExcludeRegistry;

    public HostExcludeResourceDefinition(DomainHostExcludeRegistry domainHostExcludeRegistry) {
        super(PATH_ELEMENT, DomainResolver.getResolver("host-exclude", false), (OperationStepHandler)new AddHandler(domainHostExcludeRegistry), (OperationStepHandler)new RemoveHandler(domainHostExcludeRegistry));
        this.domainHostExcludeRegistry = domainHostExcludeRegistry;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteHandler handler = new WriteHandler(this.domainHostExcludeRegistry, attributes);
        for (AttributeDefinition ad : attributes) {
            resourceRegistration.registerReadWriteAttribute(ad, null, (OperationStepHandler)handler);
        }
    }

    private static void registerHostExcludes(OperationContext context, ModelNode model, DomainHostExcludeRegistry registry) throws OperationFailedException {
        ModelNode asbg;
        ModelNode asg;
        DomainHostExcludeRegistry.VersionKey versionKey = HostExcludeResourceDefinition.getVersionKey(context, model);
        HashSet<String> ignoredExtensions = null;
        HashSet<String> activeServerGroups = null;
        HashSet<String> activeSocketBindingGroups = null;
        ModelNode ie = EXCLUDED_EXTENSIONS.resolveModelAttribute(context, model);
        if (ie.isDefined() && ie.asInt() > 0) {
            ignoredExtensions = new HashSet<String>();
            for (Object node : ie.asList()) {
                ignoredExtensions.add(node.asString());
            }
        }
        if ((asg = ACTIVE_SERVER_GROUPS.resolveModelAttribute(context, model)).isDefined() && asg.asInt() > 0) {
            activeServerGroups = new HashSet<String>();
            for (ModelNode node : asg.asList()) {
                activeServerGroups.add(node.asString());
            }
        }
        if ((asbg = ACTIVE_SOCKET_BINDING_GROUPS.resolveModelAttribute(context, model)).isDefined() && asbg.asInt() > 0) {
            activeSocketBindingGroups = new HashSet<String>();
            for (ModelNode node : asbg.asList()) {
                activeSocketBindingGroups.add(node.asString());
            }
        }
        registry.recordVersionExcludeData(versionKey, ignoredExtensions, activeServerGroups, activeSocketBindingGroups);
    }

    private static DomainHostExcludeRegistry.VersionKey getVersionKey(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode release = HOST_RELEASE.resolveModelAttribute(context, model);
        if (release.isDefined()) {
            KnownRelease kr = KnownRelease.fromName(release.asString());
            return new DomainHostExcludeRegistry.VersionKey(kr.major, kr.minor, null);
        }
        int major = MANAGEMENT_MAJOR_VERSION.resolveModelAttribute(context, model).asInt();
        int minor = MANAGEMENT_MINOR_VERSION.resolveModelAttribute(context, model).asInt();
        ModelNode micro = MANAGEMENT_MICRO_VERSION.resolveModelAttribute(context, model);
        if (micro.isDefined()) {
            return new DomainHostExcludeRegistry.VersionKey(major, minor, micro.asInt());
        }
        return new DomainHostExcludeRegistry.VersionKey(major, minor, null);
    }

    private static final class WriteHandler
    extends AbstractWriteAttributeHandler<Void> {
        private final DomainHostExcludeRegistry domainHostExcludeRegistry;

        private WriteHandler(DomainHostExcludeRegistry domainHostExcludeRegistry, AttributeDefinition ... attributes) {
            super(attributes);
            this.domainHostExcludeRegistry = domainHostExcludeRegistry;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            HostExcludeResourceDefinition.registerHostExcludes(context, context.readResource(PathAddress.EMPTY_ADDRESS).getModel(), this.domainHostExcludeRegistry);
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            HostExcludeResourceDefinition.registerHostExcludes(context, context.readResource(PathAddress.EMPTY_ADDRESS).getModel(), this.domainHostExcludeRegistry);
        }
    }

    private static final class RemoveHandler
    extends AbstractRemoveStepHandler {
        private final DomainHostExcludeRegistry domainHostExcludeRegistry;

        private RemoveHandler(DomainHostExcludeRegistry domainHostExcludeRegistry) {
            this.domainHostExcludeRegistry = domainHostExcludeRegistry;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            DomainHostExcludeRegistry.VersionKey versionKey = HostExcludeResourceDefinition.getVersionKey(context, model);
            this.domainHostExcludeRegistry.removeVersionExcludeData(versionKey);
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            HostExcludeResourceDefinition.registerHostExcludes(context, model, this.domainHostExcludeRegistry);
        }
    }

    private static final class AddHandler
    extends AbstractAddStepHandler {
        private final DomainHostExcludeRegistry domainHostExcludeRegistry;

        private AddHandler(DomainHostExcludeRegistry domainHostExcludeRegistry) {
            super(attributes);
            this.domainHostExcludeRegistry = domainHostExcludeRegistry;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            HostExcludeResourceDefinition.registerHostExcludes(context, resource.getModel(), this.domainHostExcludeRegistry);
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            try {
                DomainHostExcludeRegistry.VersionKey versionKey = HostExcludeResourceDefinition.getVersionKey(context, resource.getModel());
                this.domainHostExcludeRegistry.removeVersionExcludeData(versionKey);
            }
            catch (OperationFailedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static enum KnownRelease {
        EAP62("EAP6.2", 1, 5),
        EAP63("EAP6.3", 1, 6),
        EAP64("EAP6.4", 1, 7),
        EAP70("EAP7.0", 4, 1),
        EAP71("EAP7.1", 5, 0),
        WILDFLY10("WildFly10.0", 4, 0),
        WILDFLY10_1("WildFly10.1", 4, 2),
        WILDFLY11("WildFly11.0", 5, 0),
        WILDFLY12("WildFly12.0", 6, 0),
        WILDFLY13("WildFly13.0", 7, 0);

        private static final Map<String, KnownRelease> map;
        private final String name;
        private final int major;
        private final int minor;

        private static KnownRelease fromName(String name) {
            KnownRelease kr = map.get(name.toUpperCase(Locale.ENGLISH));
            if (kr == null) {
                throw new IllegalArgumentException(name);
            }
            return kr;
        }

        private KnownRelease(String name, int major, int minor) {
            this.name = name;
            this.major = major;
            this.minor = minor;
        }

        public String toString() {
            return this.name;
        }

        static {
            map = new HashMap<String, KnownRelease>();
            for (KnownRelease kr : KnownRelease.values()) {
                map.put(kr.toString().toUpperCase(Locale.ENGLISH), kr);
            }
        }
    }
}

