/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing;

import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.internal.metrics.Metrics;
import io.jaegertracing.internal.metrics.NoopMetricsFactory;
import io.jaegertracing.internal.propagation.B3TextMapCodec;
import io.jaegertracing.internal.propagation.CompositeCodec;
import io.jaegertracing.internal.propagation.TextMapCodec;
import io.jaegertracing.internal.reporters.CompositeReporter;
import io.jaegertracing.internal.reporters.LoggingReporter;
import io.jaegertracing.internal.reporters.RemoteReporter;
import io.jaegertracing.internal.samplers.ConstSampler;
import io.jaegertracing.internal.samplers.HttpSamplingManager;
import io.jaegertracing.internal.samplers.ProbabilisticSampler;
import io.jaegertracing.internal.samplers.RateLimitingSampler;
import io.jaegertracing.internal.samplers.RemoteControlledSampler;
import io.jaegertracing.internal.senders.SenderResolver;
import io.jaegertracing.spi.Codec;
import io.jaegertracing.spi.MetricsFactory;
import io.jaegertracing.spi.Reporter;
import io.jaegertracing.spi.Sampler;
import io.jaegertracing.spi.Sender;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    public static final String JAEGER_PREFIX = "JAEGER_";
    public static final String JAEGER_ENDPOINT = "JAEGER_ENDPOINT";
    public static final String JAEGER_AUTH_TOKEN = "JAEGER_AUTH_TOKEN";
    public static final String JAEGER_USER = "JAEGER_USER";
    public static final String JAEGER_PASSWORD = "JAEGER_PASSWORD";
    public static final String JAEGER_AGENT_HOST = "JAEGER_AGENT_HOST";
    public static final String JAEGER_AGENT_PORT = "JAEGER_AGENT_PORT";
    public static final String JAEGER_REPORTER_LOG_SPANS = "JAEGER_REPORTER_LOG_SPANS";
    public static final String JAEGER_REPORTER_MAX_QUEUE_SIZE = "JAEGER_REPORTER_MAX_QUEUE_SIZE";
    public static final String JAEGER_REPORTER_FLUSH_INTERVAL = "JAEGER_REPORTER_FLUSH_INTERVAL";
    public static final String JAEGER_SAMPLER_TYPE = "JAEGER_SAMPLER_TYPE";
    public static final String JAEGER_SAMPLER_PARAM = "JAEGER_SAMPLER_PARAM";
    public static final String JAEGER_SAMPLER_MANAGER_HOST_PORT = "JAEGER_SAMPLER_MANAGER_HOST_PORT";
    public static final String JAEGER_SERVICE_NAME = "JAEGER_SERVICE_NAME";
    public static final String JAEGER_TAGS = "JAEGER_TAGS";
    public static final String JAEGER_PROPAGATION = "JAEGER_PROPAGATION";
    public static final String JAEGER_SENDER_FACTORY = "JAEGER_SENDER_FACTORY";
    private String serviceName;
    private SamplerConfiguration samplerConfig;
    private ReporterConfiguration reporterConfig;
    private CodecConfiguration codecConfig;
    private MetricsFactory metricsFactory;
    private Map<String, String> tracerTags;
    private JaegerTracer tracer;

    public Configuration(String serviceName) {
        this.serviceName = JaegerTracer.Builder.checkValidServiceName(serviceName);
    }

    public static Configuration fromEnv() {
        return Configuration.fromEnv(Configuration.getProperty(JAEGER_SERVICE_NAME));
    }

    public static Configuration fromEnv(String serviceName) {
        return new Configuration(serviceName).withTracerTags(Configuration.tracerTagsFromEnv()).withReporter(ReporterConfiguration.fromEnv()).withSampler(SamplerConfiguration.fromEnv()).withCodec(CodecConfiguration.fromEnv());
    }

    public JaegerTracer.Builder getTracerBuilder() {
        if (this.reporterConfig == null) {
            this.reporterConfig = new ReporterConfiguration();
        }
        if (this.samplerConfig == null) {
            this.samplerConfig = new SamplerConfiguration();
        }
        if (this.codecConfig == null) {
            this.codecConfig = new CodecConfiguration();
        }
        if (this.metricsFactory == null) {
            this.metricsFactory = this.loadMetricsFactory();
        }
        Metrics metrics = new Metrics(this.metricsFactory);
        Reporter reporter = this.reporterConfig.getReporter(metrics);
        Sampler sampler = this.samplerConfig.createSampler(this.serviceName, metrics);
        JaegerTracer.Builder builder = new JaegerTracer.Builder(this.serviceName).withSampler(sampler).withReporter(reporter).withMetrics(metrics).withTags(this.tracerTags);
        this.codecConfig.apply(builder);
        return builder;
    }

    public synchronized JaegerTracer getTracer() {
        if (this.tracer != null) {
            return this.tracer;
        }
        this.tracer = this.getTracerBuilder().build();
        log.info("Initialized tracer={}", (Object)this.tracer);
        return this.tracer;
    }

    public synchronized void closeTracer() {
        if (this.tracer != null) {
            this.tracer.close();
        }
    }

    private MetricsFactory loadMetricsFactory() {
        ServiceLoader<MetricsFactory> loader = ServiceLoader.load(MetricsFactory.class);
        Iterator<MetricsFactory> iterator = loader.iterator();
        if (iterator.hasNext()) {
            MetricsFactory metricsFactory = iterator.next();
            log.info("Found a Metrics Factory service: {}", metricsFactory.getClass());
            return metricsFactory;
        }
        return new NoopMetricsFactory();
    }

    public Configuration withMetricsFactory(MetricsFactory metricsFactory) {
        this.metricsFactory = metricsFactory;
        return this;
    }

    public Configuration withServiceName(String serviceName) {
        this.serviceName = JaegerTracer.Builder.checkValidServiceName(serviceName);
        return this;
    }

    public Configuration withReporter(ReporterConfiguration reporterConfig) {
        this.reporterConfig = reporterConfig;
        return this;
    }

    public Configuration withSampler(SamplerConfiguration samplerConfig) {
        this.samplerConfig = samplerConfig;
        return this;
    }

    public Configuration withCodec(CodecConfiguration codecConfig) {
        this.codecConfig = codecConfig;
        return this;
    }

    public Configuration withTracerTags(Map<String, String> tracerTags) {
        if (tracerTags != null) {
            this.tracerTags = new HashMap<String, String>(tracerTags);
        }
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ReporterConfiguration getReporter() {
        return this.reporterConfig;
    }

    public SamplerConfiguration getSampler() {
        return this.samplerConfig;
    }

    public CodecConfiguration getCodec() {
        return this.codecConfig;
    }

    public MetricsFactory getMetricsFactory() {
        return this.metricsFactory;
    }

    public Map<String, String> getTracerTags() {
        return this.tracerTags == null ? null : Collections.unmodifiableMap(this.tracerTags);
    }

    private static String stringOrDefault(String value, String defaultValue) {
        return value != null && value.length() > 0 ? value : defaultValue;
    }

    private static Number numberOrDefault(Number value, Number defaultValue) {
        return value != null ? (Number)value : (Number)defaultValue;
    }

    private static String getProperty(String name) {
        return System.getProperty(name, System.getenv(name));
    }

    private static Integer getPropertyAsInt(String name) {
        String value = Configuration.getProperty(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse integer for property '" + name + "' with value '" + value + "'", (Throwable)e);
            }
        }
        return null;
    }

    private static Number getPropertyAsNum(String name) {
        String value = Configuration.getProperty(name);
        if (value != null) {
            try {
                return NumberFormat.getInstance().parse(value);
            }
            catch (ParseException e) {
                log.error("Failed to parse number for property '" + name + "' with value '" + value + "'", (Throwable)e);
            }
        }
        return null;
    }

    private static boolean getPropertyAsBool(String name) {
        return Boolean.valueOf(Configuration.getProperty(name));
    }

    private static Map<String, String> tracerTagsFromEnv() {
        HashMap<String, String> tracerTagMaps = null;
        String tracerTags = Configuration.getProperty(JAEGER_TAGS);
        if (tracerTags != null) {
            String[] tags;
            for (String tag : tags = tracerTags.split("\\s*,\\s*")) {
                String[] tagValue = tag.split("\\s*=\\s*");
                if (tagValue.length == 2) {
                    if (tracerTagMaps == null) {
                        tracerTagMaps = new HashMap<String, String>();
                    }
                    tracerTagMaps.put(tagValue[0], Configuration.resolveValue(tagValue[1]));
                    continue;
                }
                log.error("Tracer tag incorrectly formatted: " + tag);
            }
        }
        return tracerTagMaps;
    }

    private static String resolveValue(String value) {
        String[] ref;
        if (value.startsWith("${") && value.endsWith("}") && (ref = value.substring(2, value.length() - 1).split("\\s*:\\s*")).length > 0) {
            String propertyValue = Configuration.getProperty(ref[0]);
            if (propertyValue == null && ref.length > 1) {
                propertyValue = ref[1];
            }
            return propertyValue;
        }
        return value;
    }

    public static class SenderConfiguration {
        private Sender sender;
        private String agentHost;
        private Integer agentPort;
        private String endpoint;
        private String authToken;
        private String authUsername;
        private String authPassword;

        public SenderConfiguration withAgentHost(String agentHost) {
            this.agentHost = agentHost;
            return this;
        }

        public SenderConfiguration withAgentPort(Integer agentPort) {
            this.agentPort = agentPort;
            return this;
        }

        public SenderConfiguration withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public SenderConfiguration withAuthToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public SenderConfiguration withAuthUsername(String username) {
            this.authUsername = username;
            return this;
        }

        public SenderConfiguration withAuthPassword(String password) {
            this.authPassword = password;
            return this;
        }

        public Sender getSender() {
            if (null != this.sender) {
                return this.sender;
            }
            return SenderResolver.resolve(this);
        }

        public static SenderConfiguration fromEnv() {
            String agentHost = Configuration.getProperty(Configuration.JAEGER_AGENT_HOST);
            Integer agentPort = Configuration.getPropertyAsInt(Configuration.JAEGER_AGENT_PORT);
            String collectorEndpoint = Configuration.getProperty(Configuration.JAEGER_ENDPOINT);
            String authToken = Configuration.getProperty(Configuration.JAEGER_AUTH_TOKEN);
            String authUsername = Configuration.getProperty(Configuration.JAEGER_USER);
            String authPassword = Configuration.getProperty(Configuration.JAEGER_PASSWORD);
            return new SenderConfiguration().withAgentHost(agentHost).withAgentPort(agentPort).withEndpoint(collectorEndpoint).withAuthToken(authToken).withAuthUsername(authUsername).withAuthPassword(authPassword);
        }

        public String getAgentHost() {
            return this.agentHost;
        }

        public Integer getAgentPort() {
            return this.agentPort;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getAuthToken() {
            return this.authToken;
        }

        public String getAuthUsername() {
            return this.authUsername;
        }

        public String getAuthPassword() {
            return this.authPassword;
        }
    }

    public static class ReporterConfiguration {
        private Boolean logSpans;
        private Integer flushIntervalMs;
        private Integer maxQueueSize;
        private SenderConfiguration senderConfiguration = new SenderConfiguration();

        public static ReporterConfiguration fromEnv() {
            return new ReporterConfiguration().withLogSpans(Configuration.getPropertyAsBool(Configuration.JAEGER_REPORTER_LOG_SPANS)).withFlushInterval(Configuration.getPropertyAsInt(Configuration.JAEGER_REPORTER_FLUSH_INTERVAL)).withMaxQueueSize(Configuration.getPropertyAsInt(Configuration.JAEGER_REPORTER_MAX_QUEUE_SIZE)).withSender(SenderConfiguration.fromEnv());
        }

        public ReporterConfiguration withLogSpans(Boolean logSpans) {
            this.logSpans = logSpans;
            return this;
        }

        public ReporterConfiguration withFlushInterval(Integer flushIntervalMs) {
            this.flushIntervalMs = flushIntervalMs;
            return this;
        }

        public ReporterConfiguration withMaxQueueSize(Integer maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public ReporterConfiguration withSender(SenderConfiguration senderConfiguration) {
            this.senderConfiguration = senderConfiguration;
            return this;
        }

        private Reporter getReporter(Metrics metrics) {
            Reporter reporter = new RemoteReporter.Builder().withMetrics(metrics).withSender(this.senderConfiguration.getSender()).withFlushInterval(Configuration.numberOrDefault(this.flushIntervalMs, 1000).intValue()).withMaxQueueSize(Configuration.numberOrDefault(this.maxQueueSize, 100).intValue()).build();
            if (Boolean.TRUE.equals(this.logSpans)) {
                LoggingReporter loggingReporter = new LoggingReporter();
                reporter = new CompositeReporter(reporter, loggingReporter);
            }
            return reporter;
        }

        public Boolean getLogSpans() {
            return this.logSpans;
        }

        public Integer getFlushIntervalMs() {
            return this.flushIntervalMs;
        }

        public Integer getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public SenderConfiguration getSenderConfiguration() {
            return this.senderConfiguration;
        }
    }

    public static class CodecConfiguration {
        private final Map<Format<?>, List<Codec<TextMap>>> codecs;

        public CodecConfiguration() {
            this.codecs = new HashMap();
        }

        private CodecConfiguration(Map<Format<?>, List<Codec<TextMap>>> codecs) {
            this.codecs = codecs;
        }

        public static CodecConfiguration fromEnv() {
            HashMap codecs = new HashMap();
            String propagation = Configuration.getProperty(Configuration.JAEGER_PROPAGATION);
            if (propagation != null) {
                for (String format : Arrays.asList(propagation.split(","))) {
                    try {
                        switch (Propagation.valueOf(format.toUpperCase())) {
                            case JAEGER: {
                                CodecConfiguration.addCodec(codecs, Format.Builtin.HTTP_HEADERS, new TextMapCodec(true));
                                CodecConfiguration.addCodec(codecs, Format.Builtin.TEXT_MAP, new TextMapCodec(false));
                                break;
                            }
                            case B3: {
                                CodecConfiguration.addCodec(codecs, Format.Builtin.HTTP_HEADERS, new B3TextMapCodec.Builder().build());
                                CodecConfiguration.addCodec(codecs, Format.Builtin.TEXT_MAP, new B3TextMapCodec.Builder().build());
                                break;
                            }
                            default: {
                                log.error("Unhandled propagation format '" + format + "'");
                                break;
                            }
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        log.error("Unknown propagation format '" + format + "'");
                    }
                }
            }
            return new CodecConfiguration(codecs);
        }

        public CodecConfiguration withCodec(Format<?> format, Codec<TextMap> codec) {
            CodecConfiguration.addCodec(this.codecs, format, codec);
            return this;
        }

        public Map<Format<?>, List<Codec<TextMap>>> getCodecs() {
            return Collections.unmodifiableMap(this.codecs);
        }

        private static void addCodec(Map<Format<?>, List<Codec<TextMap>>> codecs, Format<?> format, Codec<TextMap> codec) {
            List<Codec<TextMap>> codecList = codecs.get(format);
            if (codecList == null) {
                codecList = new LinkedList<Codec<TextMap>>();
                codecs.put(format, codecList);
            }
            codecList.add(codec);
        }

        public void apply(JaegerTracer.Builder builder) {
            this.registerCodec(builder, (Format<TextMap>)Format.Builtin.HTTP_HEADERS);
            this.registerCodec(builder, (Format<TextMap>)Format.Builtin.TEXT_MAP);
        }

        protected void registerCodec(JaegerTracer.Builder builder, Format<TextMap> format) {
            if (this.codecs.containsKey(format)) {
                List codecsForFormat = this.codecs.get(format);
                Codec<Object> codec = codecsForFormat.size() == 1 ? codecsForFormat.get(0) : new CompositeCodec(codecsForFormat);
                builder.registerInjector(format, codec);
                builder.registerExtractor(format, codec);
            }
        }
    }

    public static class SamplerConfiguration {
        private String type;
        private Number param;
        private String managerHostPort;

        public static SamplerConfiguration fromEnv() {
            return new SamplerConfiguration().withType(Configuration.getProperty(Configuration.JAEGER_SAMPLER_TYPE)).withParam(Configuration.getPropertyAsNum(Configuration.JAEGER_SAMPLER_PARAM)).withManagerHostPort(Configuration.getProperty(Configuration.JAEGER_SAMPLER_MANAGER_HOST_PORT));
        }

        Sampler createSampler(String serviceName, Metrics metrics) {
            String samplerType = Configuration.stringOrDefault(this.getType(), "remote");
            Number samplerParam = Configuration.numberOrDefault(this.getParam(), 0.001);
            String hostPort = Configuration.stringOrDefault(this.getManagerHostPort(), "localhost:5778");
            if (samplerType.equals("const")) {
                return new ConstSampler(samplerParam.intValue() != 0);
            }
            if (samplerType.equals("probabilistic")) {
                return new ProbabilisticSampler(samplerParam.doubleValue());
            }
            if (samplerType.equals("ratelimiting")) {
                return new RateLimitingSampler(samplerParam.intValue());
            }
            if (samplerType.equals("remote")) {
                return new RemoteControlledSampler.Builder(serviceName).withSamplingManager(new HttpSamplingManager(hostPort)).withInitialSampler(new ProbabilisticSampler(samplerParam.doubleValue())).withMetrics(metrics).build();
            }
            throw new IllegalStateException(String.format("Invalid sampling strategy %s", samplerType));
        }

        public String getType() {
            return this.type;
        }

        public Number getParam() {
            return this.param;
        }

        public String getManagerHostPort() {
            return this.managerHostPort;
        }

        public SamplerConfiguration withType(String type) {
            this.type = type;
            return this;
        }

        public SamplerConfiguration withParam(Number param) {
            this.param = param;
            return this;
        }

        public SamplerConfiguration withManagerHostPort(String managerHostPort) {
            this.managerHostPort = managerHostPort;
            return this;
        }
    }

    public static enum Propagation {
        JAEGER,
        B3;

    }
}

