/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.samplers.http;

import io.jaegertracing.internal.samplers.http.PerOperationSamplingParameters;
import java.beans.ConstructorProperties;
import java.util.List;

public final class OperationSamplingParameters {
    private final double defaultSamplingProbability;
    private final double defaultLowerBoundTracesPerSecond;
    private final List<PerOperationSamplingParameters> perOperationStrategies;

    @ConstructorProperties(value={"defaultSamplingProbability", "defaultLowerBoundTracesPerSecond", "perOperationStrategies"})
    public OperationSamplingParameters(double defaultSamplingProbability, double defaultLowerBoundTracesPerSecond, List<PerOperationSamplingParameters> perOperationStrategies) {
        this.defaultSamplingProbability = defaultSamplingProbability;
        this.defaultLowerBoundTracesPerSecond = defaultLowerBoundTracesPerSecond;
        this.perOperationStrategies = perOperationStrategies;
    }

    public double getDefaultSamplingProbability() {
        return this.defaultSamplingProbability;
    }

    public double getDefaultLowerBoundTracesPerSecond() {
        return this.defaultLowerBoundTracesPerSecond;
    }

    public List<PerOperationSamplingParameters> getPerOperationStrategies() {
        return this.perOperationStrategies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationSamplingParameters)) {
            return false;
        }
        OperationSamplingParameters other = (OperationSamplingParameters)o;
        if (Double.compare(this.getDefaultSamplingProbability(), other.getDefaultSamplingProbability()) != 0) {
            return false;
        }
        if (Double.compare(this.getDefaultLowerBoundTracesPerSecond(), other.getDefaultLowerBoundTracesPerSecond()) != 0) {
            return false;
        }
        List<PerOperationSamplingParameters> this$perOperationStrategies = this.getPerOperationStrategies();
        List<PerOperationSamplingParameters> other$perOperationStrategies = other.getPerOperationStrategies();
        return !(this$perOperationStrategies == null ? other$perOperationStrategies != null : !((Object)this$perOperationStrategies).equals(other$perOperationStrategies));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $defaultSamplingProbability = Double.doubleToLongBits(this.getDefaultSamplingProbability());
        result = result * 59 + (int)($defaultSamplingProbability >>> 32 ^ $defaultSamplingProbability);
        long $defaultLowerBoundTracesPerSecond = Double.doubleToLongBits(this.getDefaultLowerBoundTracesPerSecond());
        result = result * 59 + (int)($defaultLowerBoundTracesPerSecond >>> 32 ^ $defaultLowerBoundTracesPerSecond);
        List<PerOperationSamplingParameters> $perOperationStrategies = this.getPerOperationStrategies();
        result = result * 59 + ($perOperationStrategies == null ? 43 : ((Object)$perOperationStrategies).hashCode());
        return result;
    }

    public String toString() {
        return "OperationSamplingParameters(defaultSamplingProbability=" + this.getDefaultSamplingProbability() + ", defaultLowerBoundTracesPerSecond=" + this.getDefaultLowerBoundTracesPerSecond() + ", perOperationStrategies=" + this.getPerOperationStrategies() + ")";
    }
}

