/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.datasources.agroal;

import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.datasources.agroal.AbstractDataSourceDefinition;
import org.wildfly.extension.datasources.agroal.AbstractDataSourceOperations;
import org.wildfly.extension.datasources.agroal.AgroalExtension;
import org.wildfly.extension.datasources.agroal.DataSourceService;
import org.wildfly.extension.datasources.agroal.DriverOperations;
import org.wildfly.extension.datasources.agroal.XADataSourceDefinition;

class XADataSourceOperations
extends AbstractAddStepHandler {
    static final String XADATASOURCE_SERVICE_NAME = "xa-datasource";
    static final ServiceName XADATASOURCE_SERVICE_PREFIX = AgroalExtension.BASE_SERVICE_NAME.append(new String[]{"xa-datasource"});
    static final OperationStepHandler ADD_OPERATION = new XADataSourceAdd();
    static final OperationStepHandler REMOVE_OPERATION = new XADataSourceRemove();

    XADataSourceOperations() {
    }

    private static class XADataSourceRemove
    extends AbstractRemoveStepHandler {
        private XADataSourceRemove() {
            super(new RuntimeCapability[]{XADataSourceDefinition.DATA_SOURCE_CAPABILITY});
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String datasourceName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            ServiceName datasourceServiceName = ServiceName.of((ServiceName)XADATASOURCE_SERVICE_PREFIX, (String[])new String[]{datasourceName});
            context.removeService(datasourceServiceName);
        }
    }

    private static class XADataSourceAdd
    extends AbstractAddStepHandler {
        private XADataSourceAdd() {
            super(XADataSourceDefinition.DATA_SOURCE_CAPABILITY, XADataSourceDefinition.ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String datasourceName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            ModelNode factoryModel = AbstractDataSourceDefinition.CONNECTION_FACTORY_ATTRIBUTE.resolveModelAttribute(context, model);
            AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration = AbstractDataSourceOperations.connectionFactoryConfiguration(context, factoryModel);
            ModelNode poolModel = AbstractDataSourceDefinition.CONNECTION_POOL_ATTRIBUTE.resolveModelAttribute(context, model);
            AgroalConnectionPoolConfigurationSupplier connectionPoolConfiguration = AbstractDataSourceOperations.connectionPoolConfiguration(context, poolModel);
            connectionPoolConfiguration.connectionFactoryConfiguration((Supplier)connectionFactoryConfiguration);
            AgroalDataSourceConfigurationSupplier dataSourceConfiguration = new AgroalDataSourceConfigurationSupplier();
            dataSourceConfiguration.connectionPoolConfiguration((Supplier)connectionPoolConfiguration);
            dataSourceConfiguration.metricsEnabled(AbstractDataSourceDefinition.STATISTICS_ENABLED_ATTRIBUTE.resolveModelAttribute(context, model).asBoolean());
            String jndiName = AbstractDataSourceDefinition.JNDI_NAME_ATTRIBUTE.resolveModelAttribute(context, model).asString();
            String driverName = AbstractDataSourceDefinition.DRIVER_ATTRIBUTE.resolveModelAttribute(context, factoryModel).asString();
            DataSourceService dataSourceService = new DataSourceService(datasourceName, jndiName, false, false, true, dataSourceConfiguration);
            ServiceBuilder serviceBuilder = context.getServiceTarget().addService(XADATASOURCE_SERVICE_PREFIX.append(new String[]{datasourceName}), (Service)dataSourceService);
            AbstractDataSourceOperations.setupElytronSecurity(context, factoryModel, dataSourceService, serviceBuilder);
            serviceBuilder.addDependency(DriverOperations.DRIVER_SERVICE_PREFIX.append(new String[]{driverName}), Class.class, dataSourceService.getDriverInjector());
            serviceBuilder.install();
        }
    }
}

