/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.noopts;

import javax.resource.ResourceException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jca.core.api.connectionmanager.ConnectionManager;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.spi.transaction.local.LocalXAException;
import org.jboss.jca.core.spi.transaction.local.LocalXAResource;
import org.jboss.jca.core.spi.transaction.xa.XAResourceWrapper;

public class LocalXAResourceImpl
implements LocalXAResource,
XAResourceWrapper {
    private ConnectionListener cl = null;
    private ConnectionManager connectionManager = null;
    private String productName;
    private String productVersion;
    private String jndiName;

    public LocalXAResourceImpl(String productName, String productVersion, String jndiName) {
        this.productName = productName;
        this.productVersion = productVersion;
        this.jndiName = jndiName;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setConnectionListener(ConnectionListener cl) {
        this.cl = cl;
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            this.cl.getManagedConnection().getLocalTransaction().begin();
        }
        catch (ResourceException re) {
            throw new LocalXAException("start", -3, (Throwable)re);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.cl.getManagedConnection().getLocalTransaction().commit();
        }
        catch (ResourceException re) {
            this.connectionManager.returnManagedConnection(this.cl, true);
            throw new LocalXAException("commit", 100, (Throwable)re);
        }
    }

    public void forget(Xid xid) throws XAException {
        throw new LocalXAException("Error", -3);
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource == this;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        throw new LocalXAException("Error", -3);
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.cl.getManagedConnection().getLocalTransaction().rollback();
        }
        catch (ResourceException re) {
            this.connectionManager.returnManagedConnection(this.cl, true);
            throw new LocalXAException("rollback", -3, (Throwable)re);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public XAResource getResource() {
        return this;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getJndiName() {
        return this.jndiName;
    }
}

