/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.opentracing.smallrye;

import io.jaegertracing.Configuration;
import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.server.SpanFinishingFilter;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.util.GlobalTracer;
import java.util.EnumSet;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.wildfly.microprofile.opentracing.smallrye.TracingLogger;

@WebListener
public class TracerInitializer
implements ServletContextListener {
    public static final String SMALLRYE_OPENTRACING_SERVICE_NAME = "smallrye.opentracing.serviceName";
    @Inject
    Event<Tracer> tracerInitialized;

    public void contextInitialized(ServletContextEvent sce) {
        if (null == this.tracerInitialized) {
            TracingLogger.ROOT_LOGGER.noCdiEventSupport();
            return;
        }
        if (GlobalTracer.isRegistered()) {
            TracingLogger.ROOT_LOGGER.alreadyRegistered();
            return;
        }
        Tracer tracer = TracerResolver.resolveTracer();
        if (null == tracer) {
            String serviceName = sce.getServletContext().getInitParameter(SMALLRYE_OPENTRACING_SERVICE_NAME);
            if (null == serviceName || serviceName.isEmpty()) {
                TracingLogger.ROOT_LOGGER.noServiceName();
                tracer = NoopTracerFactory.create();
            } else {
                tracer = Configuration.fromEnv((String)serviceName).getTracer();
            }
        }
        TracingLogger.ROOT_LOGGER.registeringTracer(tracer.getClass().getName());
        this.tracerInitialized.fire((Object)tracer);
        TracingLogger.ROOT_LOGGER.initializing(tracer.toString());
        FilterRegistration.Dynamic filterRegistration = sce.getServletContext().addFilter(SpanFinishingFilter.class.getName(), (Filter)new SpanFinishingFilter(tracer));
        filterRegistration.setAsyncSupported(true);
        filterRegistration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"*"});
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

