/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.hibernate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.hibernate.MethodAdapter;
import org.jboss.as.hibernate.TransformedState;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.TraceClassVisitor;
import org.wildfly.security.manager.WildFlySecurityManager;

public class Hibernate51CompatibilityTransformer
implements ClassFileTransformer {
    private static final Hibernate51CompatibilityTransformer instance = new Hibernate51CompatibilityTransformer();
    private static final File showTransformedClassFolder;
    public static final BasicLogger logger;
    private static final boolean useASMExperimental;
    private static final String markerAlreadyTransformed = "$_org_jboss_as_hibernate_Hibernate51CompatibilityTransformer_transformed_$";

    public static Hibernate51CompatibilityTransformer getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(final ClassLoader loader, final String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        ClassWriter classWriter;
        logger.debugf("Hibernate51CompatibilityTransformer transforming deployment class '%s' from '%s'", (Object)className, (Object)Hibernate51CompatibilityTransformer.getModuleName(loader));
        final HashSet<String> parentClassesAndInterfaces = new HashSet<String>();
        this.collectClassesAndInterfaces(parentClassesAndInterfaces, loader, className);
        logger.tracef("Class %s extends or implements %s", (Object)className, parentClassesAndInterfaces);
        final TransformedState transformedState = new TransformedState();
        ClassReader classReader = new ClassReader(classfileBuffer);
        ClassWriter traceClassVisitor = classWriter = new ClassWriter(classReader, 0);
        PrintWriter tracePrintWriter = null;
        try {
            if (showTransformedClassFolder != null) {
                tracePrintWriter = new PrintWriter(new File(showTransformedClassFolder, className.replace('/', '_') + ".asm"));
                traceClassVisitor = new TraceClassVisitor((ClassVisitor)classWriter, tracePrintWriter);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            classReader.accept(new ClassVisitor(useASMExperimental ? 0x1070000 : 393216, (ClassVisitor)traceClassVisitor){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    transformedState.clear();
                    super.visit(version, access, name, signature, superName, interfaces);
                }

                public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                    if (Hibernate51CompatibilityTransformer.markerAlreadyTransformed.equals(name) && desc.equals("Z")) {
                        transformedState.setAlreadyTransformed(true);
                    }
                    return super.visitField(access, name, desc, signature, value);
                }

                public void visitEnd() {
                    if (transformedState.transformationsMade()) {
                        this.cv.visitField(9, Hibernate51CompatibilityTransformer.markerAlreadyTransformed, "Z", null, null).visitEnd();
                    }
                    super.visitEnd();
                }

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    boolean rewriteSessionImplementor = false;
                    logger.tracef("method %s, description %s, signature %s", (Object)name, (Object)desc, (Object)signature);
                    if (parentClassesAndInterfaces.contains("org/hibernate/usertype/UserType")) {
                        if (name.equals("nullSafeGet") && "(Ljava/sql/ResultSet;[Ljava/lang/String;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("nullSafeSet") && "(Ljava/sql/PreparedStatement;Ljava/lang/Object;ILorg/hibernate/engine/spi/SessionImplementor;)V".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        }
                        transformedState.setClassTransformed(true);
                        rewriteSessionImplementor = true;
                    }
                    if (parentClassesAndInterfaces.contains("org/hibernate/usertype/CompositeUserType")) {
                        if (name.equals("nullSafeGet") && "(Ljava/sql/ResultSet;[Ljava/lang/String;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("nullSafeSet") && "(Ljava/sql/PreparedStatement;Ljava/lang/Object;ILorg/hibernate/engine/spi/SessionImplementor;)V".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("assemble") && "(Ljava/io/Serializable;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("disassemble") && "(Ljava/lang/Object;Lorg/hibernate/engine/spi/SessionImplementor;)Ljava/io/Serializable;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("replace") && "(Ljava/lang/Object;Ljava/lang/Object;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        }
                        transformedState.setClassTransformed(true);
                        rewriteSessionImplementor = true;
                    }
                    if (parentClassesAndInterfaces.contains("org/hibernate/usertype/UserCollectionType")) {
                        if (name.equals("instantiate") && "(Lorg/hibernate/engine/spi/SessionImplementor;Lorg/hibernate/persister/collection/CollectionPersister;)Lorg/hibernate/collection/spi/PersistentCollection;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("replaceElements") && "(Ljava/lang/Object;Ljava/lang/Object;Lorg/hibernate/persister/collection/CollectionPersister;Ljava/lang/Object;Ljava/util/Map;Lorg/hibernate/engine/spi/SessionImplementor;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("wrap") && "(Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;)Lorg/hibernate/collection/spi/PersistentCollection;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        }
                        transformedState.setClassTransformed(true);
                        rewriteSessionImplementor = true;
                    }
                    if (parentClassesAndInterfaces.contains("org/hibernate/usertype/UserVersionType")) {
                        if (name.equals("seed") && "(Lorg/hibernate/engine/spi/SessionImplementor;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("next") && "(Ljava/lang/Object;Lorg/hibernate/engine/spi/SessionImplementor;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        }
                        transformedState.setClassTransformed(true);
                        rewriteSessionImplementor = true;
                    }
                    if (parentClassesAndInterfaces.contains("org/hibernate/type/Type")) {
                        if (name.equals("assemble") && "(Ljava/io/Serializable;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("disassemble") && "(Ljava/lang/Object;Lorg/hibernate/engine/spi/SessionImplementor;)Ljava/io/Serializable;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("beforeAssemble") && "(Ljava/io/Serializable;Lorg/hibernate/engine/spi/SessionImplementor;)V".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("hydrate") && "(Ljava/sql/ResultSet;[Ljava/lang/String;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("isDirty") && "(Ljava/lang/Object;Ljava/lang/Object;Lorg/hibernate/engine/spi/SessionImplementor;)Z".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("isDirty") && "(Ljava/lang/Object;Ljava/lang/Object;[ZLorg/hibernate/engine/spi/SessionImplementor;)Z".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("isModified") && "(Ljava/lang/Object;Ljava/lang/Object;[ZLorg/hibernate/engine/spi/SessionImplementor;)Z".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("nullSafeGet") && "(Ljava/sql/ResultSet;[Ljava/lang/String;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("nullSafeGet") && "(Ljava/sql/ResultSet;Ljava/lang/String;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("nullSafeSet") && "(Ljava/sql/PreparedStatement;Ljava/lang/Object;I[ZLorg/hibernate/engine/spi/SessionImplementor;)V".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("nullSafeSet") && "(Ljava/sql/PreparedStatement;Ljava/lang/Object;ILorg/hibernate/engine/spi/SessionImplementor;)V".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("replace") && "(Ljava/lang/Object;Ljava/lang/Object;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;Ljava/util/Map;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("replace") && "(Ljava/lang/Object;Ljava/lang/Object;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;Ljava/util/Map;Lorg/hibernate/type/ForeignKeyDirection;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("resolve") && "(Ljava/lang/Object;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("resolve") && "(Ljava/lang/Object;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;Ljava/lang/Boolean;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("semiResolve") && "(Ljava/lang/Object;Lorg/hibernate/engine/spi/SessionImplementor;Ljava/lang/Object;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        }
                        transformedState.setClassTransformed(true);
                        rewriteSessionImplementor = true;
                    }
                    if (parentClassesAndInterfaces.contains("org/hibernate/type/SingleColumnType")) {
                        if (name.equals("nullSafeGet") && "(Ljava/sql/ResultSet;Ljava/lang/String;Lorg/hibernate/engine/spi/SessionImplementor;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("get") && "(Ljava/sql/ResultSet;Ljava/lang/String;Lorg/hibernate/engine/spi/SessionImplementor;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("set") && "(Ljava/sql/PreparedStatement;Ljava/lang/Object;ILorg/hibernate/engine/spi/SessionImplementor;)V".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        }
                        transformedState.setClassTransformed(true);
                        rewriteSessionImplementor = true;
                    }
                    if (parentClassesAndInterfaces.contains("org/hibernate/type/AbstractStandardBasicType")) {
                        if (name.equals("get") && "(Ljava/sql/ResultSet;Ljava/lang/String;Lorg/hibernate/engine/spi/SessionImplementor;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("nullSafeGet") && "(Ljava/sql/ResultSet;Ljava/lang/String;Lorg/hibernate/engine/spi/SessionImplementor;)Ljava/lang/Object;".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("set") && "(Ljava/sql/PreparedStatement;Ljava/lang/Object;ILorg/hibernate/engine/spi/SessionImplementor;)V".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        }
                        transformedState.setClassTransformed(true);
                        rewriteSessionImplementor = true;
                    }
                    if (parentClassesAndInterfaces.contains("org/hibernate/type/ProcedureParameterExtractionAware")) {
                        if (name.equals("extract") && (desc.startsWith("(Ljava/sql/CallableStatement;ILorg/hibernate/engine/spi/SessionImplementor;)") || desc.startsWith("(Ljava/sql/CallableStatement;[Ljava/lang/String;Lorg/hibernate/engine/spi/SessionImplementor;)"))) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                            transformedState.setClassTransformed(true);
                        }
                        rewriteSessionImplementor = true;
                    }
                    if (parentClassesAndInterfaces.contains("org/hibernate/type/ProcedureParameterNamedBinder")) {
                        if (name.equals("nullSafeSet") && "(Ljava/sql/CallableStatement;Ljava/lang/Object;Ljava/lang/String;Lorg/hibernate/engine/spi/SessionImplementor;)V".equals(desc)) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                            transformedState.setClassTransformed(true);
                        }
                        rewriteSessionImplementor = true;
                    }
                    if (parentClassesAndInterfaces.contains("org/hibernate/type/VersionType")) {
                        if (name.equals("seed") && desc.startsWith("(Lorg/hibernate/engine/spi/SessionImplementor;)")) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("next") && desc.contains("Lorg/hibernate/engine/spi/SessionImplementor;")) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                            transformedState.setClassTransformed(true);
                        }
                        rewriteSessionImplementor = true;
                    }
                    if (parentClassesAndInterfaces.contains("org/hibernate/collection/spi/PersistentCollection")) {
                        if (name.equals("unsetSession") && desc.equals("(Lorg/hibernate/engine/spi/SessionImplementor;)Z")) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        } else if (name.equals("setCurrentSession") && desc.equals("(Lorg/hibernate/engine/spi/SessionImplementor;)Z")) {
                            desc = Hibernate51CompatibilityTransformer.replaceSessionImplementor(desc);
                        }
                        rewriteSessionImplementor = true;
                    }
                    return new MethodAdapter(rewriteSessionImplementor, 393216, super.visitMethod(access, name, desc, signature, exceptions), Hibernate51CompatibilityTransformer.getModuleName(loader), className, transformedState);
                }
            }, 0);
            if (!transformedState.transformationsMade()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = classWriter.toByteArray();
            return byArray;
        }
        finally {
            if (tracePrintWriter != null) {
                tracePrintWriter.close();
            }
        }
    }

    private static String getModuleName(ClassLoader loader) {
        if (loader == null) {
            return "(null)";
        }
        if (loader instanceof ModuleClassLoader) {
            return ((ModuleClassLoader)loader).getName();
        }
        return loader.toString();
    }

    private static String replaceSessionImplementor(String desc) {
        return desc.replace("Lorg/hibernate/engine/spi/SessionImplementor;", "Lorg/hibernate/engine/spi/SharedSessionContractImplementor;");
    }

    private void collectClassesAndInterfaces(final Set<String> classesAndInterfaces, final ClassLoader classLoader, String className) {
        if (className == null || "java/lang/Object".equals(className)) {
            return;
        }
        try (InputStream is = classLoader.getResourceAsStream(className.replace('.', '/') + ".class");){
            ClassReader classReader = new ClassReader(is);
            classReader.accept(new ClassVisitor(useASMExperimental ? 0x1070000 : 393216){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    if (interfaces != null) {
                        for (String interfaceName : interfaces) {
                            classesAndInterfaces.add(interfaceName);
                            Hibernate51CompatibilityTransformer.this.collectClassesAndInterfaces(classesAndInterfaces, classLoader, interfaceName);
                        }
                    }
                    classesAndInterfaces.add(superName);
                    Hibernate51CompatibilityTransformer.this.collectClassesAndInterfaces(classesAndInterfaces, classLoader, superName);
                }

                public void visitInnerClass(String name, String outerName, String innerName, int access) {
                    if (innerName != null) {
                        classesAndInterfaces.add(innerName);
                    }
                }
            }, 0);
        }
        catch (IOException e) {
            logger.warn("Unable to open class file %1$s", (Object)className, (Throwable)e);
        }
    }

    private static int getMajorJavaVersion() {
        Matcher matcher;
        int major = 8;
        String version = WildFlySecurityManager.getPropertyPrivileged((String)"java.specification.version", null);
        if (version != null && (matcher = Pattern.compile("^(?:1\\.)?(\\d+)$").matcher(version)).find()) {
            major = Integer.valueOf(matcher.group(1));
        }
        return major;
    }

    static {
        logger = Logger.getLogger((String)"org.jboss.as.hibernate.transformer");
        String folderName = WildFlySecurityManager.getPropertyPrivileged((String)"Hibernate51CompatibilityTransformer.showTransformedClassFolder", null);
        showTransformedClassFolder = folderName != null ? new File(folderName) : null;
        useASMExperimental = Hibernate51CompatibilityTransformer.getMajorJavaVersion() >= 11;
    }
}

