/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.samplers;

import io.jaegertracing.internal.samplers.SamplingStatus;
import io.jaegertracing.spi.Sampler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ProbabilisticSampler
implements Sampler {
    public static final double DEFAULT_SAMPLING_PROBABILITY = 0.001;
    public static final String TYPE = "probabilistic";
    private final long positiveSamplingBoundary;
    private final long negativeSamplingBoundary;
    private final double samplingRate;
    private final Map<String, Object> tags;

    public ProbabilisticSampler(double samplingRate) {
        if (samplingRate < 0.0 || samplingRate > 1.0) {
            throw new IllegalArgumentException("The sampling rate must be greater than 0.0 and less than 1.0");
        }
        this.samplingRate = samplingRate;
        this.positiveSamplingBoundary = (long)(9.223372036854776E18 * samplingRate);
        this.negativeSamplingBoundary = (long)(-9.223372036854776E18 * samplingRate);
        HashMap<String, Object> tags = new HashMap<String, Object>();
        tags.put("sampler.type", TYPE);
        tags.put("sampler.param", samplingRate);
        this.tags = Collections.unmodifiableMap(tags);
    }

    @Override
    public SamplingStatus sample(String operation, long id) {
        if (id > 0L) {
            return SamplingStatus.of(id <= this.positiveSamplingBoundary, this.tags);
        }
        return SamplingStatus.of(id >= this.negativeSamplingBoundary, this.tags);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ProbabilisticSampler) {
            return this.samplingRate == ((ProbabilisticSampler)other).samplingRate;
        }
        return false;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "ProbabilisticSampler(positiveSamplingBoundary=" + this.positiveSamplingBoundary + ", negativeSamplingBoundary=" + this.negativeSamplingBoundary + ", samplingRate=" + this.getSamplingRate() + ", tags=" + this.tags + ")";
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }
}

