/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import org.jgroups.Address;
import org.jgroups.SuspectedException;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.UnicastRequest;
import org.jgroups.util.Buffer;
import org.wildfly.clustering.dispatcher.CommandDispatcherException;
import org.wildfly.clustering.server.dispatcher.NoSuchService;

public class ServiceRequest<T>
extends UnicastRequest<T> {
    public ServiceRequest(RequestCorrelator correlator, Address target, RequestOptions options) {
        super(correlator, target, options);
    }

    public CompletionStage<T> send(Buffer data) throws CommandDispatcherException {
        try {
            this.sendRequest(data);
            return this;
        }
        catch (Exception e) {
            throw new CommandDispatcherException((Throwable)e);
        }
    }

    public void receiveResponse(Object value, Address sender, boolean exceptional) {
        if (this.isDone()) {
            return;
        }
        if (exceptional) {
            this.completeExceptionally((Throwable)value);
        } else if (value instanceof NoSuchService) {
            this.completeExceptionally(new CancellationException());
        } else {
            this.complete(value);
        }
        this.corrDone();
    }

    public boolean completeExceptionally(Throwable exception) {
        return super.completeExceptionally(exception instanceof SuspectedException ? new CancellationException() : exception);
    }
}

