/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.datasources.agroal;

import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.datasources.agroal.AbstractDataSourceDefinition;
import org.wildfly.extension.datasources.agroal.AbstractDataSourceOperations;
import org.wildfly.extension.datasources.agroal.AgroalExtension;
import org.wildfly.extension.datasources.agroal.DataSourceDefinition;
import org.wildfly.extension.datasources.agroal.DataSourceService;
import org.wildfly.extension.datasources.agroal.DriverOperations;

class DataSourceOperations {
    static final String DATASOURCE_SERVICE_NAME = "datasource";
    static final ServiceName DATASOURCE_SERVICE_PREFIX = AgroalExtension.BASE_SERVICE_NAME.append(new String[]{"datasource"});
    static final OperationStepHandler ADD_OPERATION = new DataSourceAdd();
    static final OperationStepHandler REMOVE_OPERATION = new DataSourceRemove();

    DataSourceOperations() {
    }

    private static class DataSourceRemove
    extends AbstractRemoveStepHandler {
        private DataSourceRemove() {
            super(new RuntimeCapability[]{DataSourceDefinition.DATA_SOURCE_CAPABILITY});
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String datasourceName = context.getCurrentAddressValue();
            ServiceName datasourceServiceName = ServiceName.of((ServiceName)DATASOURCE_SERVICE_PREFIX, (String[])new String[]{datasourceName});
            context.removeService(datasourceServiceName);
        }
    }

    private static class DataSourceAdd
    extends AbstractAddStepHandler {
        private DataSourceAdd() {
            super(DataSourceDefinition.DATA_SOURCE_CAPABILITY, DataSourceDefinition.ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String datasourceName = context.getCurrentAddressValue();
            ModelNode factoryModel = AbstractDataSourceDefinition.CONNECTION_FACTORY_ATTRIBUTE.resolveModelAttribute(context, model);
            AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration = AbstractDataSourceOperations.connectionFactoryConfiguration(context, factoryModel);
            ModelNode poolModel = AbstractDataSourceDefinition.CONNECTION_POOL_ATTRIBUTE.resolveModelAttribute(context, model);
            AgroalConnectionPoolConfigurationSupplier connectionPoolConfiguration = AbstractDataSourceOperations.connectionPoolConfiguration(context, poolModel);
            connectionPoolConfiguration.connectionFactoryConfiguration((Supplier)connectionFactoryConfiguration);
            AgroalDataSourceConfigurationSupplier dataSourceConfiguration = new AgroalDataSourceConfigurationSupplier();
            dataSourceConfiguration.connectionPoolConfiguration((Supplier)connectionPoolConfiguration);
            dataSourceConfiguration.metricsEnabled(AbstractDataSourceDefinition.STATISTICS_ENABLED_ATTRIBUTE.resolveModelAttribute(context, model).asBoolean());
            String jndiName = AbstractDataSourceDefinition.JNDI_NAME_ATTRIBUTE.resolveModelAttribute(context, model).asString();
            boolean jta = DataSourceDefinition.JTA_ATTRIBUTE.resolveModelAttribute(context, model).asBoolean();
            boolean connectable = DataSourceDefinition.CONNECTABLE_ATTRIBUTE.resolveModelAttribute(context, model).asBoolean();
            String driverName = AbstractDataSourceDefinition.DRIVER_ATTRIBUTE.resolveModelAttribute(context, factoryModel).asString();
            DataSourceService dataSourceService = new DataSourceService(datasourceName, jndiName, jta, connectable, false, dataSourceConfiguration);
            ServiceBuilder serviceBuilder = context.getServiceTarget().addService(DATASOURCE_SERVICE_PREFIX.append(new String[]{datasourceName}), (Service)dataSourceService);
            AbstractDataSourceOperations.setupElytronSecurity(context, factoryModel, dataSourceService, serviceBuilder);
            serviceBuilder.addDependency(DriverOperations.DRIVER_SERVICE_PREFIX.append(new String[]{driverName}), Class.class, dataSourceService.getDriverInjector());
            serviceBuilder.install();
        }
    }
}

