/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.datasources.agroal.logging;

import io.agroal.api.AgroalDataSource;
import java.sql.SQLException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYAG", length=4)
public interface AgroalLogger
extends BasicLogger {
    public static final DriverLogger DRIVER_LOGGER = (DriverLogger)Logger.getMessageLogger(DriverLogger.class, (String)"org.wildfly.extension.datasources.agroal.driver");
    public static final AgroalLogger SERVICE_LOGGER = (AgroalLogger)Logger.getMessageLogger(AgroalLogger.class, (String)"org.wildfly.extension.datasources.agroal");
    public static final PoolLogger POOL_LOGGER = (PoolLogger)Logger.getMessageLogger(PoolLogger.class, (String)"io.agroal.pool");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Adding deployment processors for DataSourceDefinition annotation and resource-ref entries")
    public void addingDeploymentProcessors();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=101, value="Started datasource '%s' bound to [%s]")
    public void startedDataSource(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=102, value="Stopped datasource '%s'")
    public void stoppedDataSource(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=103, value="Started xa-datasource '%s' bound to [%s]")
    public void startedXADataSource(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=104, value="Stopped xa-datasource '%s'")
    public void stoppedXADataSource(String var1);

    @Message(id=105, value="Exception starting datasource '%s'")
    public StartException datasourceStartException(@Cause SQLException var1, String var2);

    @Message(id=106, value="Exception starting xa-datasource '%s'")
    public StartException xaDatasourceStartException(@Cause SQLException var1, String var2);

    @Message(id=107, value="Invalid connection provider. Either a java.sql.Driver or javax.sql.DataSource implementation is required. Fix the connection-provider for the driver")
    public StartException invalidConnectionProvider();

    @Message(id=108, value="An xa-datasource requires a javax.sql.XADataSource as connection provider. Fix the connection-provider for the driver")
    public StartException invalidXAConnectionProvider();

    @Message(id=109, value="Could not start datasource: transaction manager is missing")
    public StartException missingTransactionManager();

    @Message(id=110, value="Error obtaining credentials from authentication context for datasource '%s'")
    public StartException invalidAuthentication(@Cause Throwable var1, String var2);

    @Message(id=111, value="CredentialSourceSupplier for datasource '%s' is invalid")
    public StartException invalidCredentialSourceSupplier(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=201, value="Performing flush operation, mode %s")
    public void flushOperation(AgroalDataSource.FlushMode var1);

    @Message(id=301, value="Unknown datasource service of type: %s")
    public OperationFailedException unknownDatasourceServiceType(String var1);

    @Message(id=302, value="Invalid connection in '%s'")
    public OperationFailedException invalidConnection(@Cause SQLException var1, String var2);

    @Message(id=303, value="JNDI name have to start with java:/ or java:jboss/")
    public OperationFailedException jndiNameInvalidFormat();

    @Message(id=304, value="JNDI name shouldn't include '//' or end with '/'")
    public OperationFailedException jndiNameShouldValidate();

    @Message(id=401, value="Invalid connection provider. Either a java.sql.Driver or javax.sql.DataSource implementation is required. Fix the connection-provider for the driver")
    public DeploymentUnitProcessingException invalidDeploymentConnectionProvider();

    @Message(id=203, value="Failed to load connection provider class '%s'")
    public DeploymentUnitProcessingException loadClassDeploymentException(@Cause Throwable var1, String var2);

    @MessageLogger(projectCode="AGROAL", length=4)
    public static interface PoolLogger
    extends BasicLogger {
        @LogMessage(level=Logger.Level.WARN)
        @Message(id=1, value="%s: %s")
        public void poolWarning(String var1, String var2);
    }

    @MessageLogger(projectCode="WFLYAG", length=4)
    public static interface DriverLogger
    extends BasicLogger {
        @LogMessage(level=Logger.Level.INFO)
        @Message(id=501, value="Loaded class %s for driver '%s'")
        public void driverLoaded(String var1, String var2);

        @Message(id=502, value="Failed to load driver module '%s'")
        public IllegalArgumentException loadModuleException(@Cause Throwable var1, String var2);

        @Message(id=503, value="Failed to load driver class '%s'")
        public IllegalArgumentException loadClassException(@Cause Throwable var1, String var2);
    }
}

