/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.registry.classloading.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.boot.registry.classloading.internal.TcclLookupPrecedence;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class ClassLoaderServiceImpl
implements ClassLoaderService {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(ClassLoaderServiceImpl.class);
    private final ConcurrentMap<Class, ServiceLoader> serviceLoaders = new ConcurrentHashMap<Class, ServiceLoader>();
    private volatile AggregatedClassLoader aggregatedClassLoader;

    public ClassLoaderServiceImpl() {
        this(ClassLoaderServiceImpl.class.getClassLoader());
    }

    public ClassLoaderServiceImpl(ClassLoader classLoader) {
        this(Collections.singletonList(classLoader), TcclLookupPrecedence.AFTER);
    }

    public ClassLoaderServiceImpl(Collection<ClassLoader> providedClassLoaders, final TcclLookupPrecedence lookupPrecedence) {
        final LinkedHashSet<ClassLoader> orderedClassLoaderSet = new LinkedHashSet<ClassLoader>();
        if (providedClassLoaders != null) {
            for (ClassLoader classLoader : providedClassLoaders) {
                if (classLoader == null) continue;
                orderedClassLoaderSet.add(classLoader);
            }
        }
        orderedClassLoaderSet.add(ClassLoaderServiceImpl.class.getClassLoader());
        PrivilegedAction<AggregatedClassLoader> action = new PrivilegedAction<AggregatedClassLoader>(){

            @Override
            public AggregatedClassLoader run() {
                return new AggregatedClassLoader(orderedClassLoaderSet, lookupPrecedence);
            }
        };
        this.aggregatedClassLoader = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : (AggregatedClassLoader)action.run();
    }

    @Deprecated
    public static ClassLoaderServiceImpl fromConfigSettings(Map configValues) {
        ArrayList<ClassLoader> providedClassLoaders = new ArrayList<ClassLoader>();
        Collection classLoaders = (Collection)configValues.get("hibernate.classLoaders");
        if (classLoaders != null) {
            for (ClassLoader classLoader : classLoaders) {
                providedClassLoaders.add(classLoader);
            }
        }
        ClassLoaderServiceImpl.addIfSet(providedClassLoaders, "hibernate.classLoader.application", configValues);
        ClassLoaderServiceImpl.addIfSet(providedClassLoaders, "hibernate.classLoader.resources", configValues);
        ClassLoaderServiceImpl.addIfSet(providedClassLoaders, "hibernate.classLoader.hibernate", configValues);
        ClassLoaderServiceImpl.addIfSet(providedClassLoaders, "hibernate.classLoader.environment", configValues);
        return new ClassLoaderServiceImpl(providedClassLoaders, TcclLookupPrecedence.AFTER);
    }

    private static void addIfSet(List<ClassLoader> providedClassLoaders, String name, Map configVales) {
        ClassLoader providedClassLoader = (ClassLoader)configVales.get(name);
        if (providedClassLoader != null) {
            providedClassLoaders.add(providedClassLoader);
        }
    }

    private static ClassLoader locateSystemClassLoader() {
        try {
            return ClassLoader.getSystemClassLoader();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ClassLoader locateTCCL() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <T> Class<T> classForName(final String className) {
        PrivilegedAction action = new PrivilegedAction<Class<T>>(){

            @Override
            public Class<T> run() {
                try {
                    return Class.forName(className, true, ClassLoaderServiceImpl.this.getAggregatedClassLoader());
                }
                catch (Exception e) {
                    throw new ClassLoadingException("Unable to load class [" + className + "]", e);
                }
                catch (LinkageError e) {
                    throw new ClassLoadingException("Unable to load class [" + className + "]", e);
                }
            }
        };
        return System.getSecurityManager() != null ? (Class)AccessController.doPrivileged(action) : (Class)action.run();
    }

    @Override
    public URL locateResource(final String name) {
        PrivilegedAction<URL> action = new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                try {
                    return new URL(name);
                }
                catch (Exception exception) {
                    try {
                        URL url = ClassLoaderServiceImpl.this.getAggregatedClassLoader().getResource(name);
                        if (url != null) {
                            return url;
                        }
                    }
                    catch (Exception url) {
                        // empty catch block
                    }
                    if (name.startsWith("/")) {
                        String resourceName = name.substring(1);
                        try {
                            URL url = ClassLoaderServiceImpl.this.getAggregatedClassLoader().getResource(resourceName);
                            if (url != null) {
                                return url;
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }
        };
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : (URL)action.run();
    }

    @Override
    public InputStream locateResourceStream(String name) {
        try {
            log.tracef("trying via [new URL(\"%s\")]", name);
            return new URL(name).openStream();
        }
        catch (Exception exception) {
            String stripped;
            try {
                log.tracef("trying via [ClassLoader.getResourceAsStream(\"%s\")]", name);
                InputStream stream = this.getAggregatedClassLoader().getResourceAsStream(name);
                if (stream != null) {
                    return stream;
                }
            }
            catch (Exception stream) {
                // empty catch block
            }
            String string = stripped = name.startsWith("/") ? name.substring(1) : null;
            if (stripped != null) {
                try {
                    log.tracef("trying via [new URL(\"%s\")]", stripped);
                    return new URL(stripped).openStream();
                }
                catch (Exception exception2) {
                    try {
                        log.tracef("trying via [ClassLoader.getResourceAsStream(\"%s\")]", stripped);
                        InputStream stream = this.getAggregatedClassLoader().getResourceAsStream(stripped);
                        if (stream != null) {
                            return stream;
                        }
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
    }

    @Override
    public List<URL> locateResources(String name) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            Enumeration<URL> urlEnumeration = this.getAggregatedClassLoader().getResources(name);
            if (urlEnumeration != null && urlEnumeration.hasMoreElements()) {
                while (urlEnumeration.hasMoreElements()) {
                    urls.add(urlEnumeration.nextElement());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }

    @Override
    public <S> Collection<S> loadJavaServices(final Class<S> serviceContract) {
        PrivilegedAction action = new PrivilegedAction<Collection<S>>(){

            @Override
            public Collection<S> run() {
                ServiceLoader serviceLoader = (ServiceLoader)ClassLoaderServiceImpl.this.serviceLoaders.get(serviceContract);
                if (serviceLoader == null) {
                    serviceLoader = ServiceLoader.load(serviceContract, ClassLoaderServiceImpl.this.getAggregatedClassLoader());
                    ClassLoaderServiceImpl.this.serviceLoaders.put(serviceContract, serviceLoader);
                }
                LinkedHashSet services = new LinkedHashSet();
                for (Object service : serviceLoader) {
                    services.add(service);
                }
                return services;
            }
        };
        return System.getSecurityManager() != null ? (Collection)AccessController.doPrivileged(action) : (Collection)action.run();
    }

    @Override
    public <T> T generateProxy(InvocationHandler handler, Class ... interfaces) {
        return (T)Proxy.newProxyInstance(this.getAggregatedClassLoader(), interfaces, handler);
    }

    @Override
    public <T> T workWithClassLoader(final ClassLoaderService.Work<T> work) {
        PrivilegedAction action = new PrivilegedAction<T>(){

            @Override
            public T run() {
                return work.doWork(ClassLoaderServiceImpl.this.getAggregatedClassLoader());
            }
        };
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private ClassLoader getAggregatedClassLoader() {
        AggregatedClassLoader aggregated = this.aggregatedClassLoader;
        if (aggregated == null) {
            throw log.usingStoppedClassLoaderService();
        }
        return aggregated;
    }

    @Override
    public void stop() {
        for (ServiceLoader serviceLoader : this.serviceLoaders.values()) {
            serviceLoader.reload();
        }
        this.serviceLoaders.clear();
        this.aggregatedClassLoader = null;
    }

    private static class AggregatedClassLoader
    extends ClassLoader {
        private final ClassLoader[] individualClassLoaders;
        private final TcclLookupPrecedence tcclLookupPrecedence;

        private AggregatedClassLoader(LinkedHashSet<ClassLoader> orderedClassLoaderSet, TcclLookupPrecedence precedence) {
            super(null);
            this.individualClassLoaders = orderedClassLoaderSet.toArray(new ClassLoader[orderedClassLoaderSet.size()]);
            this.tcclLookupPrecedence = precedence;
        }

        private Iterator<ClassLoader> newClassLoaderIterator() {
            ClassLoader threadClassLoader = ClassLoaderServiceImpl.locateTCCL();
            if (this.tcclLookupPrecedence == TcclLookupPrecedence.NEVER || threadClassLoader == null) {
                return this.newTcclNeverIterator();
            }
            if (this.tcclLookupPrecedence == TcclLookupPrecedence.AFTER) {
                return this.newTcclAfterIterator(threadClassLoader);
            }
            if (this.tcclLookupPrecedence == TcclLookupPrecedence.BEFORE) {
                return this.newTcclBeforeIterator(threadClassLoader);
            }
            throw new RuntimeException("Unknown precedence: " + (Object)((Object)this.tcclLookupPrecedence));
        }

        private Iterator<ClassLoader> newTcclBeforeIterator(final ClassLoader threadContextClassLoader) {
            final ClassLoader systemClassLoader = ClassLoaderServiceImpl.locateSystemClassLoader();
            return new Iterator<ClassLoader>(){
                private int currentIndex = 0;
                private boolean tcCLReturned = false;
                private boolean sysCLReturned = false;

                @Override
                public boolean hasNext() {
                    if (!this.tcCLReturned) {
                        return true;
                    }
                    if (this.currentIndex < individualClassLoaders.length) {
                        return true;
                    }
                    return !this.sysCLReturned && systemClassLoader != null;
                }

                @Override
                public ClassLoader next() {
                    if (!this.tcCLReturned) {
                        this.tcCLReturned = true;
                        return threadContextClassLoader;
                    }
                    if (this.currentIndex < individualClassLoaders.length) {
                        ++this.currentIndex;
                        return individualClassLoaders[this.currentIndex - 1];
                    }
                    if (!this.sysCLReturned && systemClassLoader != null) {
                        this.sysCLReturned = true;
                        return systemClassLoader;
                    }
                    throw new IllegalStateException("No more item");
                }
            };
        }

        private Iterator<ClassLoader> newTcclAfterIterator(final ClassLoader threadContextClassLoader) {
            final ClassLoader systemClassLoader = ClassLoaderServiceImpl.locateSystemClassLoader();
            return new Iterator<ClassLoader>(){
                private int currentIndex = 0;
                private boolean tcCLReturned = false;
                private boolean sysCLReturned = false;

                @Override
                public boolean hasNext() {
                    if (this.currentIndex < individualClassLoaders.length) {
                        return true;
                    }
                    if (!this.tcCLReturned) {
                        return true;
                    }
                    return !this.sysCLReturned && systemClassLoader != null;
                }

                @Override
                public ClassLoader next() {
                    if (this.currentIndex < individualClassLoaders.length) {
                        ++this.currentIndex;
                        return individualClassLoaders[this.currentIndex - 1];
                    }
                    if (!this.tcCLReturned) {
                        this.tcCLReturned = true;
                        return threadContextClassLoader;
                    }
                    if (!this.sysCLReturned && systemClassLoader != null) {
                        this.sysCLReturned = true;
                        return systemClassLoader;
                    }
                    throw new IllegalStateException("No more item");
                }
            };
        }

        private Iterator<ClassLoader> newTcclNeverIterator() {
            final ClassLoader systemClassLoader = ClassLoaderServiceImpl.locateSystemClassLoader();
            return new Iterator<ClassLoader>(){
                private int currentIndex = 0;
                private boolean sysCLReturned = false;

                @Override
                public boolean hasNext() {
                    if (this.currentIndex < individualClassLoaders.length) {
                        return true;
                    }
                    return !this.sysCLReturned && systemClassLoader != null;
                }

                @Override
                public ClassLoader next() {
                    if (this.currentIndex < individualClassLoaders.length) {
                        ++this.currentIndex;
                        return individualClassLoaders[this.currentIndex - 1];
                    }
                    if (!this.sysCLReturned && systemClassLoader != null) {
                        this.sysCLReturned = true;
                        return systemClassLoader;
                    }
                    throw new IllegalStateException("No more item");
                }
            };
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final LinkedHashSet<URL> resourceUrls = new LinkedHashSet<URL>();
            Iterator<ClassLoader> clIterator = this.newClassLoaderIterator();
            while (clIterator.hasNext()) {
                ClassLoader classLoader = clIterator.next();
                Enumeration<URL> urls = classLoader.getResources(name);
                while (urls.hasMoreElements()) {
                    resourceUrls.add(urls.nextElement());
                }
            }
            return new Enumeration<URL>(){
                final Iterator<URL> resourceUrlIterator;
                {
                    this.resourceUrlIterator = resourceUrls.iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.resourceUrlIterator.hasNext();
                }

                @Override
                public URL nextElement() {
                    return this.resourceUrlIterator.next();
                }
            };
        }

        @Override
        protected URL findResource(String name) {
            Iterator<ClassLoader> clIterator = this.newClassLoaderIterator();
            while (clIterator.hasNext()) {
                ClassLoader classLoader = clIterator.next();
                URL resource = classLoader.getResource(name);
                if (resource == null) continue;
                return resource;
            }
            return super.findResource(name);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Iterator<ClassLoader> clIterator = this.newClassLoaderIterator();
            while (clIterator.hasNext()) {
                ClassLoader classLoader = clIterator.next();
                try {
                    return classLoader.loadClass(name);
                }
                catch (Exception exception) {
                }
                catch (LinkageError linkageError) {
                }
            }
            throw new ClassNotFoundException("Could not load requested class : " + name);
        }
    }
}

