/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.vendor.org.apache.http.client.methods;

import io.jaegertracing.vendor.org.apache.http.Header;
import io.jaegertracing.vendor.org.apache.http.HeaderElement;
import io.jaegertracing.vendor.org.apache.http.HeaderIterator;
import io.jaegertracing.vendor.org.apache.http.HttpResponse;
import io.jaegertracing.vendor.org.apache.http.annotation.NotThreadSafe;
import io.jaegertracing.vendor.org.apache.http.client.methods.HttpRequestBase;
import io.jaegertracing.vendor.org.apache.http.util.Args;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

@NotThreadSafe
public class HttpOptions
extends HttpRequestBase {
    public static final String METHOD_NAME = "OPTIONS";

    public HttpOptions() {
    }

    public HttpOptions(URI uri) {
        this.setURI(uri);
    }

    public HttpOptions(String uri) {
        this.setURI(URI.create(uri));
    }

    @Override
    public String getMethod() {
        return METHOD_NAME;
    }

    public Set<String> getAllowedMethods(HttpResponse response) {
        Args.notNull(response, "HTTP response");
        HeaderIterator it = response.headerIterator("Allow");
        HashSet<String> methods = new HashSet<String>();
        while (it.hasNext()) {
            HeaderElement[] elements;
            Header header = it.nextHeader();
            for (HeaderElement element : elements = header.getElements()) {
                methods.add(element.getName());
            }
        }
        return methods;
    }
}

