/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.vendor.org.apache.http.client.protocol;

import io.jaegertracing.vendor.org.apache.http.HttpEntity;
import io.jaegertracing.vendor.org.apache.http.HttpEntityEnclosingRequest;
import io.jaegertracing.vendor.org.apache.http.HttpException;
import io.jaegertracing.vendor.org.apache.http.HttpRequest;
import io.jaegertracing.vendor.org.apache.http.HttpRequestInterceptor;
import io.jaegertracing.vendor.org.apache.http.HttpVersion;
import io.jaegertracing.vendor.org.apache.http.ProtocolVersion;
import io.jaegertracing.vendor.org.apache.http.annotation.Immutable;
import io.jaegertracing.vendor.org.apache.http.client.config.RequestConfig;
import io.jaegertracing.vendor.org.apache.http.client.protocol.HttpClientContext;
import io.jaegertracing.vendor.org.apache.http.protocol.HttpContext;
import io.jaegertracing.vendor.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

