/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.vendor.org.apache.http.impl.client;

import io.jaegertracing.vendor.org.apache.http.HeaderElement;
import io.jaegertracing.vendor.org.apache.http.HttpResponse;
import io.jaegertracing.vendor.org.apache.http.annotation.Immutable;
import io.jaegertracing.vendor.org.apache.http.conn.ConnectionKeepAliveStrategy;
import io.jaegertracing.vendor.org.apache.http.message.BasicHeaderElementIterator;
import io.jaegertracing.vendor.org.apache.http.protocol.HttpContext;
import io.jaegertracing.vendor.org.apache.http.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

