/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.vendor.org.apache.http.protocol;

import io.jaegertracing.vendor.org.apache.http.HttpEntityEnclosingRequest;
import io.jaegertracing.vendor.org.apache.http.HttpException;
import io.jaegertracing.vendor.org.apache.http.HttpRequest;
import io.jaegertracing.vendor.org.apache.http.HttpRequestInterceptor;
import io.jaegertracing.vendor.org.apache.http.annotation.ThreadSafe;
import io.jaegertracing.vendor.org.apache.http.protocol.HttpContext;
import io.jaegertracing.vendor.org.apache.http.protocol.HttpDateGenerator;
import io.jaegertracing.vendor.org.apache.http.util.Args;
import java.io.IOException;

@ThreadSafe
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

