/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.engine.impl.AnalyzerRegistry;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.query.dsl.EntityContext;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.dsl.impl.ConnectedQueryBuilder;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ConnectedQueryContextBuilder
implements QueryContextBuilder {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final ExtendedSearchIntegrator factory;

    public ConnectedQueryContextBuilder(ExtendedSearchIntegrator factory) {
        this.factory = factory;
    }

    @Override
    public EntityContext forEntity(Class<?> entityType) {
        PojoIndexedTypeIdentifier realtype = new PojoIndexedTypeIdentifier(entityType);
        return new HSearchEntityContext(realtype, this.factory);
    }

    public final class HSearchEntityContext
    implements EntityContext {
        private final IndexedTypeIdentifier indexBoundType;
        private final ScopedAnalyzerReference originalAnalyzerReference;
        private final ScopedAnalyzerReference.CopyBuilder queryAnalyzerReferenceBuilder;
        private final AnalyzerRegistry analyzerRegistry;

        public HSearchEntityContext(IndexedTypeIdentifier entityType, ExtendedSearchIntegrator factory) {
            this.indexBoundType = this.getIndexBoundType(entityType, factory);
            if (this.indexBoundType == null) {
                IndexedTypeSet configuredSubTypes = factory.getConfiguredTypesPolymorphic(entityType.asTypeSet());
                if (configuredSubTypes.isEmpty()) {
                    throw log.cantQueryUnconfiguredType(entityType.getName());
                }
                throw log.cantQueryUnindexedType(entityType.getName());
            }
            this.originalAnalyzerReference = factory.getAnalyzerReference(this.indexBoundType);
            this.queryAnalyzerReferenceBuilder = factory.getAnalyzerReference(this.indexBoundType).startCopy();
            IndexManagerType indexManagerType = factory.getIndexBinding(this.indexBoundType).getIndexManagerType();
            this.analyzerRegistry = factory.getIntegration(indexManagerType).getAnalyzerRegistry();
        }

        private IndexedTypeIdentifier getIndexBoundType(IndexedTypeIdentifier entityType, ExtendedSearchIntegrator factory) {
            if (factory.getIndexBinding(entityType) != null) {
                return entityType;
            }
            IndexedTypeSet indexedSubTypes = factory.getIndexedTypesPolymorphic(entityType.asTypeSet());
            if (!indexedSubTypes.isEmpty()) {
                return (IndexedTypeIdentifier)indexedSubTypes.iterator().next();
            }
            return null;
        }

        @Override
        public EntityContext overridesForField(String field, String analyzerName) {
            AnalyzerReference reference = this.analyzerRegistry.getAnalyzerReference(analyzerName);
            if (reference == null) {
                throw log.unknownAnalyzerForOverride(analyzerName);
            }
            this.queryAnalyzerReferenceBuilder.addAnalyzerReference(field, reference);
            return this;
        }

        @Override
        public QueryBuilder get() {
            return new ConnectedQueryBuilder(new QueryBuildingContext(ConnectedQueryContextBuilder.this.factory, this.originalAnalyzerReference, this.queryAnalyzerReferenceBuilder.build(), this.indexBoundType));
        }
    }
}

