/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.spi;

import java.lang.invoke.MethodHandles;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.SleepingLockWrapper;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DirectoryHelper {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());

    private DirectoryHelper() {
    }

    public static void initializeIndexIfNeeded(Directory directory) {
        try (SimpleAnalyzer analyzer = new SimpleAnalyzer();){
            if (!DirectoryReader.indexExists((Directory)directory)) {
                try {
                    IndexWriterConfig iwriterConfig = new IndexWriterConfig((Analyzer)analyzer).setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                    SleepingLockWrapper delayedDirectory = new SleepingLockWrapper(directory, 2000L, 20L);
                    IndexWriter iw = new IndexWriter((Directory)delayedDirectory, iwriterConfig);
                    iw.close();
                }
                catch (LockObtainFailedException lofe) {
                    log.lockingFailureDuringInitialization(directory.toString());
                }
            }
        }
    }

    public static Path getVerifiedIndexPath(String annotatedIndexName, Properties properties, boolean verifyIsWritable) {
        String indexBase = properties.getProperty("indexBase", ".");
        String indexName = properties.getProperty("indexName", annotatedIndexName);
        Path baseIndexDir = FileSystems.getDefault().getPath(indexBase, new String[0]);
        DirectoryProviderHelper.makeSanityCheckedDirectory(baseIndexDir, indexName, verifyIsWritable);
        Path indexDir = baseIndexDir.resolve(indexName);
        DirectoryProviderHelper.makeSanityCheckedDirectory(indexDir, indexName, verifyIsWritable);
        return indexDir;
    }
}

