/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive.contrib;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Foreach;
import org.apache.velocity.runtime.directive.MacroParseException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.Node;

public class For
extends Foreach {
    protected String counterName;
    protected int counterInitialValue;

    @Override
    public String getName() {
        return "for";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void init(RuntimeServices runtimeServices, InternalContextAdapter internalContextAdapter, Node node) throws TemplateInitException {
        super.init(runtimeServices, internalContextAdapter, node);
        if (node.jjtGetNumChildren() > 4) {
            this.counterName = ((ASTReference)node.jjtGetChild(4)).getRootString();
            this.counterInitialValue = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException {
        Object object = internalContextAdapter.get(this.counterName);
        internalContextAdapter.put(this.counterName, this.counterInitialValue);
        try {
            boolean bl = super.render(internalContextAdapter, writer, node);
            return bl;
        }
        finally {
            if (object != null) {
                internalContextAdapter.put(this.counterName, object);
            } else {
                internalContextAdapter.remove(this.counterName);
            }
        }
    }

    @Override
    protected void renderBlock(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException {
        Object object = internalContextAdapter.get(this.counterName);
        if (object instanceof Number) {
            internalContextAdapter.put(this.counterName, ((Number)object).intValue() + 1);
        }
        super.renderBlock(internalContextAdapter, writer, node);
    }

    @Override
    public void checkArgs(ArrayList<Integer> arrayList, Token token, String string) throws ParseException {
        super.checkArgs(arrayList, token, string);
        if (arrayList.size() > 3) {
            if (arrayList.get(3) != 11) {
                throw new MacroParseException("Expected word 'index' at argument position 4 in #foreach", string, token);
            }
            if (arrayList.size() == 4 || arrayList.get(4) != 20) {
                throw new MacroParseException("Expected a reference after 'index' in #foreach", string, token);
            }
        }
    }
}

