/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolLogger;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolMessageBundle;
import org.apache.activemq.artemis.core.protocol.stomp.FrameEventListener;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.StompPostReceiptFunction;
import org.apache.activemq.artemis.core.protocol.stomp.StompProtocolManager;
import org.apache.activemq.artemis.core.protocol.stomp.StompSession;
import org.apache.activemq.artemis.core.protocol.stomp.StompSubscription;
import org.apache.activemq.artemis.core.protocol.stomp.StompVersions;
import org.apache.activemq.artemis.core.protocol.stomp.VersionedStompFrameHandler;
import org.apache.activemq.artemis.core.protocol.stomp.v10.StompFrameHandlerV10;
import org.apache.activemq.artemis.core.protocol.stomp.v12.StompFrameHandlerV12;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.VersionLoader;

public final class StompConnection
implements RemotingConnection {
    protected static final String CONNECTION_ID_PROP = "__AMQ_CID";
    private static final String SERVER_NAME = "ActiveMQ-Artemis/" + VersionLoader.getVersion().getFullVersion() + " ActiveMQ Artemis Messaging Engine";
    private final StompProtocolManager manager;
    private final Connection transportConnection;
    private String login;
    private String passcode;
    private String clientID;
    private boolean valid;
    private boolean destroyed = false;
    private final long creationTime;
    private final Acceptor acceptorUsed;
    private final List<FailureListener> failureListeners = new CopyOnWriteArrayList<FailureListener>();
    private final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    private final Object failLock = new Object();
    private boolean dataReceived;
    private final boolean enableMessageID;
    private final int minLargeMessageSize;
    private StompVersions version;
    private VersionedStompFrameHandler frameHandler;
    private boolean initialized;
    private FrameEventListener stompListener;
    private final Object sendLock = new Object();
    private final ScheduledExecutorService scheduledExecutorService;
    private final ExecutorFactory factory;

    public boolean isSupportReconnect() {
        return false;
    }

    public VersionedStompFrameHandler getStompVersionHandler() {
        return this.frameHandler;
    }

    public void scheduledFlush() {
        this.flush();
    }

    public StompFrame decode(ActiveMQBuffer buffer) throws ActiveMQStompException {
        StompFrame frame = null;
        try {
            frame = this.frameHandler.decode(buffer);
        }
        catch (ActiveMQStompException e) {
            switch (e.getCode()) {
                case 1: {
                    if (this.version != null) {
                        throw e;
                    }
                    this.frameHandler = new StompFrameHandlerV12(this, this.scheduledExecutorService, this.factory);
                    buffer.resetReaderIndex();
                    frame = this.decode(buffer);
                    break;
                }
                case 2: 
                case 3: {
                    this.frameHandler.onError(e);
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        return frame;
    }

    public boolean isWritable(ReadyListener callback) {
        return this.transportConnection.isWritable(callback);
    }

    public boolean hasBytes() {
        return this.frameHandler.hasBytes();
    }

    StompConnection(Acceptor acceptorUsed, Connection transportConnection, StompProtocolManager manager, ScheduledExecutorService scheduledExecutorService, ExecutorFactory factory) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.factory = factory;
        this.transportConnection = transportConnection;
        this.manager = manager;
        this.frameHandler = new StompFrameHandlerV10(this, scheduledExecutorService, factory);
        this.creationTime = System.currentTimeMillis();
        this.acceptorUsed = acceptorUsed;
        this.enableMessageID = ConfigurationHelper.getBooleanProperty((String)"stomp-enable-message-id", (boolean)false, (Map)acceptorUsed.getConfiguration());
        this.minLargeMessageSize = ConfigurationHelper.getIntProperty((String)"stomp-min-large-message-size", (int)102400, (Map)acceptorUsed.getConfiguration());
    }

    public void addFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        this.failureListeners.add(listener);
    }

    public boolean removeFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        return this.failureListeners.remove(listener);
    }

    public void addCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        this.closeListeners.add(listener);
    }

    public boolean removeCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        return this.closeListeners.remove(listener);
    }

    public List<CloseListener> removeCloseListeners() {
        ArrayList<CloseListener> ret = new ArrayList<CloseListener>(this.closeListeners);
        this.closeListeners.clear();
        return ret;
    }

    public List<FailureListener> removeFailureListeners() {
        ArrayList<FailureListener> ret = new ArrayList<FailureListener>(this.failureListeners);
        this.failureListeners.clear();
        return ret;
    }

    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.clear();
        this.closeListeners.addAll(listeners);
    }

    public void setFailureListeners(List<FailureListener> listeners) {
        this.failureListeners.clear();
        this.failureListeners.addAll(listeners);
    }

    protected synchronized void setDataReceived() {
        this.dataReceived = true;
    }

    public synchronized boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    public void checkDestination(String destination) throws ActiveMQStompException {
        if (!this.manager.destinationExists(destination)) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.destinationNotExist(destination).setHandler(this.frameHandler);
        }
    }

    public void autoCreateDestinationIfPossible(String queue, RoutingType routingType) throws ActiveMQStompException {
        ServerSession session = this.getSession().getCoreSession();
        try {
            RoutingType effectiveAddressRoutingType;
            SimpleString simpleQueue = SimpleString.toSimpleString((String)queue);
            AddressInfo addressInfo = this.manager.getServer().getAddressInfo(simpleQueue);
            AddressSettings addressSettings = (AddressSettings)this.manager.getServer().getAddressSettingsRepository().getMatch(queue);
            RoutingType routingType2 = effectiveAddressRoutingType = routingType == null ? addressSettings.getDefaultAddressRoutingType() : routingType;
            if (addressInfo == null) {
                if (addressSettings.isAutoCreateAddresses()) {
                    session.createAddress(simpleQueue, effectiveAddressRoutingType, true);
                }
            } else if (!addressInfo.getRoutingTypes().contains(effectiveAddressRoutingType) && addressSettings.isAutoCreateAddresses()) {
                EnumSet<RoutingType> routingTypes = EnumSet.noneOf(RoutingType.class);
                for (RoutingType existingRoutingType : addressInfo.getRoutingTypes()) {
                    routingTypes.add(existingRoutingType);
                }
                routingTypes.add(effectiveAddressRoutingType);
                this.manager.getServer().updateAddressInfo(simpleQueue, routingTypes);
            }
            if (effectiveAddressRoutingType == RoutingType.ANYCAST && addressSettings.isAutoCreateQueues() && this.manager.getServer().locateQueue(simpleQueue) == null) {
                session.createQueue(simpleQueue, simpleQueue, routingType == null ? addressSettings.getDefaultQueueRoutingType() : routingType, null, false, true, true);
            }
        }
        catch (ActiveMQQueueExistsException simpleQueue) {
        }
        catch (Exception e) {
            ActiveMQStompProtocolLogger.LOGGER.debug("Exception while auto-creating destination", e);
            throw new ActiveMQStompException(e.getMessage(), e).setHandler(this.frameHandler);
        }
    }

    public void checkRoutingSemantics(String destination, RoutingType routingType) throws ActiveMQStompException {
        AddressInfo addressInfo = this.manager.getServer().getAddressInfo(SimpleString.toSimpleString((String)destination));
        if (addressInfo != null) {
            EnumSet actualDeliveryModesOfAddress = addressInfo.getRoutingTypes();
            if (routingType != null && !actualDeliveryModesOfAddress.contains(routingType)) {
                throw ActiveMQStompProtocolMessageBundle.BUNDLE.illegalSemantics(routingType.toString(), ((Object)actualDeliveryModesOfAddress).toString());
            }
        }
    }

    public ActiveMQBuffer createTransportBuffer(int size) {
        return ActiveMQBuffers.dynamicBuffer((int)size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.failLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        this.internalClose();
    }

    public Acceptor getAcceptorUsed() {
        return this.acceptorUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalClose() {
        if (this.frameHandler != null) {
            this.frameHandler.disconnect();
        }
        this.transportConnection.close();
        this.manager.cleanup(this);
        Object object = this.sendLock;
        synchronized (object) {
            this.callClosingListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(ActiveMQException me) {
        Object object = this.failLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            StompFrame frame = this.frameHandler.createStompFrame("ERROR");
            frame.addHeader("message", me.getMessage());
            this.sendFrame(frame, null);
            this.destroyed = true;
        }
        ActiveMQServerLogger.LOGGER.connectionFailureDetected(me.getMessage(), me.getType());
        this.callFailureListeners(me);
        this.internalClose();
    }

    public void fail(ActiveMQException me, String scaleDownTargetNodeID) {
        this.fail(me);
    }

    public void flush() {
    }

    public List<FailureListener> getFailureListeners() {
        return Collections.emptyList();
    }

    public Object getID() {
        return this.transportConnection.getID();
    }

    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    public boolean isClient() {
        return false;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
        this.manager.handleBuffer(this, buffer);
    }

    public String getLogin() {
        return this.login;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getClientID() {
        return this.clientID;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    private void callFailureListeners(ActiveMQException me) {
        ArrayList<FailureListener> listenersClone = new ArrayList<FailureListener>(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    private void callClosingListeners() {
        ArrayList<CloseListener> listenersClone = new ArrayList<CloseListener>(this.closeListeners);
        for (CloseListener listener : listenersClone) {
            try {
                listener.connectionClosed();
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    public void negotiateVersion(StompFrame frame) throws ActiveMQStompException {
        String acceptVersion = frame.getHeader("accept-version");
        if (acceptVersion == null) {
            this.version = StompVersions.V1_0;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(acceptVersion, ",");
            HashSet<String> requestVersions = new HashSet<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                requestVersions.add(tokenizer.nextToken());
            }
            if (requestVersions.contains(StompVersions.V1_2.toString())) {
                this.version = StompVersions.V1_2;
            } else if (requestVersions.contains(StompVersions.V1_1.toString())) {
                this.version = StompVersions.V1_1;
            } else if (requestVersions.contains(StompVersions.V1_0.toString())) {
                this.version = StompVersions.V1_0;
            } else {
                ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.versionNotSupported(acceptVersion).setHandler(this.frameHandler);
                error.addHeader("version", this.manager.getSupportedVersionsAsErrorVersion());
                error.addHeader("content-type", "text/plain");
                error.setBody("Supported protocol versions are " + this.manager.getSupportedVersionsAsString());
                error.setDisconnect(true);
                throw error;
            }
        }
        if (this.version != StompVersions.V1_0) {
            VersionedStompFrameHandler newHandler = VersionedStompFrameHandler.getHandler(this, this.version, this.scheduledExecutorService, this.factory);
            newHandler.initDecoder(this.frameHandler);
            this.frameHandler = newHandler;
        }
        this.initialized = true;
    }

    public void setHost(String host) throws ActiveMQStompException {
        if (host == null) {
            ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.nullHostHeader().setHandler(this.frameHandler);
            error.setBody(ActiveMQStompProtocolMessageBundle.BUNDLE.hostCannotBeNull());
            throw error;
        }
        String localHost = this.manager.getVirtualHostName();
        if (!host.equals(localHost)) {
            ActiveMQStompException error = ActiveMQStompProtocolMessageBundle.BUNDLE.hostNotMatch().setHandler(this.frameHandler);
            error.setBody(ActiveMQStompProtocolMessageBundle.BUNDLE.hostNotMatchDetails(host));
            throw error;
        }
    }

    public void handleFrame(StompFrame request) {
        StompFrame reply = null;
        if (this.stompListener != null) {
            this.stompListener.requestAccepted(request);
        }
        String cmd = request.getCommand();
        try {
            if (this.isDestroyed()) {
                throw ActiveMQStompProtocolMessageBundle.BUNDLE.connectionDestroyed().setHandler(this.frameHandler);
            }
            if (!this.initialized) {
                if (!"CONNECT".equals(cmd) && !"STOMP".equals(cmd)) {
                    throw ActiveMQStompProtocolMessageBundle.BUNDLE.connectionNotEstablished().setHandler(this.frameHandler);
                }
                this.negotiateVersion(request);
            }
            reply = this.frameHandler.handleFrame(request);
        }
        catch (ActiveMQStompException e) {
            reply = e.getFrame();
        }
        if (reply != null) {
            this.sendFrame(reply, null);
        }
        if ("DISCONNECT".equals(cmd)) {
            this.disconnect(false);
        }
    }

    public void sendFrame(StompFrame frame, StompPostReceiptFunction function) {
        this.manager.sendReply(this, frame, function);
    }

    public boolean validateUser(String login, String pass, RemotingConnection connection) {
        this.valid = this.manager.validateUser(login, pass, connection);
        if (this.valid) {
            this.login = login;
            this.passcode = pass;
        }
        return this.valid;
    }

    public CoreMessage createServerMessage() {
        return this.manager.createServerMessage();
    }

    public StompSession getSession() throws ActiveMQStompException {
        return this.getSession(null);
    }

    public StompSession getSession(String txID) throws ActiveMQStompException {
        StompSession session = null;
        try {
            session = txID == null ? this.manager.getSession(this) : this.manager.getTransactedSession(this, txID);
        }
        catch (Exception e) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.errorGetSession(e).setHandler(this.frameHandler);
        }
        return session;
    }

    protected void validate() throws ActiveMQStompException {
        if (!this.valid) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.invalidConnection().setHandler(this.frameHandler);
        }
    }

    protected void sendServerMessage(ICoreMessage message, String txID) throws ActiveMQStompException {
        StompSession stompSession = this.getSession(txID);
        if (stompSession.isNoLocal()) {
            message.putStringProperty(CONNECTION_ID_PROP, this.getID().toString());
        }
        if (this.isEnableMessageID()) {
            message.putStringProperty("amqMessageId", "STOMP" + message.getMessageID());
        }
        try {
            if (this.minLargeMessageSize == -1 || message.getBodyBuffer().writerIndex() < this.minLargeMessageSize) {
                stompSession.sendInternal((Message)message, false);
            } else {
                stompSession.sendInternalLarge((CoreMessage)message, false);
            }
        }
        catch (Exception e) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.errorSendMessage((Message)message, e).setHandler(this.frameHandler);
        }
    }

    public void disconnect(boolean criticalError) {
        this.disconnect(null, criticalError);
    }

    public void disconnect(String scaleDownNodeID, boolean criticalError) {
        this.destroy();
    }

    protected void beginTransaction(String txID) throws ActiveMQStompException {
        try {
            this.manager.beginTransaction(this, txID);
        }
        catch (ActiveMQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.errorBeginTx(txID, e).setHandler(this.frameHandler);
        }
    }

    public void commitTransaction(String txID) throws ActiveMQStompException {
        try {
            this.manager.commitTransaction(this, txID);
        }
        catch (Exception e) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.errorCommitTx(txID, e).setHandler(this.frameHandler);
        }
    }

    public void abortTransaction(String txID) throws ActiveMQStompException {
        try {
            this.manager.abortTransaction(this, txID);
        }
        catch (ActiveMQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.errorAbortTx(txID, e).setHandler(this.frameHandler);
        }
    }

    StompPostReceiptFunction subscribe(String destination, String selector, String ack, String id, String durableSubscriptionName, boolean noLocal, RoutingType subscriptionType) throws ActiveMQStompException {
        this.autoCreateDestinationIfPossible(destination, subscriptionType);
        this.checkDestination(destination);
        this.checkRoutingSemantics(destination, subscriptionType);
        if (noLocal) {
            String noLocalFilter = "__AMQ_CID <> '" + this.getID().toString() + "'";
            selector = selector == null ? noLocalFilter : selector + " AND " + noLocalFilter;
        }
        if (ack == null) {
            ack = "auto";
        }
        String subscriptionID = null;
        if (id != null) {
            subscriptionID = id;
        } else {
            if (destination == null) {
                throw ActiveMQStompProtocolMessageBundle.BUNDLE.noDestination().setHandler(this.frameHandler);
            }
            subscriptionID = "subscription/" + destination;
        }
        try {
            return this.manager.subscribe(this, subscriptionID, durableSubscriptionName, destination, selector, ack, noLocal);
        }
        catch (ActiveMQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.errorCreatingSubscription(subscriptionID, e).setHandler(this.frameHandler);
        }
    }

    public void unsubscribe(String subscriptionID, String durableSubscriptionName) throws ActiveMQStompException {
        try {
            this.manager.unsubscribe(this, subscriptionID, durableSubscriptionName);
        }
        catch (ActiveMQAddressDoesNotExistException activeMQAddressDoesNotExistException) {
        }
        catch (ActiveMQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.errorUnsubscribing(subscriptionID, e).setHandler(this.frameHandler);
        }
    }

    public void acknowledge(String messageID, String subscriptionID) throws ActiveMQStompException {
        try {
            this.manager.acknowledge(this, messageID, subscriptionID);
        }
        catch (ActiveMQStompException e) {
            throw e;
        }
        catch (Exception e) {
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.errorAck(messageID, e).setHandler(this.frameHandler);
        }
    }

    public String getVersion() {
        return String.valueOf((Object)this.version);
    }

    public String getActiveMQServerName() {
        return SERVER_NAME;
    }

    public StompFrame createStompMessage(ICoreMessage serverMessage, ActiveMQBuffer bodyBuffer, StompSubscription subscription, int deliveryCount) throws Exception {
        return this.frameHandler.createMessageFrame(serverMessage, bodyBuffer, subscription, deliveryCount);
    }

    public void addStompEventListener(FrameEventListener listener) {
        this.stompListener = listener;
    }

    public void ping(StompFrame pingFrame) {
        this.manager.sendReply(this, pingFrame, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void physicalSend(StompFrame frame) throws Exception {
        ActiveMQBuffer buffer = frame.toActiveMQBuffer();
        Object object = this.sendLock;
        synchronized (object) {
            this.getTransportConnection().write(buffer, false, false);
        }
        if (this.stompListener != null) {
            this.stompListener.replySent(frame);
        }
    }

    public VersionedStompFrameHandler getFrameHandler() {
        return this.frameHandler;
    }

    public boolean isEnableMessageID() {
        return this.enableMessageID;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    public StompProtocolManager getManager() {
        return this.manager;
    }

    public void killMessage(SimpleString nodeID) {
    }

    public boolean isSupportsFlowControl() {
        return false;
    }

    public Subject getSubject() {
        return null;
    }

    public String getProtocolName() {
        return "STOMP";
    }

    public String getTransportLocalAddress() {
        return this.getTransportConnection().getLocalAddress();
    }
}

