/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hibernate.stat.QueryStatistics;
import org.jboss.logging.Logger;

public class QueryStatisticsImpl
implements QueryStatistics {
    private static final Logger log = Logger.getLogger(QueryStatisticsImpl.class);
    private final String query;
    private final LongAdder cacheHitCount = new LongAdder();
    private final LongAdder cacheMissCount = new LongAdder();
    private final LongAdder cachePutCount = new LongAdder();
    private final LongAdder executionCount = new LongAdder();
    private final LongAdder executionRowCount = new LongAdder();
    private final AtomicLong executionMaxTime = new AtomicLong();
    private final AtomicLong executionMinTime = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong totalExecutionTime = new AtomicLong();
    private final Lock readLock;
    private final Lock writeLock;

    QueryStatisticsImpl(String query) {
        this.query = query;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public long getExecutionCount() {
        return this.executionCount.sum();
    }

    @Override
    public long getCacheHitCount() {
        return this.cacheHitCount.sum();
    }

    @Override
    public long getCachePutCount() {
        return this.cachePutCount.sum();
    }

    @Override
    public long getCacheMissCount() {
        return this.cacheMissCount.sum();
    }

    @Override
    public long getExecutionRowCount() {
        return this.executionRowCount.sum();
    }

    @Override
    public long getExecutionAvgTime() {
        return (long)this.getExecutionAvgTimeAsDouble();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getExecutionAvgTimeAsDouble() {
        this.writeLock.lock();
        try {
            double avgExecutionTime = 0.0;
            long ec = this.executionCount.sum();
            if (ec > 0L) {
                avgExecutionTime = (double)this.totalExecutionTime.get() / (double)ec;
            }
            double d = avgExecutionTime;
            return d;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getExecutionMaxTime() {
        return this.executionMaxTime.get();
    }

    @Override
    public long getExecutionMinTime() {
        return this.executionMinTime.get();
    }

    @Override
    public long getExecutionTotalTime() {
        return this.totalExecutionTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executed(long rows, long time) {
        log.tracef("QueryStatistics - query executed : %s", (Object)this.query);
        this.readLock.lock();
        try {
            long old = this.executionMinTime.get();
            while (time < old && !this.executionMinTime.compareAndSet(old, time)) {
                old = this.executionMinTime.get();
            }
            old = this.executionMaxTime.get();
            while (time > old && !this.executionMaxTime.compareAndSet(old, time)) {
                old = this.executionMaxTime.get();
            }
            this.executionCount.increment();
            this.executionRowCount.add(rows);
            this.totalExecutionTime.addAndGet(time);
        }
        finally {
            this.readLock.unlock();
        }
    }

    void incrementCacheHitCount() {
        log.tracef("QueryStatistics - cache hit : %s", (Object)this.query);
        this.cacheHitCount.increment();
    }

    void incrementCacheMissCount() {
        log.tracef("QueryStatistics - cache miss : %s", (Object)this.query);
        this.cacheMissCount.increment();
    }

    void incrementCachePutCount() {
        log.tracef("QueryStatistics - cache put : %s", (Object)this.query);
        this.cachePutCount.increment();
    }

    public String toString() {
        return "QueryStatistics[query=" + this.query + ",cacheHitCount=" + this.cacheHitCount + ",cacheMissCount=" + this.cacheMissCount + ",cachePutCount=" + this.cachePutCount + ",executionCount=" + this.executionCount + ",executionRowCount=" + this.executionRowCount + ",executionAvgTime=" + this.getExecutionAvgTime() + ",executionMaxTime=" + this.executionMaxTime + ",executionMinTime=" + this.executionMinTime + ']';
    }
}

