/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.JournalType;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.ActiveMQServerControlHandler;
import org.wildfly.extension.messaging.activemq.ActiveMQServerControlWriteHandler;
import org.wildfly.extension.messaging.activemq.AddressSettingDefinition;
import org.wildfly.extension.messaging.activemq.AddressSettingsResolveHandler;
import org.wildfly.extension.messaging.activemq.BridgeDefinition;
import org.wildfly.extension.messaging.activemq.BroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.Capabilities;
import org.wildfly.extension.messaging.activemq.ClusterConnectionDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.ConnectorServiceDefinition;
import org.wildfly.extension.messaging.activemq.CoreAddressDefinition;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.DivertDefinition;
import org.wildfly.extension.messaging.activemq.ExportJournalOperation;
import org.wildfly.extension.messaging.activemq.GenericTransportDefinition;
import org.wildfly.extension.messaging.activemq.GroupingHandlerDefinition;
import org.wildfly.extension.messaging.activemq.HTTPAcceptorDefinition;
import org.wildfly.extension.messaging.activemq.HTTPConnectorDefinition;
import org.wildfly.extension.messaging.activemq.ImportJournalOperation;
import org.wildfly.extension.messaging.activemq.InVMTransportDefinition;
import org.wildfly.extension.messaging.activemq.InfiniteOrPositiveValidators;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.QueueDefinition;
import org.wildfly.extension.messaging.activemq.RemoteTransportDefinition;
import org.wildfly.extension.messaging.activemq.SecuritySettingDefinition;
import org.wildfly.extension.messaging.activemq.ServerAdd;
import org.wildfly.extension.messaging.activemq.ServerRemove;
import org.wildfly.extension.messaging.activemq.ha.LiveOnlyDefinition;
import org.wildfly.extension.messaging.activemq.ha.ReplicationColocatedDefinition;
import org.wildfly.extension.messaging.activemq.ha.ReplicationMasterDefinition;
import org.wildfly.extension.messaging.activemq.ha.ReplicationSlaveDefinition;
import org.wildfly.extension.messaging.activemq.ha.SharedStoreColocatedDefinition;
import org.wildfly.extension.messaging.activemq.ha.SharedStoreMasterDefinition;
import org.wildfly.extension.messaging.activemq.ha.SharedStoreSlaveDefinition;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueDefinition;
import org.wildfly.extension.messaging.activemq.jms.JMSServerControlHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSTopicDefinition;
import org.wildfly.extension.messaging.activemq.jms.PooledConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.jms.legacy.LegacyConnectionFactoryDefinition;

public class ServerDefinition
extends PersistentResourceDefinition {
    public static final SimpleAttributeDefinition CLUSTER_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cluster-password", (ModelType)ModelType.STRING, (boolean)true).setAttributeGroup("cluster")).setXmlName("password")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultClusterPassword()))).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).setAlternatives(new String[]{"cluster-credential-reference"})).build();
    public static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((String)"cluster-credential-reference", (String)"credential-reference", (boolean)true, (boolean)true).setAttributeGroup("cluster")).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).setAlternatives(new String[]{CLUSTER_PASSWORD.getName()})).build();
    public static final SimpleAttributeDefinition CLUSTER_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cluster-user", (ModelType)ModelType.STRING).setAttributeGroup("cluster")).setXmlName("user")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultClusterUser()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final AttributeDefinition SCHEDULED_THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scheduled-thread-pool-max-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(ActiveMQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize()))).setRequired(false)).setAllowExpression(true)).setCorrector(InfiniteOrPositiveValidators.NEGATIVE_VALUE_CORRECTOR)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-domain", (ModelType)ModelType.STRING).setAttributeGroup("security")).setXmlName("domain")).setDefaultValue(new ModelNode("other"))).setAlternatives(new String[]{"elytron-domain"})).setRequired(false)).setAllowExpression(false)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SECURITY_DOMAIN_REF)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).setDeprecated(MessagingExtension.VERSION_2_0_0)).build();
    public static final SimpleAttributeDefinition ELYTRON_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"elytron-domain", (ModelType)ModelType.STRING).setAttributeGroup("security")).setRequired(false)).setAlternatives(new String[]{SECURITY_DOMAIN.getName()})).setAllowExpression(false)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.ELYTRON_SECURITY_DOMAIN_REF)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).setCapabilityReference("org.wildfly.security.security-domain", Capabilities.ACTIVEMQ_SERVER_CAPABILITY)).build();
    public static final AttributeDefinition THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"thread-pool-max-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(ActiveMQDefaultConfiguration.getDefaultThreadPoolMaxSize()))).setRequired(false)).setAllowExpression(true)).setCorrector(InfiniteOrPositiveValidators.NEGATIVE_VALUE_CORRECTOR)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition OVERRIDE_IN_VM_SECURITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"override-in-vm-security", (ModelType)ModelType.BOOLEAN).setAttributeGroup("security")).setDefaultValue(new ModelNode(true))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition WILD_CARD_ROUTING_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"wild-card-routing-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultWildcardRoutingEnabled()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition STATISTICS_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"statistics-enabled", (ModelType)ModelType.BOOLEAN).setAttributeGroup("statistics")).setXmlName("enabled")).setDefaultValue(new ModelNode(false))).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition JOURNAL_BUFFER_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-buffer-size", (ModelType)ModelType.LONG).setAttributeGroup("journal")).setXmlName("buffer-size")).setMeasurementUnit(MeasurementUnit.BYTES)).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new LongRangeValidator(0L, Long.MAX_VALUE, true, true))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_BUFFER_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-buffer-timeout", (ModelType)ModelType.LONG).setAttributeGroup("journal")).setXmlName("buffer-timeout")).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_COMPACT_MIN_FILES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-compact-min-files", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("compact-min-files")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJournalCompactMinFiles()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_COMPACT_PERCENTAGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-compact-percentage", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("compact-percentage")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJournalCompactPercentage()))).setMeasurementUnit(MeasurementUnit.PERCENTAGE)).setValidator((ParameterValidator)new IntRangeValidator(0, 100, true, true))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_DATASOURCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-datasource", (ModelType)ModelType.STRING).setAttributeGroup("journal")).setXmlName("datasource")).setRequired(false)).setAllowExpression(false)).setCapabilityReference("org.wildfly.data-source", Capabilities.ACTIVEMQ_SERVER_CAPABILITY)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_BINDINGS_TABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-bindings-table", (ModelType)ModelType.STRING).setAttributeGroup("journal")).setXmlName("bindings-table")).setRequired(false)).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultBindingsTableName()))).setAllowExpression(true)).setRestartAllServices()).build();
    @Deprecated
    public static final SimpleAttributeDefinition JOURNAL_JMS_BINDINGS_TABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-jms-bindings-table", (ModelType)ModelType.STRING).setAttributeGroup("journal")).setXmlName("jms-bindings-table")).setRequired(false)).setDefaultValue(new ModelNode("JMS_BINDINGS"))).setAllowExpression(true)).setDeprecated(MessagingExtension.VERSION_3_0_0)).build();
    public static final SimpleAttributeDefinition JOURNAL_LARGE_MESSAGES_TABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-large-messages-table", (ModelType)ModelType.STRING).setAttributeGroup("journal")).setXmlName("large-messages-table")).setRequired(false)).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultLargeMessagesTableName()))).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_MESSAGES_TABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-messages-table", (ModelType)ModelType.STRING).setAttributeGroup("journal")).setXmlName("messages-table")).setRequired(false)).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMessageTableName()))).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_NODE_MANAGER_STORE_TABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-node-manager-store-table", (ModelType)ModelType.STRING).setAttributeGroup("journal")).setXmlName("node-manager-store-table")).setRequired(false)).setDefaultValue(new ModelNode("NODE_MANAGER_STORE"))).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_PAGE_STORE_TABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-page-store-table", (ModelType)ModelType.STRING).setAttributeGroup("journal")).setXmlName("page-store-table")).setRequired(false)).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultPageStoreTableName()))).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition JOURNAL_DATABASE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-database", (ModelType)ModelType.STRING).setAttributeGroup("journal")).setXmlName("database")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition JOURNAL_JDBC_LOCK_EXPIRATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-jdbc-lock-expiration", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("jdbc-lock-expiration")).setDefaultValue(new ModelNode(20))).setMeasurementUnit(MeasurementUnit.SECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition JOURNAL_JDBC_LOCK_RENEW_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-jdbc-lock-renew-period", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("jdbc-lock-renew-period")).setDefaultValue(new ModelNode(4))).setMeasurementUnit(MeasurementUnit.SECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition JOURNAL_JDBC_NETWORK_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-jdbc-network-timeout", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("jdbc-network-timeout")).setDefaultValue(new ModelNode(20))).setMeasurementUnit(MeasurementUnit.SECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_FILE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-file-size", (ModelType)ModelType.LONG).setAttributeGroup("journal")).setXmlName("file-size")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJournalFileSize()))).setMeasurementUnit(MeasurementUnit.BYTES)).setValidator((ParameterValidator)new LongRangeValidator(1024L, Long.MAX_VALUE, true, true))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_MAX_IO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-max-io", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("max-io")).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_MIN_FILES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-min-files", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("min-files")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJournalMinFiles()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).setValidator((ParameterValidator)new IntRangeValidator(2, true, true))).build();
    public static final SimpleAttributeDefinition JOURNAL_POOL_FILES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-pool-files", (ModelType)ModelType.INT).setAttributeGroup("journal")).setXmlName("pool-files")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJournalPoolFiles()))).setRequired(false)).setAllowExpression(true)).setCorrector(InfiniteOrPositiveValidators.NEGATIVE_VALUE_CORRECTOR)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_SYNC_NON_TRANSACTIONAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-sync-non-transactional", (ModelType)ModelType.BOOLEAN).setAttributeGroup("journal")).setXmlName("sync-non-transactional")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultJournalSyncNonTransactional()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_SYNC_TRANSACTIONAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-sync-transactional", (ModelType)ModelType.BOOLEAN).setAttributeGroup("journal")).setXmlName("sync-transactional")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultJournalSyncTransactional()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JOURNAL_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"journal-type", (ModelType)ModelType.STRING).setAttributeGroup("journal")).setXmlName("type")).setDefaultValue(new ModelNode(ConfigurationImpl.DEFAULT_JOURNAL_TYPE.toString()))).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new EnumValidator(JournalType.class, true, true, (Enum[])new JournalType[]{JournalType.ASYNCIO, JournalType.NIO}))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition LOG_JOURNAL_WRITE_RATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"log-journal-write-rate", (ModelType)ModelType.BOOLEAN).setAttributeGroup("journal")).setXmlName("log-write-rate")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultJournalLogWriteRate()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CONNECTION_TTL_OVERRIDE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"connection-ttl-override", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultConnectionTtlOverride()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.LONG_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ASYNC_CONNECTION_EXECUTION_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"async-connection-execution-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultAsyncConnectionExecutionEnabled()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MESSAGE_COUNTER_MAX_DAY_HISTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-counter-max-day-history", (ModelType)ModelType.INT).setAttributeGroup("statistics")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMessageCounterMaxDayHistory()))).setMeasurementUnit(MeasurementUnit.DAYS)).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MESSAGE_COUNTER_SAMPLE_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-counter-sample-period", (ModelType)ModelType.LONG).setAttributeGroup("statistics")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMessageCounterSamplePeriod()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition TRANSACTION_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"transaction-timeout", (ModelType)ModelType.LONG).setAttributeGroup("transaction")).setXmlName("timeout")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultTransactionTimeout()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition TRANSACTION_TIMEOUT_SCAN_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"transaction-timeout-scan-period", (ModelType)ModelType.LONG).setAttributeGroup("transaction")).setXmlName("scan-period")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultTransactionTimeoutScanPeriod()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MESSAGE_EXPIRY_SCAN_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-expiry-scan-period", (ModelType)ModelType.LONG).setAttributeGroup("message-expiry")).setXmlName("scan-period")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMessageExpiryScanPeriod()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MESSAGE_EXPIRY_THREAD_PRIORITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"message-expiry-thread-priority", (ModelType)ModelType.INT).setAttributeGroup("message-expiry")).setXmlName("thread-priority")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMessageExpiryThreadPriority()))).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1, 10, true, true))).setRestartAllServices()).build();
    @Deprecated
    public static final SimpleAttributeDefinition PERF_BLAST_PAGES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"perf-blast-pages", (ModelType)ModelType.INT).setAttributeGroup("debug")).setDefaultValue(new ModelNode(-1))).setRequired(false)).setAllowExpression(true)).setCorrector(InfiniteOrPositiveValidators.NEGATIVE_VALUE_CORRECTOR)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setRestartAllServices()).setDeprecated(MessagingExtension.VERSION_3_0_0)).build();
    @Deprecated
    public static final SimpleAttributeDefinition RUN_SYNC_SPEED_TEST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"run-sync-speed-test", (ModelType)ModelType.BOOLEAN).setAttributeGroup("debug")).setDefaultValue(new ModelNode(false))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).setDeprecated(MessagingExtension.VERSION_3_0_0)).build();
    public static final SimpleAttributeDefinition SERVER_DUMP_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"server-dump-interval", (ModelType)ModelType.LONG).setAttributeGroup("debug")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultServerDumpInterval()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.LONG_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MEMORY_MEASURE_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"memory-measure-interval", (ModelType)ModelType.LONG).setAttributeGroup("debug")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMemoryMeasureInterval()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.LONG_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MEMORY_WARNING_THRESHOLD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"memory-warning-threshold", (ModelType)ModelType.INT).setAttributeGroup("debug")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMemoryWarningThreshold()))).setMeasurementUnit(MeasurementUnit.PERCENTAGE)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition SECURITY_INVALIDATION_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-invalidation-interval", (ModelType)ModelType.LONG).setAttributeGroup("security")).setXmlName("invalidation-interval")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultSecurityInvalidationInterval()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition SECURITY_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"security-enabled", (ModelType)ModelType.BOOLEAN).setAttributeGroup("security")).setXmlName("enabled")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultSecurityEnabled()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition PERSISTENCE_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"persistence-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultPersistenceEnabled()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition MANAGEMENT_NOTIFICATION_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-notification-address", (ModelType)ModelType.STRING).setAttributeGroup("management")).setXmlName("notification-address")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress().toString()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_MANAGEMENT_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition MANAGEMENT_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"management-address", (ModelType)ModelType.STRING).setAttributeGroup("management")).setXmlName("address")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultManagementAddress().toString()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_MANAGEMENT_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition JMX_MANAGEMENT_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jmx-management-enabled", (ModelType)ModelType.BOOLEAN).setAttributeGroup("management")).setXmlName("jmx-enabled")).setDefaultValue(new ModelNode(false))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_MANAGEMENT_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition JMX_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jmx-domain", (ModelType)ModelType.STRING).setAttributeGroup("management")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultJmxDomain()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_MANAGEMENT_SENSITIVE_TARGET)).build();
    public static final SimpleAttributeDefinition PERSIST_ID_CACHE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"persist-id-cache", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultPersistIdCache()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"persist-delivery-count-before-delivery", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultPersistDeliveryCountBeforeDelivery()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition ID_CACHE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"id-cache-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultIdCacheSize()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PAGE_MAX_CONCURRENT_IO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"page-max-concurrent-io", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultMaxConcurrentPageIo()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CREATE_BINDINGS_DIR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"create-bindings-dir", (ModelType)ModelType.BOOLEAN).setAttributeGroup("journal")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultCreateBindingsDir()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition CREATE_JOURNAL_DIR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"create-journal-dir", (ModelType)ModelType.BOOLEAN).setAttributeGroup("journal")).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.isDefaultCreateJournalDir()))).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PERSISTENCE_ENABLED, SCHEDULED_THREAD_POOL_MAX_SIZE, THREAD_POOL_MAX_SIZE, SECURITY_DOMAIN, ELYTRON_DOMAIN, SECURITY_ENABLED, SECURITY_INVALIDATION_INTERVAL, OVERRIDE_IN_VM_SECURITY, WILD_CARD_ROUTING_ENABLED, MANAGEMENT_ADDRESS, MANAGEMENT_NOTIFICATION_ADDRESS, CLUSTER_USER, CLUSTER_PASSWORD, CREDENTIAL_REFERENCE, JMX_MANAGEMENT_ENABLED, JMX_DOMAIN, STATISTICS_ENABLED, MESSAGE_COUNTER_SAMPLE_PERIOD, MESSAGE_COUNTER_MAX_DAY_HISTORY, CONNECTION_TTL_OVERRIDE, ASYNC_CONNECTION_EXECUTION_ENABLED, TRANSACTION_TIMEOUT, TRANSACTION_TIMEOUT_SCAN_PERIOD, MESSAGE_EXPIRY_SCAN_PERIOD, MESSAGE_EXPIRY_THREAD_PRIORITY, ID_CACHE_SIZE, PERSIST_ID_CACHE, CommonAttributes.INCOMING_INTERCEPTORS, CommonAttributes.OUTGOING_INTERCEPTORS, PERSIST_DELIVERY_COUNT_BEFORE_DELIVERY, PAGE_MAX_CONCURRENT_IO, CREATE_BINDINGS_DIR, CREATE_JOURNAL_DIR, JOURNAL_TYPE, JOURNAL_BUFFER_TIMEOUT, JOURNAL_BUFFER_SIZE, JOURNAL_DATASOURCE, JOURNAL_DATABASE, JOURNAL_JDBC_LOCK_EXPIRATION, JOURNAL_JDBC_LOCK_RENEW_PERIOD, JOURNAL_JDBC_NETWORK_TIMEOUT, JOURNAL_MESSAGES_TABLE, JOURNAL_BINDINGS_TABLE, JOURNAL_JMS_BINDINGS_TABLE, JOURNAL_LARGE_MESSAGES_TABLE, JOURNAL_PAGE_STORE_TABLE, JOURNAL_NODE_MANAGER_STORE_TABLE, JOURNAL_SYNC_TRANSACTIONAL, JOURNAL_SYNC_NON_TRANSACTIONAL, LOG_JOURNAL_WRITE_RATE, JOURNAL_FILE_SIZE, JOURNAL_MIN_FILES, JOURNAL_POOL_FILES, JOURNAL_COMPACT_PERCENTAGE, JOURNAL_COMPACT_MIN_FILES, JOURNAL_MAX_IO, PERF_BLAST_PAGES, RUN_SYNC_SPEED_TEST, SERVER_DUMP_INTERVAL, MEMORY_WARNING_THRESHOLD, MEMORY_MEASURE_INTERVAL};
    private final boolean registerRuntimeOnly;

    ServerDefinition(boolean registerRuntimeOnly) {
        super(MessagingExtension.SERVER_PATH, MessagingExtension.getResourceDescriptionResolver("server"), (OperationStepHandler)ServerAdd.INSTANCE, (OperationStepHandler)ServerRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.registerRuntimeOnly) {
            ExportJournalOperation.registerOperation(resourceRegistration, this.getResourceDescriptionResolver());
            ImportJournalOperation.registerOperation(resourceRegistration, this.getResourceDescriptionResolver());
            ActiveMQServerControlHandler.INSTANCE.registerOperations(resourceRegistration, this.getResourceDescriptionResolver());
            JMSServerControlHandler.INSTANCE.registerOperations(resourceRegistration, this.getResourceDescriptionResolver());
            AddressSettingsResolveHandler.registerOperationHandler(resourceRegistration, this.getResourceDescriptionResolver());
        }
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ActiveMQServerControlWriteHandler.INSTANCE.registerAttributes(resourceRegistration, this.registerRuntimeOnly);
        if (this.registerRuntimeOnly) {
            ActiveMQServerControlHandler.INSTANCE.registerAttributes(resourceRegistration);
        }
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(Capabilities.ACTIVEMQ_SERVER_CAPABILITY);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        ArrayList<PersistentResourceDefinition> children = new ArrayList<PersistentResourceDefinition>();
        children.addAll(Arrays.asList(new PersistentResourceDefinition[]{LiveOnlyDefinition.INSTANCE, ReplicationMasterDefinition.INSTANCE, ReplicationSlaveDefinition.INSTANCE, ReplicationColocatedDefinition.INSTANCE, SharedStoreMasterDefinition.INSTANCE, SharedStoreSlaveDefinition.INSTANCE, SharedStoreColocatedDefinition.INSTANCE, AddressSettingDefinition.INSTANCE, SecuritySettingDefinition.INSTANCE, HTTPAcceptorDefinition.INSTANCE, DivertDefinition.INSTANCE, ConnectorServiceDefinition.INSTANCE, GroupingHandlerDefinition.INSTANCE, LegacyConnectionFactoryDefinition.INSTANCE, PooledConnectionFactoryDefinition.INSTANCE}));
        children.add(GenericTransportDefinition.createAcceptorDefinition(this.registerRuntimeOnly));
        children.add(InVMTransportDefinition.createAcceptorDefinition(this.registerRuntimeOnly));
        children.add(RemoteTransportDefinition.createAcceptorDefinition(this.registerRuntimeOnly));
        children.add(GenericTransportDefinition.createConnectorDefinition(this.registerRuntimeOnly));
        children.add(InVMTransportDefinition.createConnectorDefinition(this.registerRuntimeOnly));
        children.add(RemoteTransportDefinition.createConnectorDefinition(this.registerRuntimeOnly));
        children.add(new HTTPConnectorDefinition(this.registerRuntimeOnly));
        children.add(new BridgeDefinition(this.registerRuntimeOnly));
        children.add(new BroadcastGroupDefinition(this.registerRuntimeOnly));
        children.add(new DiscoveryGroupDefinition(this.registerRuntimeOnly, false));
        children.add(new ClusterConnectionDefinition(this.registerRuntimeOnly));
        children.add(new QueueDefinition(this.registerRuntimeOnly, MessagingExtension.QUEUE_PATH));
        children.add(new JMSQueueDefinition(false, this.registerRuntimeOnly));
        children.add(new JMSTopicDefinition(false, this.registerRuntimeOnly));
        children.add(new ConnectionFactoryDefinition(this.registerRuntimeOnly));
        return children;
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        if (this.registerRuntimeOnly) {
            resourceRegistration.registerSubModel((ResourceDefinition)new QueueDefinition(this.registerRuntimeOnly, MessagingExtension.RUNTIME_QUEUE_PATH));
            resourceRegistration.registerSubModel((ResourceDefinition)CoreAddressDefinition.INSTANCE);
        }
    }
}

