/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.MatchRule;

class MatchSchemeRule
extends MatchRule {
    private final String protoName;

    MatchSchemeRule(MatchRule parent, String protoName) {
        super(parent);
        this.protoName = protoName;
    }

    @Override
    public boolean isProtocolMatched() {
        return true;
    }

    @Override
    public String getMatchProtocol() {
        return this.protoName;
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority) {
        String scheme = uri.getScheme();
        return scheme != null && scheme.equals(this.protoName) && super.matches(uri, abstractType, abstractTypeAuthority);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchSchemeRule(newParent, this.protoName);
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered(this.parentHashCode(), 3547, this.protoName.hashCode());
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return this.protoName.equals(other.getMatchProtocol()) && this.parentHalfEqual(other);
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("scheme=").append(this.protoName).append(',');
    }
}

