/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.security.AccessController;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfiguration;
import org.infinispan.client.hotrod.impl.async.DefaultAsyncExecutorFactory;
import org.infinispan.commons.executors.ExecutorFactory;
import org.jboss.as.clustering.infinispan.subsystem.ComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.concurrent.ClassLoaderThreadFactory;

public class ClientThreadPoolServiceConfigurator
extends ComponentServiceConfigurator<ExecutorFactoryConfiguration>
implements ThreadFactory {
    private final ThreadPoolDefinition definition;
    private volatile ExecutorFactory factory;

    public ClientThreadPoolServiceConfigurator(ThreadPoolDefinition definition, PathAddress address) {
        super(definition, address);
        this.definition = definition;
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final int maxThreads = this.definition.getMaxThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final int minThreads = this.definition.getMinThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final int queueLength = this.definition.getQueueLength().resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final long keepAliveTime = this.definition.getKeepAliveTime().resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.factory = new ExecutorFactory(){

            public ExecutorService getExecutor(Properties property) {
                ClassLoaderThreadFactory clThreadFactory = new ClassLoaderThreadFactory((ThreadFactory)ClientThreadPoolServiceConfigurator.this, AccessController.doPrivileged(ClassLoaderThreadFactory.class::getClassLoader));
                return new ThreadPoolExecutor(minThreads, maxThreads, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueLength), (ThreadFactory)clThreadFactory);
            }
        };
        return this;
    }

    @Override
    public ExecutorFactoryConfiguration get() {
        return new ConfigurationBuilder().asyncExecutorFactory().factory(this.factory).create();
    }

    @Override
    public Thread newThread(Runnable task) {
        Thread thread = new Thread(task, "HotRod-client-async-pool-" + DefaultAsyncExecutorFactory.counter.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    }
}

