/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.impl.result.NullResultHandler;
import org.aesh.command.impl.validator.NullCommandValidator;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.map.MapCommand;
import org.aesh.command.map.MapCommandPopulator;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.parser.OptionParserException;
import org.aesh.command.populator.CommandPopulator;
import org.aesh.command.result.ResultHandler;
import org.aesh.command.validator.CommandValidator;
import org.aesh.readline.util.Parser;
import org.aesh.util.ReflectionUtil;

public class MapProcessedCommandBuilder {
    private static final ProcessedOptionProvider EMPTY_PROVIDER = new ProcessedOptionProvider(){

        @Override
        public List<ProcessedOption> getOptions(List<ProcessedOption> options) {
            return Collections.emptyList();
        }
    };
    private ProcessedOptionProvider provider;
    private String name;
    private String description;
    private CommandValidator<?> validator;
    private ResultHandler resultHandler;
    private ProcessedOption arguments;
    private ProcessedOption argument;
    private final List<ProcessedOption> options = new ArrayList<ProcessedOption>();
    private CommandPopulator populator;
    private MapCommand command;
    private List<String> aliases;
    private CommandActivator activator;
    private boolean lookup;

    public MapProcessedCommandBuilder lookupAtCompletionOnly(boolean lookup) {
        this.lookup = lookup;
        return this;
    }

    public MapProcessedCommandBuilder name(String name) {
        this.name = name;
        return this;
    }

    public MapProcessedCommandBuilder name(List<String> aliases) {
        this.aliases = aliases == null ? Collections.emptyList() : Collections.unmodifiableList(aliases);
        return this;
    }

    public MapProcessedCommandBuilder description(String usage) {
        this.description = usage;
        return this;
    }

    public MapProcessedCommandBuilder optionProvider(ProcessedOptionProvider provider) {
        this.provider = provider;
        return this;
    }

    public MapProcessedCommandBuilder arguments(ProcessedOption arguments) {
        this.arguments = arguments;
        return this;
    }

    public MapProcessedCommandBuilder argument(ProcessedOption argument) {
        this.argument = argument;
        return this;
    }

    public MapProcessedCommandBuilder validator(CommandValidator<?> validator) {
        this.validator = validator;
        return this;
    }

    public MapProcessedCommandBuilder validator(Class<? extends CommandValidator> validator) {
        this.validator = this.initValidator(validator);
        return this;
    }

    private CommandValidator initValidator(Class<? extends CommandValidator> validator) {
        if (validator != null && !validator.equals(NullCommandValidator.class)) {
            return ReflectionUtil.newInstance(validator);
        }
        return new NullCommandValidator();
    }

    public MapProcessedCommandBuilder resultHandler(Class<? extends ResultHandler> resultHandler) {
        this.resultHandler = this.initResultHandler(resultHandler);
        return this;
    }

    private ResultHandler initResultHandler(Class<? extends ResultHandler> resultHandler) {
        if (resultHandler != null && !resultHandler.equals(NullResultHandler.class)) {
            return ReflectionUtil.newInstance(resultHandler);
        }
        return new NullResultHandler();
    }

    public MapProcessedCommandBuilder resultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    public MapProcessedCommandBuilder populator(CommandPopulator populator) {
        this.populator = populator;
        return this;
    }

    public MapProcessedCommandBuilder command(MapCommand command) {
        this.command = command;
        return this;
    }

    public MapProcessedCommandBuilder command(Class<? extends MapCommand> command) {
        this.command = ReflectionUtil.newInstance(command);
        return this;
    }

    public MapProcessedCommandBuilder addOption(ProcessedOption option) {
        this.options.add(option);
        return this;
    }

    public MapProcessedCommandBuilder addOptions(List<ProcessedOption> options) {
        if (options != null) {
            this.options.addAll(options);
        }
        return this;
    }

    public MapProcessedCommandBuilder activator(CommandActivator activator) {
        this.activator = activator;
        return this;
    }

    public MapProcessedCommand create() throws CommandLineParserException {
        if (this.name == null || this.name.length() < 1) {
            throw new CommandLineParserException("The parameter name must be defined");
        }
        if (this.validator == null) {
            this.validator = new NullCommandValidator();
        }
        if (this.resultHandler == null) {
            this.resultHandler = new NullResultHandler();
        }
        if (this.populator == null) {
            this.populator = new MapCommandPopulator(this.command);
        }
        return new MapProcessedCommand(this.name, this.aliases, this.command, this.description, this.validator, this.resultHandler, this.arguments, this.options, this.argument, this.populator, this.provider, this.activator, this.lookup);
    }

    public static interface ProcessedOptionProvider {
        public List<ProcessedOption> getOptions(List<ProcessedOption> var1);
    }

    public static class MapProcessedCommand
    extends ProcessedCommand<MapCommand> {
        private final ProcessedOptionProvider provider;
        private List<ProcessedOption> currentOptions;
        private final boolean initialized;
        private final boolean lookup;
        private CommandLineParser.Mode mode;

        MapProcessedCommand(String name, List<String> aliases, MapCommand command, String description, CommandValidator validator, ResultHandler resultHandler, ProcessedOption arguments, List<ProcessedOption> options, ProcessedOption argument, CommandPopulator populator, ProcessedOptionProvider provider, CommandActivator activator, boolean lookup) throws OptionParserException {
            super(name, aliases, command, description, validator, resultHandler, arguments, options, argument, populator, activator);
            this.initialized = true;
            this.provider = provider == null ? EMPTY_PROVIDER : provider;
            this.lookup = lookup;
        }

        @Override
        protected void updateOptionsInvocationProviders(InvocationProviders invocationProviders) {
            for (ProcessedOption option : super.getOptions()) {
                option.updateInvocationProviders(invocationProviders);
            }
        }

        @Override
        public List<ProcessedOption> getOptions() {
            if (!this.initialized) {
                return super.getOptions();
            }
            return this.getOptions(true);
        }

        @Override
        public ProcessedOption searchAllOptions(String input) {
            if (!this.initialized) {
                return super.searchAllOptions(input);
            }
            if (this.lookup && !CommandLineParser.Mode.COMPLETION.equals((Object)this.mode)) {
                return null;
            }
            if (input.startsWith("--")) {
                ProcessedOption currentOption = null;
                if (input.contains("=")) {
                    String optName = input.substring(2, input.indexOf("="));
                    currentOption = this.findLongOptionNoActivatorCheck(optName);
                } else {
                    currentOption = this.startWithLongOptionNoActivatorCheck(input.substring(2));
                }
                if (currentOption != null) {
                    currentOption.setLongNameUsed(true);
                } else if (Parser.containsNonEscapedSpace(input)) {
                    return this.searchAllOptions(Parser.switchSpacesToEscapedSpacesInWord(input));
                }
                return currentOption;
            }
            return super.searchAllOptions(input);
        }

        @Override
        public ProcessedOption findLongOption(String name) {
            if (!this.initialized) {
                return super.findLongOption(name);
            }
            if (this.lookup && !CommandLineParser.Mode.COMPLETION.equals((Object)this.mode)) {
                return null;
            }
            for (ProcessedOption option : this.getOptions(false)) {
                if (option.name() == null || !option.name().equals(name) || !option.activator().isActivated(new ParsedCommand(this))) continue;
                return option;
            }
            for (ProcessedOption option : this.getOptions(true)) {
                if (option.name() == null || !option.name().equals(name) || !option.activator().isActivated(new ParsedCommand(this))) continue;
                return option;
            }
            return null;
        }

        @Override
        public ProcessedOption findLongOptionNoActivatorCheck(String name) {
            if (!this.initialized) {
                return super.findLongOptionNoActivatorCheck(name);
            }
            if (this.lookup && !CommandLineParser.Mode.COMPLETION.equals((Object)this.mode)) {
                return null;
            }
            for (ProcessedOption option : super.getOptions()) {
                if (option.name() == null || !option.name().equals(name)) continue;
                return option;
            }
            for (ProcessedOption option : this.provider.getOptions(this.currentOptions)) {
                if (option.name() == null || !option.name().equals(name)) continue;
                return option;
            }
            return null;
        }

        @Override
        public void clearOptions() {
            for (ProcessedOption processedOption : this.getCurrentOptions()) {
                processedOption.clear();
            }
        }

        List<ProcessedOption> getCurrentOptions() {
            ArrayList<ProcessedOption> allOptions = new ArrayList<ProcessedOption>(super.getOptions());
            if (this.currentOptions != null) {
                allOptions.addAll(this.currentOptions);
            }
            return allOptions;
        }

        public List<ProcessedOption> getOptions(boolean dynamic) {
            ArrayList<ProcessedOption> allOptions = new ArrayList<ProcessedOption>(super.getOptions());
            if (this.provider != null && dynamic) {
                this.currentOptions = this.provider.getOptions(this.currentOptions);
                allOptions.addAll(this.currentOptions);
            }
            return allOptions;
        }

        @Override
        public void clear() {
            MapCommand cmd = (MapCommand)this.getCommand();
            this.mode = null;
            cmd.resetAll();
            super.clear();
        }

        public void setMode(CommandLineParser.Mode mode) {
            this.mode = mode;
        }
    }
}

