/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.LsHandler;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.dmr.ModelNode;

public class PrefixHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithValue nodePath;
    private final ArgumentWithoutValue noValidation = new ArgumentWithoutValue(this, "--no-validation");

    public PrefixHandler() {
        this("cn");
    }

    public PrefixHandler(String command) {
        super(command, true);
        this.nodePath = new ArgumentWithValue((CommandHandlerWithArguments)this, OperationRequestCompleter.ARG_VALUE_COMPLETER, 0, "--node-path");
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        String nodePath = this.nodePath.getValue(ctx.getParsedCommandLine());
        OperationRequestAddress prefix = ctx.getCurrentNodePath();
        if (nodePath == null) {
            ctx.printLine(ctx.getNodePathFormatter().format(prefix));
            return;
        }
        DefaultOperationRequestAddress tmp = new DefaultOperationRequestAddress(prefix);
        String np = LsHandler.getNodePath(ctx.getArgumentsString());
        ctx.getCommandLineParser().parse(np, new DefaultCallbackHandler(tmp));
        if (!this.noValidation.isPresent(ctx.getParsedCommandLine())) {
            this.assertValid(ctx, tmp);
        }
        if (tmp.isEmpty()) {
            prefix.reset();
        } else {
            prefix.reset();
            for (OperationRequestAddress.Node node : tmp) {
                if (node.getName() != null) {
                    prefix.toNode(node.getType(), node.getName());
                    continue;
                }
                prefix.toNodeType(node.getType());
            }
        }
    }

    protected void assertValid(CommandContext ctx, OperationRequestAddress addr) throws CommandLineException {
        ModelNode response;
        ModelNode req = new ModelNode();
        req.get("address").setEmptyList();
        req.get("operation").set("validate-address");
        ModelNode addressValue = req.get("value");
        String lastType = null;
        for (OperationRequestAddress.Node node : addr) {
            if (node.getName() != null) {
                addressValue.add(node.getType(), node.getName());
                continue;
            }
            lastType = node.getType();
        }
        if (addressValue.isDefined()) {
            try {
                response = ctx.getModelControllerClient().execute(req);
            }
            catch (IOException e) {
                throw new CommandLineException("Failed to validate address.", e);
            }
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                throw new CommandLineException("Failed to validate address: the response from the controller doesn't contain result.");
            }
            ModelNode valid = result.get("valid");
            if (!valid.isDefined()) {
                throw new CommandLineException("Failed to validate address: the result doesn't contain 'valid' property.");
            }
            if (!valid.asBoolean()) {
                String msg = result.hasDefined("problem") ? result.get("problem").asString() : "Invalid target address.";
                throw new CommandLineException(msg);
            }
        }
        if (lastType != null) {
            req = new ModelNode();
            req.get("operation").set("read-children-types");
            ModelNode addrNode = req.get("address");
            if (addr.isEmpty()) {
                addrNode.setEmptyList();
            } else {
                for (OperationRequestAddress.Node node : addr) {
                    if (node.getName() == null) continue;
                    addrNode.add(node.getType(), node.getName());
                }
            }
            try {
                response = ctx.getModelControllerClient().execute(req);
            }
            catch (IOException e) {
                throw new CommandLineException("Failed to validate address.", e);
            }
            ModelNode result = response.get("result");
            if (!result.isDefined()) {
                throw new CommandLineException("Failed to validate address: the response from the controller doesn't contain result.");
            }
            for (ModelNode type : result.asList()) {
                if (!lastType.equals(type.asString())) continue;
                return;
            }
            throw new CommandLineException("Invalid target address: " + lastType + " doesn't exist.");
        }
    }
}

