/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.StandardOutputStreams;
import org.jboss.logmanager.formatters.PatternFormatter;

public class DelayedHandler
extends ExtHandler {
    private final Deque<ExtLogRecord> logRecords = new ArrayDeque<ExtLogRecord>();
    private volatile boolean activated = false;
    private volatile boolean callerCalculationRequired = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPublish(ExtLogRecord record) {
        if (this.activated) {
            this.publishToChildren(record);
            super.doPublish(record);
        } else {
            DelayedHandler delayedHandler = this;
            synchronized (delayedHandler) {
                if (this.activated) {
                    this.publishToChildren(record);
                    super.doPublish(record);
                } else {
                    if (this.isCallerCalculationRequired()) {
                        record.copyAll();
                    } else {
                        record.disableCallerCalculation();
                        record.copyMdc();
                        record.getFormattedMessage();
                    }
                    this.logRecords.addLast(record);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SecurityException {
        DelayedHandler.checkAccess(this);
        DelayedHandler delayedHandler = this;
        synchronized (delayedHandler) {
            if (!this.logRecords.isEmpty()) {
                ExtLogRecord record;
                Formatter formatter = this.getFormatter();
                if (formatter == null) {
                    formatter = new PatternFormatter("%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n");
                }
                StandardOutputStreams.printError("The DelayedHandler was closed before any children handlers were configured. Messages will be written to stderr.");
                while ((record = this.logRecords.pollFirst()) != null) {
                    StandardOutputStreams.printError(formatter.format(record));
                }
            }
        }
        this.activated = false;
        super.close();
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        super.addHandler(handler);
        this.activate();
    }

    @Override
    public Handler[] setHandlers(Handler[] newHandlers) throws SecurityException {
        Handler[] result = super.setHandlers(newHandlers);
        this.activate();
        return result;
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        super.removeHandler(handler);
        this.activated = this.handlers.length != 0;
    }

    @Override
    public Handler[] clearHandlers() throws SecurityException {
        this.activated = false;
        return super.clearHandlers();
    }

    @Override
    public boolean isCallerCalculationRequired() {
        return this.callerCalculationRequired || super.isCallerCalculationRequired();
    }

    public void setCallerCalculationRequired(boolean callerCalculationRequired) {
        this.callerCalculationRequired = callerCalculationRequired;
    }

    public final boolean isActivated() {
        return this.activated;
    }

    private synchronized void activate() {
        ExtLogRecord record;
        while ((record = this.logRecords.pollFirst()) != null) {
            if (!this.isEnabled() || !this.isLoggable(record)) continue;
            this.publishToChildren(record);
        }
        this.activated = true;
    }

    private void publishToChildren(ExtLogRecord record) {
        for (Handler handler : this.handlers) {
            handler.publish(record);
        }
    }
}

