/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.j2ee;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.wsf.spi.metadata.j2ee.JSESecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.PublishLocationAdapter;

public class JSEArchiveMetaData {
    private final String contextRoot;
    private final Map<String, String> servletMappings;
    private final Map<String, String> servletClassNames;
    private final String configName;
    private final String configFile;
    private final String securityDomain;
    private final PublishLocationAdapter publishLocationAdapter;
    private final List<JSESecurityMetaData> securityMetaData;

    protected JSEArchiveMetaData(String contextRoot, Map<String, String> servletMappings, Map<String, String> servletClassNames, String configName, String configFile, String securityDomain, PublishLocationAdapter publishLocationAdapter, List<JSESecurityMetaData> securityMetaData) {
        this.contextRoot = contextRoot;
        this.servletMappings = servletMappings != null && !servletMappings.isEmpty() ? Collections.unmodifiableMap(servletMappings) : Collections.emptyMap();
        this.servletClassNames = servletClassNames != null && !servletClassNames.isEmpty() ? Collections.unmodifiableMap(servletClassNames) : Collections.emptyMap();
        this.configName = configName;
        this.configFile = configFile;
        this.securityDomain = securityDomain;
        this.publishLocationAdapter = publishLocationAdapter;
        this.securityMetaData = securityMetaData != null && !securityMetaData.isEmpty() ? Collections.unmodifiableList(securityMetaData) : Collections.emptyList();
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public Map<String, String> getServletMappings() {
        return this.servletMappings;
    }

    public Map<String, String> getServletClassNames() {
        return this.servletClassNames;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public List<JSESecurityMetaData> getSecurityMetaData() {
        return this.securityMetaData;
    }

    public String getWsdlPublishLocationByName(String name) {
        if (this.publishLocationAdapter != null) {
            return this.publishLocationAdapter.getWsdlPublishLocationByName(name);
        }
        return null;
    }

    public static class Builder {
        private String contextRoot;
        private Map<String, String> servletMappings = new HashMap<String, String>();
        private Map<String, String> servletClassNames = new HashMap<String, String>();
        private String configName;
        private String configFile;
        private String securityDomain;
        private PublishLocationAdapter publishLocationAdapter;
        private List<JSESecurityMetaData> securityMetaData;

        public JSEArchiveMetaData build() {
            return new JSEArchiveMetaData(this.contextRoot, this.servletMappings, this.servletClassNames, this.configName, this.configFile, this.securityDomain, this.publishLocationAdapter, this.securityMetaData);
        }

        public String getContextRoot() {
            return this.contextRoot;
        }

        public void setContextRoot(String contextRoot) {
            this.contextRoot = contextRoot;
        }

        public Map<String, String> getServletMappings() {
            return this.servletMappings;
        }

        public void setServletMappings(Map<String, String> servletMappings) {
            this.servletMappings = servletMappings;
        }

        public Map<String, String> getServletClassNames() {
            return this.servletClassNames;
        }

        public void setServletClassNames(Map<String, String> servletClassNames) {
            this.servletClassNames = servletClassNames;
        }

        public String getConfigName() {
            return this.configName;
        }

        public void setConfigName(String configName) {
            this.configName = configName;
        }

        public String getConfigFile() {
            return this.configFile;
        }

        public void setConfigFile(String configFile) {
            this.configFile = configFile;
        }

        public String getSecurityDomain() {
            return this.securityDomain;
        }

        public void setSecurityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
        }

        public PublishLocationAdapter getPublishLocationAdapter() {
            return this.publishLocationAdapter;
        }

        public void setPublishLocationAdapter(PublishLocationAdapter publishLocationAdapter) {
            this.publishLocationAdapter = publishLocationAdapter;
        }

        public List<JSESecurityMetaData> getSecurityMetaData() {
            return this.securityMetaData;
        }

        public void setSecurityMetaData(List<JSESecurityMetaData> securityMetaData) {
            this.securityMetaData = securityMetaData;
        }
    }
}

