/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.DeferredExtensionContext;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.parsing.AccessControlXml;
import org.jboss.as.domain.management.parsing.AuditLogXml;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.domain.management.parsing.ManagementXmlDelegate;
import org.jboss.as.server.controller.resources.ServerRootResourceDefinition;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.HttpManagementResourceDefinition;
import org.jboss.as.server.mgmt.NativeManagementResourceDefinition;
import org.jboss.as.server.parsing.CommonXml;
import org.jboss.as.server.parsing.ExtensionHandler;
import org.jboss.as.server.parsing.SocketBindingsXml;
import org.jboss.as.server.parsing.StandaloneXml;
import org.jboss.as.server.services.net.SocketBindingGroupResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;

final class StandaloneXml_Legacy
extends CommonXml
implements ManagementXmlDelegate {
    private final AccessControlXml accessControlXml;
    private final ExtensionHandler extensionHandler;
    private final StandaloneXml.ParsingOption[] parsingOptions;
    private AuditLogXml auditLogDelegate;
    private final Namespace namespace;
    private final DeferredExtensionContext deferredExtensionContext;

    StandaloneXml_Legacy(ExtensionHandler extensionHandler, Namespace namespace, DeferredExtensionContext deferredExtensionContext, StandaloneXml.ParsingOption ... parsingOptions) {
        super(new SocketBindingsXml.ServerSocketBindingsXml());
        this.extensionHandler = extensionHandler;
        this.deferredExtensionContext = deferredExtensionContext;
        this.parsingOptions = parsingOptions;
        this.accessControlXml = AccessControlXml.newInstance((Namespace)namespace);
        this.auditLogDelegate = AuditLogXml.newInstance((Namespace)namespace, (boolean)false);
        this.namespace = namespace;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operationList) throws XMLStreamException {
        long start = System.currentTimeMillis();
        ModelNode address = new ModelNode().setEmptyList();
        if (Element.forName((String)reader.getLocalName()) != Element.SERVER) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        Namespace readerNS = Namespace.forUri((String)reader.getNamespaceURI());
        switch (readerNS) {
            case DOMAIN_1_0: {
                this.readServerElement_1_0(reader, address, operationList);
                break;
            }
            case DOMAIN_1_1: 
            case DOMAIN_1_2: 
            case DOMAIN_1_3: {
                this.readServerElement_1_1(readerNS, reader, address, operationList);
                break;
            }
            default: {
                boolean validNamespace = false;
                for (Namespace current : Namespace.domainValues()) {
                    if (!readerNS.equals((Object)current)) continue;
                    validNamespace = true;
                    this.readServerElement_1_4(readerNS, reader, address, operationList);
                    break;
                }
                if (validNamespace) break;
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
        if (ServerLogger.ROOT_LOGGER.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - start;
            ServerLogger.ROOT_LOGGER.debugf("Parsed standalone configuration in [%d] ms", elapsed);
        }
    }

    private void readServerElement_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        ModelNode serverName = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri((String)reader.getAttributeNamespace(i))) {
                case NONE: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            serverName = ServerRootResourceDefinition.NAME.parse(value, (XMLStreamReader)reader);
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, list, i);
                            continue block11;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.setServerName(address, list, serverName);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        if (element == Element.EXTENSIONS) {
            this.extensionHandler.parseExtensions(reader, address, Namespace.DOMAIN_1_0, list);
            this.deferredExtensionContext.load();
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, Namespace.DOMAIN_1_0, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, Namespace.DOMAIN_1_0, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.MANAGEMENT) {
            ManagementXml managementXml = ManagementXml.newInstance((Namespace)Namespace.DOMAIN_1_0, (ManagementXmlDelegate)this, (boolean)false);
            managementXml.parseManagement(reader, address, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.PROFILE) {
            this.parseServerProfile(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, Namespace.DOMAIN_1_0, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.SOCKET_BINDING_GROUP) {
            this.parseSocketBindingGroup_1_0(reader, interfaceNames, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, Namespace.DOMAIN_1_0, list, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME, Attribute.ENABLED), EnumSet.of(Element.CONTENT, Element.FS_ARCHIVE, Element.FS_EXPLODED), true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)Namespace.DOMAIN_1_0);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readServerElement_1_1(Namespace namespace, XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        ModelNode serverName = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri((String)reader.getAttributeNamespace(i))) {
                case NONE: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            serverName = ServerRootResourceDefinition.NAME.parse(value, (XMLStreamReader)reader);
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, list, i);
                            continue block11;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.setServerName(address, list, serverName);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        if (element == Element.EXTENSIONS) {
            this.extensionHandler.parseExtensions(reader, address, namespace, list);
            this.deferredExtensionContext.load();
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.VAULT) {
            this.parseVault(reader, address, namespace, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.MANAGEMENT) {
            ManagementXml managementXml = ManagementXml.newInstance((Namespace)namespace, (ManagementXmlDelegate)this, (boolean)false);
            managementXml.parseManagement(reader, address, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.PROFILE) {
            this.parseServerProfile(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.SOCKET_BINDING_GROUP) {
            this.parseSocketBindingGroup_1_1(reader, interfaceNames, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, namespace, list, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME, Attribute.ENABLED), EnumSet.of(Element.CONTENT, Element.FS_ARCHIVE, Element.FS_EXPLODED), true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readServerElement_1_4(Namespace namespace, XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.parseNamespaces(reader, address, list);
        ModelNode serverName = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            switch (Namespace.forUri((String)reader.getAttributeNamespace(i))) {
                case NONE: {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            serverName = ServerRootResourceDefinition.NAME.parse(value, (XMLStreamReader)reader);
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case XML_SCHEMA_INSTANCE: {
                    switch (Attribute.forName((String)reader.getAttributeLocalName(i))) {
                        case SCHEMA_LOCATION: {
                            this.parseSchemaLocations(reader, address, list, i);
                            continue block11;
                        }
                        case NO_NAMESPACE_SCHEMA_LOCATION: {
                            continue block11;
                        }
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.setServerName(address, list, serverName);
        Element element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        if (element == Element.EXTENSIONS) {
            this.extensionHandler.parseExtensions(reader, address, namespace, list);
            this.deferredExtensionContext.load();
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.SYSTEM_PROPERTIES) {
            this.parseSystemProperties(reader, address, namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.PATHS) {
            this.parsePaths(reader, address, namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.VAULT) {
            this.parseVault(reader, address, namespace, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.MANAGEMENT) {
            ManagementXml managementXml = ManagementXml.newInstance((Namespace)namespace, (ManagementXmlDelegate)this, (boolean)false);
            managementXml.parseManagement(reader, address, list, false);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.PROFILE) {
            this.parseServerProfile(reader, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        HashSet<String> interfaceNames = new HashSet<String>();
        if (element == Element.INTERFACES) {
            this.parseInterfaces(reader, interfaceNames, address, namespace, list, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.SOCKET_BINDING_GROUP) {
            this.parseSocketBindingGroup_1_1(reader, interfaceNames, address, list);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.DEPLOYMENTS) {
            this.parseDeployments(reader, address, namespace, list, EnumSet.of(Attribute.NAME, Attribute.RUNTIME_NAME, Attribute.ENABLED), EnumSet.of(Element.CONTENT, Element.FS_ARCHIVE, Element.FS_EXPLODED), true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element == Element.DEPLOYMENT_OVERLAYS) {
            this.parseDeploymentOverlays(reader, namespace, new ModelNode(), list, true, true);
            element = ParseUtils.nextElement((XMLExtendedStreamReader)reader, (Namespace)namespace);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseManagementInterfaces_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case NATIVE_INTERFACE: {
                    this.parseNativeManagementInterface1_0(reader, address, list);
                    continue block4;
                }
                case HTTP_INTERFACE: {
                    this.parseHttpManagementInterface1_0(reader, address, list);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseHttpManagementInterface1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode mgmtSocket = new ModelNode();
        mgmtSocket.get("operation").set("add");
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", "http-interface");
        mgmtSocket.get("address").set(operationAddress);
        boolean hasInterfaceName = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_THREADS: {
                    continue block4;
                }
                case SECURITY_REALM: {
                    HttpManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, mgmtSocket, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!hasInterfaceName) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
        list.add(mgmtSocket);
    }

    private void parseNativeManagementInterface1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode mgmtSocket = new ModelNode();
        mgmtSocket.get("operation").set("add");
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", "native-interface");
        mgmtSocket.get("address").set(operationAddress);
        boolean hasInterface = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURE_PORT: {
                    continue block4;
                }
                case SECURITY_REALM: {
                    NativeManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, mgmtSocket, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        if (!hasInterface) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.INTERFACE.getLocalName()));
        }
        list.add(mgmtSocket);
    }

    private void parseManagementInterfaces_1_1(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case NATIVE_INTERFACE: {
                    switch (this.namespace.getMajorVersion()) {
                        case 1: {
                            this.parseManagementInterface1_1(reader, address, false, list);
                            continue block11;
                        }
                    }
                    this.parseManagementInterface2_0(reader, address, false, list);
                    continue block11;
                }
                case HTTP_INTERFACE: {
                    switch (this.namespace.getMajorVersion()) {
                        case 1: {
                            this.parseManagementInterface1_1(reader, address, true, list);
                            continue block11;
                        }
                    }
                    this.parseManagementInterface2_0(reader, address, true, list);
                    continue block11;
                }
                case NATIVE_REMOTING_INTERFACE: {
                    this.parseNativeRemotingManagementInterface(reader, address, list);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseManagementInterface1_1(XMLExtendedStreamReader reader, ModelNode address, boolean http, List<ModelNode> list) throws XMLStreamException {
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", http ? "http-interface" : "native-interface");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)operationAddress);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    if (http) {
                        HttpManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                        continue block8;
                    }
                    NativeManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block8;
                }
                case CONSOLE_ENABLED: {
                    if (!http) continue block8;
                    HttpManagementResourceDefinition.CONSOLE_ENABLED.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET: {
                    if (http) {
                        this.parseHttpManagementSocket(reader);
                        continue block9;
                    }
                    this.parseNativeManagementSocket(reader);
                    continue block9;
                }
                case SOCKET_BINDING: {
                    if (http) {
                        this.parseHttpManagementSocketBinding(reader, addOp);
                        continue block9;
                    }
                    this.parseNativeManagementSocketBinding(reader, addOp);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(addOp);
    }

    private void parseHttpManagementInterfaceAttributes2_0(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    HttpManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case CONSOLE_ENABLED: {
                    HttpManagementResourceDefinition.CONSOLE_ENABLED.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case HTTP_UPGRADE_ENABLED: {
                    ModelNode httpUpgrade = addOp.get("http-upgrade");
                    HttpManagementResourceDefinition.ENABLED.parseAndSetParameter(value, httpUpgrade, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseHttpManagementInterfaceAttributes3_0(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SASL_PROTOCOL: {
                    HttpManagementResourceDefinition.SASL_PROTOCOL.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block8;
                }
                case SECURITY_REALM: {
                    HttpManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block8;
                }
                case SERVER_NAME: {
                    HttpManagementResourceDefinition.SERVER_NAME.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block8;
                }
                case CONSOLE_ENABLED: {
                    HttpManagementResourceDefinition.CONSOLE_ENABLED.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block8;
                }
                case HTTP_UPGRADE_ENABLED: {
                    ModelNode httpUpgrade = addOp.get("http-upgrade");
                    HttpManagementResourceDefinition.ENABLED.parseAndSetParameter(value, httpUpgrade, (XMLStreamReader)reader);
                    continue block8;
                }
                case ALLOWED_ORIGINS: {
                    for (String origin : reader.getListAttributeValue(i)) {
                        HttpManagementResourceDefinition.ALLOWED_ORIGINS.parseAndAddParameterElement(origin, addOp, (XMLStreamReader)reader);
                    }
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseNativeManagementInterfaceAttributes2_0(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    NativeManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseNativeManagementInterfaceAttributes3_0(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SASL_PROTOCOL: {
                    NativeManagementResourceDefinition.SASL_PROTOCOL.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case SECURITY_REALM: {
                    NativeManagementResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case SERVER_NAME: {
                    NativeManagementResourceDefinition.SERVER_NAME.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
    }

    private void parseManagementInterface2_0(XMLExtendedStreamReader reader, ModelNode address, boolean http, List<ModelNode> list) throws XMLStreamException {
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", http ? "http-interface" : "native-interface");
        ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)operationAddress);
        switch (this.namespace.getMajorVersion()) {
            case 2: {
                if (http) {
                    this.parseHttpManagementInterfaceAttributes2_0(reader, addOp);
                    break;
                }
                this.parseNativeManagementInterfaceAttributes2_0(reader, addOp);
                break;
            }
            default: {
                if (http) {
                    this.parseHttpManagementInterfaceAttributes3_0(reader, addOp);
                    break;
                }
                this.parseNativeManagementInterfaceAttributes3_0(reader, addOp);
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET: {
                    if (http) {
                        this.parseHttpManagementSocket(reader);
                        continue block7;
                    }
                    this.parseNativeManagementSocket(reader);
                    continue block7;
                }
                case SOCKET_BINDING: {
                    if (http) {
                        this.parseHttpManagementSocketBinding(reader, addOp);
                        continue block7;
                    }
                    this.parseNativeManagementSocketBinding(reader, addOp);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        list.add(addOp);
    }

    private void parseNativeManagementSocket(XMLExtendedStreamReader reader) throws XMLStreamException {
        throw ControllerLogger.ROOT_LOGGER.unsupportedElement(reader.getName(), reader.getLocation(), "socket-binding");
    }

    private void parseHttpManagementSocket(XMLExtendedStreamReader reader) throws XMLStreamException {
        throw ControllerLogger.ROOT_LOGGER.unsupportedElement(reader.getName(), reader.getLocation(), "socket-binding");
    }

    private void parseHttpManagementSocketBinding(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case HTTP: {
                    HttpManagementResourceDefinition.SOCKET_BINDING.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                case HTTPS: {
                    HttpManagementResourceDefinition.SECURE_SOCKET_BINDING.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseNativeManagementSocketBinding(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean hasRef = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NATIVE: {
                    NativeManagementResourceDefinition.SOCKET_BINDING.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    hasRef = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!hasRef) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.REF.getLocalName()));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseNativeRemotingManagementInterface(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode connector = new ModelNode();
        connector.get("operation").set("add");
        ModelNode operationAddress = address.clone();
        operationAddress.add("management-interface", "native-remoting-interface");
        connector.get("address").set(operationAddress);
        list.add(connector);
        reader.discardRemainder();
    }

    private void parseSocketBindingGroup_1_0(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        HashSet<String> uniqueBindingNames = new HashSet<String>();
        ModelNode op = Util.getEmptyOperation((String)"add", null);
        String socketBindingGroupName = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.DEFAULT_INTERFACE);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    socketBindingGroupName = value;
                    required.remove(attribute);
                    continue block8;
                }
                case DEFAULT_INTERFACE: {
                    SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    required.remove(attribute);
                    if (op.get(SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.getName()).getType() == ModelType.EXPRESSION || interfaces.contains(value)) continue block8;
                    throw ControllerLogger.ROOT_LOGGER.unknownInterface(value, Attribute.DEFAULT_INTERFACE.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
                }
                case PORT_OFFSET: {
                    SocketBindingGroupResourceDefinition.PORT_OFFSET.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode groupAddress = address.clone().add("socket-binding-group", socketBindingGroupName);
        op.get("address").set(groupAddress);
        updates.add(op);
        block9: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block9;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSocketBindingGroup_1_1(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        HashSet<String> uniqueBindingNames = new HashSet<String>();
        ModelNode op = Util.getEmptyOperation((String)"add", null);
        String socketBindingGroupName = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.DEFAULT_INTERFACE);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    socketBindingGroupName = value;
                    required.remove(attribute);
                    continue block9;
                }
                case DEFAULT_INTERFACE: {
                    SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    required.remove(attribute);
                    if (op.get(SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.getName()).getType() == ModelType.EXPRESSION || interfaces.contains(value)) continue block9;
                    throw ControllerLogger.ROOT_LOGGER.unknownInterface(value, Attribute.DEFAULT_INTERFACE.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
                }
                case PORT_OFFSET: {
                    SocketBindingGroupResourceDefinition.PORT_OFFSET.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ModelNode groupAddress = address.clone().add("socket-binding-group", socketBindingGroupName);
        op.get("address").set(groupAddress);
        updates.add(op);
        block10: while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SOCKET_BINDING: {
                    String bindingName = this.parseSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block10;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
                case OUTBOUND_SOCKET_BINDING: {
                    String bindingName = this.parseOutboundSocketBinding(reader, interfaces, groupAddress, updates);
                    if (uniqueBindingNames.add(bindingName)) continue block10;
                    throw ControllerLogger.ROOT_LOGGER.alreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), bindingName, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName, reader.getLocation());
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerProfile(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        LinkedHashMap profileOps = new LinkedHashMap();
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (Element.forName((String)reader.getLocalName()) != Element.SUBSYSTEM) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String namespace = reader.getNamespaceURI();
            if (profileOps.containsKey(namespace)) {
                throw ControllerLogger.ROOT_LOGGER.duplicateDeclaration("subsystem", reader.getLocation());
            }
            ArrayList subsystems = new ArrayList();
            try {
                reader.handleAny(subsystems);
            }
            catch (XMLStreamException e) {
                if (StandaloneXml.ParsingOption.IGNORE_SUBSYSTEM_FAILURES.isSet(this.parsingOptions)) {
                    QName element = new QName(reader.getNamespaceURI(), reader.getLocalName());
                    ControllerLogger.ROOT_LOGGER.failedToParseElementLenient(e, element.toString());
                    reader.discardRemainder();
                }
                throw e;
            }
            profileOps.put(namespace, subsystems);
        }
        Set<ProfileParsingCompletionHandler> completionHandlers = this.extensionHandler.getProfileParsingCompletionHandlers();
        for (ProfileParsingCompletionHandler completionHandler : completionHandlers) {
            completionHandler.handleProfileParsingCompletion(profileOps, list);
        }
        for (List subsystems : profileOps.values()) {
            for (ModelNode update : subsystems) {
                ModelNode subsystemAddress = address.clone();
                for (Property path : update.get("address").asPropertyList()) {
                    subsystemAddress.add(path.getName(), path.getValue().asString());
                }
                update.get("address").set(subsystemAddress);
                list.add(update);
            }
        }
    }

    private void setServerName(ModelNode address, List<ModelNode> operationList, ModelNode value) {
        if (value != null && value.isDefined() && value.asString().length() > 0) {
            ModelNode update = Util.getWriteAttributeOperation((ModelNode)address, (String)"name", (ModelNode)value);
            operationList.add(update);
        }
    }

    public boolean parseManagementInterfaces(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operationsList) throws XMLStreamException {
        switch (this.namespace) {
            case DOMAIN_1_0: {
                this.parseManagementInterfaces_1_0(reader, address, operationsList);
                break;
            }
            default: {
                this.parseManagementInterfaces_1_1(reader, address, operationsList);
            }
        }
        return true;
    }

    public boolean parseAccessControl(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operationsList) throws XMLStreamException {
        ModelNode accAuthzAddr = address.clone().add("access", "authorization");
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            ModelNode op;
            ModelNode provider;
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attribute == Attribute.PROVIDER) {
                provider = AccessAuthorizationResourceDefinition.PROVIDER.parse(value, (XMLStreamReader)reader);
                op = Util.getWriteAttributeOperation((ModelNode)accAuthzAddr, (String)AccessAuthorizationResourceDefinition.PROVIDER.getName(), (ModelNode)provider);
                operationsList.add(op);
                continue;
            }
            if (attribute == Attribute.PERMISSION_COMBINATION_POLICY) {
                provider = AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.parse(value, (XMLStreamReader)reader);
                op = Util.getWriteAttributeOperation((ModelNode)accAuthzAddr, (String)AccessAuthorizationResourceDefinition.PERMISSION_COMBINATION_POLICY.getName(), (ModelNode)provider);
                operationsList.add(op);
                continue;
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
        }
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ROLE_MAPPING: {
                    this.accessControlXml.parseAccessControlRoleMapping(reader, accAuthzAddr, operationsList);
                    continue block5;
                }
                case CONSTRAINTS: {
                    this.accessControlXml.parseAccessControlConstraints(reader, accAuthzAddr, operationsList);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return true;
    }

    public boolean parseAuditLog(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        this.auditLogDelegate.parseAuditLog(reader, address, this.namespace, list);
        return true;
    }
}

