/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.reader.MapMessageUtil;
import org.apache.activemq.artemis.utils.collections.TypedProperties;

public final class ActiveMQMapMessage
extends ActiveMQMessage
implements MapMessage {
    public static final byte TYPE = 5;
    private final TypedProperties map = new TypedProperties();
    private boolean invalid;

    protected ActiveMQMapMessage(ClientSession session) {
        super((byte)5, session);
        this.invalid = true;
    }

    protected ActiveMQMapMessage(ClientMessage message, ClientSession session) {
        super(message, session);
        this.invalid = false;
    }

    public ActiveMQMapMessage() {
        this.invalid = false;
    }

    public ActiveMQMapMessage(MapMessage foreign, ClientSession session) throws JMSException {
        super(foreign, (byte)5, session);
        Enumeration names = foreign.getMapNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object obj = foreign.getObject(name);
            this.setObject(name, obj);
        }
    }

    @Override
    public byte getType() {
        return 5;
    }

    @Override
    public void setBoolean(String name, boolean value) throws JMSException {
        this.checkName(name);
        this.map.putBooleanProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    @Override
    public void setByte(String name, byte value) throws JMSException {
        this.checkName(name);
        this.map.putByteProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    @Override
    public void setShort(String name, short value) throws JMSException {
        this.checkName(name);
        this.map.putShortProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    @Override
    public void setChar(String name, char value) throws JMSException {
        this.checkName(name);
        this.map.putCharProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    @Override
    public void setInt(String name, int value) throws JMSException {
        this.checkName(name);
        this.map.putIntProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    @Override
    public void setLong(String name, long value) throws JMSException {
        this.checkName(name);
        this.map.putLongProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    @Override
    public void setFloat(String name, float value) throws JMSException {
        this.checkName(name);
        this.map.putFloatProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    @Override
    public void setDouble(String name, double value) throws JMSException {
        this.checkName(name);
        this.map.putDoubleProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    @Override
    public void setString(String name, String value) throws JMSException {
        this.checkName(name);
        this.map.putSimpleStringProperty(new SimpleString(name), value == null ? null : new SimpleString(value));
        this.invalid = true;
    }

    @Override
    public void setBytes(String name, byte[] value) throws JMSException {
        this.checkName(name);
        this.map.putBytesProperty(new SimpleString(name), value);
        this.invalid = true;
    }

    @Override
    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkName(name);
        if (offset + length > value.length) {
            throw new JMSException("Invalid offset/length");
        }
        byte[] newBytes = new byte[length];
        System.arraycopy(value, offset, newBytes, 0, length);
        this.map.putBytesProperty(new SimpleString(name), newBytes);
        this.invalid = true;
    }

    @Override
    public void setObject(String name, Object value) throws JMSException {
        this.checkName(name);
        try {
            TypedProperties.setObjectProperty(new SimpleString(name), value, this.map);
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
        this.invalid = true;
    }

    @Override
    public boolean getBoolean(String name) throws JMSException {
        try {
            return this.map.getBooleanProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public byte getByte(String name) throws JMSException {
        try {
            return this.map.getByteProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public short getShort(String name) throws JMSException {
        try {
            return this.map.getShortProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public char getChar(String name) throws JMSException {
        try {
            return this.map.getCharProperty(new SimpleString(name)).charValue();
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public int getInt(String name) throws JMSException {
        try {
            return this.map.getIntProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public long getLong(String name) throws JMSException {
        try {
            return this.map.getLongProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public float getFloat(String name) throws JMSException {
        try {
            return this.map.getFloatProperty(new SimpleString(name)).floatValue();
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public double getDouble(String name) throws JMSException {
        try {
            return this.map.getDoubleProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public String getString(String name) throws JMSException {
        try {
            SimpleString str = this.map.getSimpleStringProperty(new SimpleString(name));
            if (str == null) {
                return null;
            }
            return str.toString();
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public byte[] getBytes(String name) throws JMSException {
        try {
            return this.map.getBytesProperty(new SimpleString(name));
        }
        catch (ActiveMQPropertyConversionException e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    @Override
    public Object getObject(String name) throws JMSException {
        Object val = this.map.getProperty(new SimpleString(name));
        if (val instanceof SimpleString) {
            val = ((SimpleString)val).toString();
        }
        return val;
    }

    @Override
    public Enumeration getMapNames() throws JMSException {
        Set<SimpleString> simplePropNames = this.map.getPropertyNames();
        HashSet<String> propNames = new HashSet<String>(simplePropNames.size());
        for (SimpleString str : simplePropNames) {
            propNames.add(str.toString());
        }
        return Collections.enumeration(propNames);
    }

    @Override
    public boolean itemExists(String name) throws JMSException {
        return this.map.containsProperty(new SimpleString(name));
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.map.clear();
        this.invalid = true;
    }

    @Override
    public void doBeforeSend() throws Exception {
        if (this.invalid) {
            MapMessageUtil.writeBodyMap(this.message.getBodyBuffer(), this.map);
            this.invalid = false;
        }
        super.doBeforeSend();
    }

    @Override
    public void doBeforeReceive() throws ActiveMQException {
        super.doBeforeReceive();
        MapMessageUtil.readBodyMap(this.message.getBodyBuffer(), this.map);
    }

    private void checkName(String name) throws JMSException {
        this.checkWrite();
        if (name == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nameCannotBeNull();
        }
        if (name.equals("")) {
            throw ActiveMQJMSClientBundle.BUNDLE.nameCannotBeEmpty();
        }
    }

    @Override
    protected boolean hasNoBody() {
        return this.map.isEmpty();
    }

    @Override
    public boolean isBodyAssignableTo(Class c) {
        if (this.hasNoBody()) {
            return true;
        }
        return c.isAssignableFrom(Map.class);
    }

    @Override
    protected <T> T getBodyInternal(Class<T> c) {
        return (T)this.map.getMap();
    }
}

